/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.others;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.general.home.CommandSetHome;
import org.kingdoms.commands.general.text.CommandRename;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.stats.DefaultStats;
import org.kingdoms.constants.stats.NumberStat;
import org.kingdoms.events.lands.ClaimLandEvent;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.managers.land.claiming.ClaimProcessor;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;
import org.kingdoms.services.ServiceVault;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.cooldown.Cooldown;
import org.kingdoms.utils.string.Strings;

public class CommandCreate
extends KingdomsCommand {
    private static final Cooldown<Integer> CONFIRMATION_COOLDOWN = new Cooldown();

    public CommandCreate() {
        super("create", true);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        Block block;
        Land land;
        if (context.assertEnabledWorld()) {
            return CommandResult.FAILED;
        }
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (kp.hasKingdom()) {
            context.sendError(KingdomsLang.COMMAND_CREATE_ALREADY_IN_KINGDOM, new Object[0]);
            return CommandResult.FAILED;
        }
        String name = Strings.buildArguments(context.args, KingdomsConfig.KINGDOM_NAME_ALLOW_SPACES.getBoolean() ? " " : "");
        if (CommandRename.forbidden(player, name)) {
            return CommandResult.FAILED;
        }
        if (!context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_CREATE_BYPASS_COST)) {
            if (!CommandRename.checkName(name, player)) {
                return CommandResult.FAILED;
            }
            if (ServiceHandler.bankServiceAvailable()) {
                long createdKingdoms = kp.getStatistics().find(DefaultStats.KingdomPlayer.KINGDOMS_CREATED).orElse(new NumberStat(0L)).asNumber();
                double cost = MathUtils.eval(KingdomsConfig.ECONOMY_COSTS_CREATE_KINGDOM.getMathExpression(), (PlaceholderProvider)new PlaceholderContextBuilder().withContext(player).raw("create_count", createdKingdoms));
                if (cost > 0.0) {
                    if (!ServiceVault.hasMoney((OfflinePlayer)player, cost)) {
                        KingdomsLang.COMMAND_CREATE_COST.sendMessage((CommandSender)player, "cost", cost);
                        return CommandResult.FAILED;
                    }
                    if (!CONFIRMATION_COOLDOWN.add((Integer)player.getEntityId(), KingdomsConfig.ECONOMY_CREATE_CONFIRMATION.getTimeMillis())) {
                        KingdomsLang.COMMAND_CREATE_CONFIRMATION.sendMessage((CommandSender)player, "cost", cost);
                        return CommandResult.FAILED;
                    }
                    ServiceVault.withdraw((OfflinePlayer)player, cost);
                }
            }
        }
        Kingdom kingdom = new Kingdom(player.getUniqueId(), name);
        kp.getStatistics().inc(DefaultStats.KingdomPlayer.KINGDOMS_CREATED);
        if (KingdomsConfig.ANNOUNCEMENTS_CREATE_KINGDOM.getBoolean()) {
            for (Player online : Bukkit.getOnlinePlayers()) {
                KingdomsLang.COMMAND_CREATE_ANNOUNCE.sendMessage((CommandSender)online, (OfflinePlayer)player, new Object[]{"kingdom", name});
            }
        } else {
            KingdomsLang.COMMAND_CREATE_SUCCESS.sendMessage((CommandSender)player, "kingdom", name);
        }
        if (KingdomsConfig.Invasions.PACIFISM_ENABLED.getManager().getBoolean() && KingdomsConfig.CREATION_KINGDOMS_SHOW_KINGDOM_TYPE_GUI.getBoolean()) {
            InteractiveGUI gui = GUIAccessor.prepare(player, KingdomsGUI.KINGDOM$CREATE);
            if (gui == null) {
                return CommandResult.FAILED;
            }
            gui.push("pacifist", () -> {
                if (kingdom.setPacifist(true, kp, null).isCancelled()) {
                    return;
                }
                KingdomsLang.COMMAND_CREATE_PACIFIST.sendMessage((CommandSender)player);
                player.closeInventory();
            }, new Object[0]).push("aggressor", () -> {
                if (kingdom.setPacifist(false, kp, null).isCancelled()) {
                    return;
                }
                KingdomsLang.COMMAND_CREATE_AGGRESSOR.sendMessage((CommandSender)player);
                player.closeInventory();
            }, new Object[0]);
            gui.open();
        }
        SimpleChunkLocation chunkLocation = SimpleChunkLocation.of(player.getLocation());
        int claims = KingdomsConfig.Claims.CLAIM_ON_CREATE.getManager().getInt();
        boolean currentChunkClaimed = false;
        if (claims >= 0 && claims <= 100) {
            SimpleChunkLocation[] chunks;
            SimpleChunkLocation[] simpleChunkLocationArray;
            HashSet<SimpleChunkLocation> finalClaims = new HashSet<SimpleChunkLocation>(claims);
            if (claims == 0) {
                SimpleChunkLocation[] simpleChunkLocationArray2 = new SimpleChunkLocation[1];
                simpleChunkLocationArray = simpleChunkLocationArray2;
                simpleChunkLocationArray2[0] = chunkLocation;
            } else {
                simpleChunkLocationArray = chunkLocation.getChunksAround(claims, true);
            }
            for (SimpleChunkLocation chunk : chunks = simpleChunkLocationArray) {
                ClaimProcessor claimProcessor = ClaimProcessor.build(chunk, kp, kingdom).process();
                boolean canClaim = claimProcessor.isSuccessful();
                if (chunk.equalsIgnoreWorld(chunkLocation)) {
                    currentChunkClaimed = canClaim;
                }
                if (!canClaim) continue;
                finalClaims.add(chunk);
                claimProcessor.finalizeProcess();
            }
            if (!finalClaims.isEmpty()) {
                kingdom.claim(finalClaims, kp, ClaimLandEvent.Reason.INITIAL_KINGDOM_CLAIMS, false);
            }
        }
        if (KingdomsConfig.HOME_SET_ON_CREATE.getBoolean()) {
            if (KingdomsConfig.HOME_CLAIMED.getBoolean()) {
                if (currentChunkClaimed) {
                    CommandSetHome.setHome(kingdom, BukkitAdapter.adapt(player.getLocation().add(0.0, 1.0, 0.0)), kp);
                }
            } else {
                CommandSetHome.setHome(kingdom, BukkitAdapter.adapt(player.getLocation().add(0.0, 1.0, 0.0)), kp);
            }
        }
        if (currentChunkClaimed && KingdomsConfig.NEXUS_PLACE_ON_CREATE.getBoolean() && (land = chunkLocation.getLand()) != null && !LocationUtils.exceedsBuildLimit(player.getLocation()) && (block = LocationUtils.findEmptyBlock(player.getLocation().getBlock())) != null) {
            kingdom.placeOrMoveNexus(BukkitAdapter.adapt(block.getLocation()), kp);
        }
        XSound.play((String)KingdomsConfig.CREATION_KINGDOMS_SOUND.getString(), x -> x.forPlayers(new Player[]{player}));
        CONFIRMATION_COOLDOWN.stop(player.getEntityId());
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        if (context.isAtArg(0)) {
            return context.tabComplete((Messenger)KingdomsLang.COMMAND_CREATE_TAB_COMPLETION_NAME);
        }
        return new ArrayList<String>();
    }
}

