/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.others;

import java.awt.Color;
import java.util.List;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.themes.ThemeProvider;
import org.kingdoms.constants.themes.Themes;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.ThemeManager;
import org.kingdoms.utils.ColorUtils;

public class CommandColor
extends KingdomsCommand {
    public CommandColor() {
        super("color", true);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        Color color;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        Kingdom kingdom = context.getKingdom();
        if (context.argsLengthEquals(0)) {
            new ThemeManager(context.senderAsPlayer(), kingdom).groupColorTypes();
            return CommandResult.SUCCESS;
        }
        if (context.requireArgs(2)) {
            return CommandResult.FAILED;
        }
        Namespace colorType = context.nextNamespace();
        ThemeProvider provider = (ThemeProvider)((Object)Themes.INSTANCE.getRegistered(colorType));
        if (provider == null) {
            context.var("theme", colorType.asNormalizedString());
            return context.fail(KingdomsLang.THEMES_UNKNOWN_THEME);
        }
        String colorStr = context.joinArgs(" ", 1);
        context.var("color", colorStr);
        try {
            color = ColorUtils.parseColor(colorStr);
        }
        catch (Throwable ex) {
            color = null;
        }
        if (color == null) {
            context.sendError(KingdomsLang.THEMES_WRONG_HEX, new Object[0]);
            return CommandResult.FAILED;
        }
        context.var("r", color.getRed()).var("b", color.getBlue()).var("g", color.getGreen()).var("hex", color.getRGB()).var("color", ColorUtils.toHexString(color));
        if (!context.isAdmin() && !provider.isThemeAllowed(kingdom, color)) {
            context.sendError(KingdomsLang.THEMES_DISALLOWED, new Object[0]);
            return CommandResult.FAILED;
        }
        context.sendMessage((Messenger)KingdomsLang.THEMES_SET, new Object[0]);
        kingdom.setColor(colorType, color, context.getKingdomPlayer());
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        return context.completeNext(() -> context.tabParameter("theme", true)).then(() -> context.tabComplete(KingdomsLang.COMMAND_COLOR_TAB_COMPLETION_HEX, KingdomsLang.COMMAND_COLOR_TAB_COMPLETION_RGB)).build();
    }
}

