/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.invitations;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.general.invitations.CommandAccept;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.InviteCode;
import org.kingdoms.constants.item.KingdomItem;
import org.kingdoms.constants.item.KingdomItemData;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.OptionHandler;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.gui.pagination.GUIPagination;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Pair;
import org.kingdoms.libs.kotlin.TuplesKt;
import org.kingdoms.libs.kotlin.collections.MapsKt;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.Ref;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.ranges.RangesKt;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.SimpleContextualMessageSender;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.nbt.tag.NBTTag;
import org.kingdoms.nbt.tag.NBTTagCompound;
import org.kingdoms.nbt.tag.NBTTagType;
import org.kingdoms.utils.KingdomsItemDeserializer;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.internal.uuid.FastUUID;
import org.kingdoms.utils.time.TimeFormatter;
import org.kingdoms.utils.time.TimeUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u00012\u00020\u0002:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/commands/general/invitations/CommandInviteCodes;", "Lorg/kingdoms/commands/KingdomsCommand;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onInviteAccept", "", "event", "Lorg/bukkit/event/player/PlayerInteractEvent;", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nCommandInviteCodes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandInviteCodes.kt\norg/kingdoms/commands/general/invitations/CommandInviteCodes\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,293:1\n1863#2,2:294\n*S KotlinDebug\n*F\n+ 1 CommandInviteCodes.kt\norg/kingdoms/commands/general/invitations/CommandInviteCodes\n*L\n88#1:294,2\n*E\n"})
public final class CommandInviteCodes
extends KingdomsCommand
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Namespace INVITE_CODE_NS;

    public CommandInviteCodes() {
        super("invitecodes", true);
    }

    @EventHandler
    public final void onInviteAccept(@NotNull PlayerInteractEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Player player2 = player;
        ItemStack itemStack = player2.getInventory().getItemInMainHand();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInMainHand(...)");
        ItemStack item = itemStack;
        Pair<UUID, String> pair = Companion.getInviteCodeFrom(item);
        if (pair == null) {
            return;
        }
        Pair<UUID, String> pair2 = pair;
        UUID kingdomId = (UUID)pair2.component1();
        String code = (String)pair2.component2();
        Kingdom kingdom = Kingdom.getKingdom(kingdomId);
        if (kingdom == null) {
            KingdomsLang.INVITE_CODES_KINGDOM_DOESNT_EXIST.sendError((CommandSender)player2, new Object[0]);
            return;
        }
        SimpleContextualMessageSender messenger = new SimpleContextualMessageSender((CommandSender)player2, new MessagePlaceholderProvider().withContext(kingdom));
        InviteCode inviteCode = kingdom.getInviteCodes().get(code);
        if (inviteCode == null || inviteCode.hasExpired()) {
            messenger.sendError(KingdomsLang.INVITE_CODES_NO_LONGER_VALID, new Object[0]);
            return;
        }
        if (inviteCode.isAllUsed()) {
            messenger.sendError(KingdomsLang.INVITE_CODES_MAX_USES, new Object[0]);
            return;
        }
        KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player2);
        Intrinsics.checkNotNullExpressionValue((Object)kingdomPlayer, (String)"getKingdomPlayer(...)");
        KingdomPlayer kp = kingdomPlayer;
        if (kp.hasKingdom()) {
            messenger.sendError(KingdomsLang.COMMAND_JOIN_ALREADY_IN_KINGDOM, new Object[0]);
            return;
        }
        KingdomsLang requirement = CommandAccept.checkRequirementsToJoin(player2, kingdom);
        if (requirement != null) {
            messenger.sendError(requirement, new Object[0]);
            return;
        }
        inviteCode.getUsedBy().add(player2.getUniqueId());
        kp.joinKingdom(kingdom);
        List<Player> list = kingdom.getOnlineMembers();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getOnlineMembers(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player x = (Player)element$iv;
            boolean bl = false;
            KingdomsLang.INVITE_CODES_USED.sendMessage((CommandSender)x);
        }
        if (item.getAmount() == 1) {
            player2.getInventory().setItemInMainHand(null);
        } else {
            int n = item.getAmount();
            item.setAmount(n + -1);
        }
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = context.getKingdomPlayer();
        if (!kp.hasPermission(StandardKingdomPermission.INVITE)) {
            StandardKingdomPermission.INVITE.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        Intrinsics.checkNotNull((Object)player);
        Kingdom kingdom = kp.getKingdom();
        Intrinsics.checkNotNull((Object)kingdom);
        Companion.openGUI(player, kingdom);
        return CommandResult.SUCCESS;
    }

    static {
        Namespace namespace = Namespace.kingdoms("INVITE_CODE");
        Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"kingdoms(...)");
        INVITE_CODE_NS = namespace;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001f\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\u001e\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001c\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001b2\u0006\u0010\u001d\u001a\u00020\u001eJ\u001e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/kingdoms/commands/general/invitations/CommandInviteCodes$Companion;", "", "<init>", "()V", "INVITE_CODE_NS", "Lorg/kingdoms/constants/namespace/Namespace;", "Lorg/kingdoms/libs/jetbrains/annotations/NotNull;", "openGUI", "Lorg/kingdoms/gui/InteractiveGUI;", "player", "Lorg/bukkit/entity/Player;", "kingdom", "Lorg/kingdoms/constants/group/Kingdom;", "page", "", "durationOfInviteCode", "", "ctx", "Lorg/kingdoms/gui/OptionHandler;", "input", "", "(Lorg/kingdoms/gui/OptionHandler;Ljava/lang/String;)Ljava/lang/Long;", "getEditsOf", "", "inviteCode", "Lorg/kingdoms/constants/group/model/InviteCode;", "getInviteCodeFrom", "Lorg/kingdoms/libs/kotlin/Pair;", "Ljava/util/UUID;", "item", "Lorg/bukkit/inventory/ItemStack;", "generateInviteCodePaper", "Lorg/kingdoms/constants/item/KingdomItem;", "kp", "Lorg/kingdoms/constants/player/KingdomPlayer;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InteractiveGUI openGUI(@NotNull Player player, @NotNull Kingdom kingdom) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)kingdom, (String)"kingdom");
            return this.openGUI(player, kingdom, 0);
        }

        private final InteractiveGUI openGUI(Player player, Kingdom kingdom, int page) {
            InteractiveGUI gui = GUIAccessor.prepare(player, KingdomsGUI.INVITE$CODES);
            int maxInviteCodes = KingdomsConfig.INVITATIONS_CODES_MAX.getInt();
            long paperCost = KingdomsConfig.INVITATIONS_CODES_PAPER_COST_RESOURCE_POINTS.getLong();
            gui.getMessageContext().raw("invitecode-paper-cost", paperCost).raw("invitecode-max", maxInviteCodes);
            KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            Intrinsics.checkNotNullExpressionValue((Object)kingdomPlayer, (String)"getKingdomPlayer(...)");
            KingdomPlayer kp = kingdomPlayer;
            boolean hasInvitePerm = kp.hasPermission(StandardKingdomPermission.INVITE);
            GUIPagination<InviteCode> pagination = GUIPagination.paginate(gui, kingdom.getInviteCodes().values(), "invite-codes", page, arg_0 -> Companion.openGUI$lambda$0(player, kingdom, arg_0));
            ReusableOptionHandler option = pagination.getOption();
            for (InviteCode inviteCode : pagination.getPaginatedElements()) {
                MessagePlaceholderProvider messagePlaceholderProvider = option.getMessageContext();
                Intrinsics.checkNotNull((Object)inviteCode);
                messagePlaceholderProvider.addAll((Map)this.getEditsOf(inviteCode));
                option.on(ClickType.LEFT, arg_0 -> Companion.openGUI$lambda$1(hasInvitePerm, kp, paperCost, kingdom, inviteCode, player, arg_0));
                ((ReusableOptionHandler)option.on(ClickType.MIDDLE, arg_0 -> Companion.openGUI$lambda$2(hasInvitePerm, arg_0))).setConversation((arg_0, arg_1) -> Companion.openGUI$lambda$3(inviteCode, player, kingdom, page, arg_0, arg_1));
                option.on(ClickType.RIGHT, arg_0 -> Companion.openGUI$lambda$4(hasInvitePerm, kingdom, inviteCode, player, page, arg_0));
                option.pushHead(inviteCode.getCreator());
                if (option.hasNext()) continue;
            }
            Ref.ObjectRef duration = new Ref.ObjectRef();
            gui.option("new-invite-code").onNormalClicks(arg_0 -> Companion.openGUI$lambda$5(hasInvitePerm, kingdom, maxInviteCodes, arg_0)).setConversation((arg_0, arg_1) -> Companion.openGUI$lambda$6(duration, kingdom, player, arg_0, arg_1)).done();
            gui.option("delete-all").onNormalClicks(arg_0 -> Companion.openGUI$lambda$7(kingdom, player, arg_0)).done();
            InteractiveGUI.open$default(gui, false, false, 3, null);
            Intrinsics.checkNotNull((Object)gui);
            return gui;
        }

        private final Long durationOfInviteCode(OptionHandler ctx, String input) {
            Long dur;
            block5: {
                Long maxDuration;
                long minDuration;
                block4: {
                    dur = TimeUtils.parseTime(input);
                    if (dur == null) {
                        ctx.getMessageContext().raw("time", input);
                        ctx.sendError(KingdomsLang.INVALID_TIME, new Object[0]);
                        return null;
                    }
                    Long l = KingdomsConfig.INVITATIONS_CODES_EXPIRATION_MIN.getTimeMillis();
                    Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getTimeMillis(...)");
                    minDuration = RangesKt.coerceAtLeast((long)1000L, (long)((Number)l).longValue());
                    maxDuration = KingdomsConfig.INVITATIONS_CODES_EXPIRATION_MAX.getTimeMillis();
                    long l2 = 0L;
                    if (dur == l2 && maxDuration > 0L) break block4;
                    l2 = 0L;
                    if ((dur == l2 || dur >= minDuration) && (maxDuration <= 0L || dur <= maxDuration)) break block5;
                }
                MessagePlaceholderProvider messagePlaceholderProvider = ctx.getMessageContext().raw("duration-min", TimeFormatter.of(minDuration));
                Intrinsics.checkNotNull((Object)maxDuration);
                messagePlaceholderProvider.raw("duration-max", TimeFormatter.of(maxDuration));
                ctx.sendError(KingdomsLang.COMMAND_INVITECODES_DURATION_OUT_OF_RANGE, new Object[0]);
                return null;
            }
            return dur;
        }

        private final Map<String, Object> getEditsOf(InviteCode inviteCode) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"invitecode-code", (Object)inviteCode.getCode()), TuplesKt.to((Object)"invitecode-creator", (Object)inviteCode.getCreator().getName()), TuplesKt.to((Object)"invitecode-uses", (Object)(inviteCode.getUses() == 0 ? KingdomsLang.UNLIMITED.parse(new Object[0]) : Integer.valueOf(inviteCode.getUses()))), TuplesKt.to((Object)"invitecode-used", (Object)inviteCode.getUsedBy().size()), TuplesKt.to((Object)"invitecode-createdAt", (Object)TimeUtils.getDateAndTime(inviteCode.getCreatedAt())), TuplesKt.to((Object)"invitecode-expiration", (Object)(inviteCode.getExpiration() == 0L ? KingdomsLang.UNLIMITED.parse(new Object[0]) : TimeUtils.getDateAndTime(inviteCode.getExpiration())))};
            return MapsKt.hashMapOf((Pair[])pairArray);
        }

        @Nullable
        public final Pair<UUID, String> getInviteCodeFrom(@NotNull ItemStack item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            KingdomItem kingdomItem = KingdomItem.Companion.getKingdomItem(item);
            if (kingdomItem == null) {
                return null;
            }
            KingdomItem kingdomItem2 = kingdomItem;
            KingdomItemData kingdomItemData = kingdomItem2.getData().get(INVITE_CODE_NS);
            if (kingdomItemData == null) {
                return null;
            }
            KingdomItemData inviteCodeData = kingdomItemData;
            NBTTag<?> nBTTag = inviteCodeData.getData();
            Intrinsics.checkNotNull(nBTTag, (String)"null cannot be cast to non-null type org.kingdoms.nbt.tag.NBTTagCompound");
            NBTTagCompound data = (NBTTagCompound)nBTTag;
            UUID group = FastUUID.fromString((CharSequence)data.get("Group", NBTTagType.STRING));
            String code = (String)data.get("Code", NBTTagType.STRING);
            return new Pair((Object)group, (Object)code);
        }

        @NotNull
        public final KingdomItem generateInviteCodePaper(@NotNull KingdomPlayer kp, @NotNull Kingdom kingdom, @NotNull InviteCode inviteCode) {
            KingdomItemData kingdomItemData;
            Intrinsics.checkNotNullParameter((Object)kp, (String)"kp");
            Intrinsics.checkNotNullParameter((Object)kingdom, (String)"kingdom");
            Intrinsics.checkNotNullParameter((Object)inviteCode, (String)"inviteCode");
            KingdomsItemDeserializer kingdomsItemDeserializer = new KingdomsItemDeserializer();
            ConfigSection configSection = KingdomsConfig.INVITATIONS_CODES_PAPER_ITEM.getManager().getSection().getSection();
            Intrinsics.checkNotNullExpressionValue((Object)configSection, (String)"getSection(...)");
            KingdomsItemDeserializer kingdomsItemDeserializer2 = kingdomsItemDeserializer.withSection(configSection);
            MessagePlaceholderProvider messagePlaceholderProvider = ((MessagePlaceholderProvider)new MessagePlaceholderProvider().addAll((Map)this.getEditsOf(inviteCode))).withContext(kingdom);
            Intrinsics.checkNotNullExpressionValue((Object)messagePlaceholderProvider, (String)"withContext(...)");
            ItemStack item = kingdomsItemDeserializer2.withContext(messagePlaceholderProvider).deserialize();
            KingdomItem ki = KingdomItem.Companion.createKingdomItem(item);
            Map map = ki.getData();
            Namespace namespace = INVITE_CODE_NS;
            KingdomItemData $this$generateInviteCodePaper_u24lambda_u248 = kingdomItemData = KingdomItemData.Companion.createEmpty(INVITE_CODE_NS);
            boolean bl = false;
            $this$generateInviteCodePaper_u24lambda_u248.setCreatedBy(kp.getId());
            $this$generateInviteCodePaper_u24lambda_u248.setData(NBTTagCompound.empty().set("Code", inviteCode.getCode()).set("Group", FastUUID.toString(kingdom.getKey())));
            map.put(namespace, kingdomItemData);
            ki.applyChanges();
            return ki;
        }

        private static final void openGUI$lambda$0(Player $player, Kingdom $kingdom, Integer openPage) {
            Intrinsics.checkNotNull((Object)openPage);
            Companion.openGUI($player, $kingdom, openPage);
        }

        private static final void openGUI$lambda$1(boolean $hasInvitePerm, KingdomPlayer $kp, long $paperCost, Kingdom $kingdom, InviteCode $inviteCode, Player $player, OptionHandler ctx) {
            if (!$hasInvitePerm) {
                ctx.sendError(KingdomsLang.COMMAND_INVITECODES_PERMISSION_GET, new Object[0]);
                return;
            }
            if (!$kp.isAdmin() && $paperCost > 0L) {
                if (!$kingdom.getResourcePoints().has($paperCost)) {
                    ctx.sendError(KingdomsLang.COMMAND_INVITECODES_PAPER_COST, new Object[0]);
                    return;
                }
                $kingdom.getResourcePoints().add(-$paperCost);
            }
            Intrinsics.checkNotNull((Object)$inviteCode);
            KingdomItem paper = Companion.generateInviteCodePaper($kp, $kingdom, $inviteCode);
            ItemStack[] itemStackArray = new ItemStack[]{paper.getItem()};
            XItemStack.giveOrDrop((Player)$player, (ItemStack[])itemStackArray);
            ctx.sendMessage((Messenger)KingdomsLang.COMMAND_INVITECODES_PAPER_GIVE, new Object[0]);
        }

        private static final void openGUI$lambda$2(boolean $hasInvitePerm, OptionHandler ctx) {
            if (!$hasInvitePerm) {
                ctx.sendError(KingdomsLang.COMMAND_INVITECODES_PERMISSION_REDEEM, new Object[0]);
                return;
            }
            ctx.sendMessage((Messenger)KingdomsLang.COMMAND_INVITECODES_REDEEM_ENTER, new Object[0]);
            ctx.startConversation();
        }

        private static final void openGUI$lambda$3(InviteCode $inviteCode, Player $player, Kingdom $kingdom, int $page, OptionHandler ctx, String input) {
            Intrinsics.checkNotNull((Object)ctx);
            Intrinsics.checkNotNull((Object)input);
            Long dur = Companion.durationOfInviteCode(ctx, input);
            if (dur != null) {
                ctx.endConversation();
                $inviteCode.redeemFor(TimeUtils.afterNow(Duration.ofMillis(dur)));
                Companion.openGUI($player, $kingdom, $page);
            }
        }

        private static final void openGUI$lambda$4(boolean $hasInvitePerm, Kingdom $kingdom, InviteCode $inviteCode, Player $player, int $page, OptionHandler ctx) {
            if (!$hasInvitePerm) {
                ctx.sendError(KingdomsLang.COMMAND_INVITECODES_PERMISSION_DELETE, new Object[0]);
                return;
            }
            $kingdom.getInviteCodes().remove($inviteCode.getCode());
            Companion.openGUI($player, $kingdom, $page);
        }

        private static final void openGUI$lambda$5(boolean $hasInvitePerm, Kingdom $kingdom, int $maxInviteCodes, OptionHandler ctx) {
            if (!$hasInvitePerm) {
                ctx.sendError(KingdomsLang.COMMAND_INVITECODES_PERMISSION_CREATE, new Object[0]);
                return;
            }
            if ($kingdom.getInviteCodes().size() >= $maxInviteCodes) {
                ctx.sendError(KingdomsLang.COMMAND_INVITECODES_MAX, new Object[0]);
                return;
            }
            ctx.sendMessage((Messenger)KingdomsLang.COMMAND_INVITECODES_DURATION_ENTER, new Object[0]);
            ctx.startConversation();
        }

        private static final void openGUI$lambda$6(Ref.ObjectRef $duration, Kingdom $kingdom, Player $player, OptionHandler ctx, String input) {
            int uses = 0;
            if ($duration.element == null) {
                Intrinsics.checkNotNull((Object)ctx);
                Intrinsics.checkNotNull((Object)input);
                Long dur = Companion.durationOfInviteCode(ctx, input);
                if (dur != null) {
                    $duration.element = new AtomicLong(dur);
                    ctx.sendMessage((Messenger)KingdomsLang.COMMAND_INVITECODES_USES_ENTER, new Object[0]);
                }
                return;
            }
            try {
                uses = Integer.parseInt(input);
            }
            catch (NumberFormatException ex) {
                ctx.getMessageContext().raw("arg", input);
                ctx.sendError(KingdomsLang.INVALID_NUMBER, new Object[0]);
                return;
            }
            int minUses = RangesKt.coerceAtLeast((int)1, (int)KingdomsConfig.INVITATIONS_CODES_USES_MIN.getInt());
            int maxUses = KingdomsConfig.INVITATIONS_CODES_USES_MAX.getInt();
            if (uses == 0 && maxUses > 0 || uses != 0 && uses < minUses || maxUses > 0 && uses > maxUses) {
                ctx.getMessageContext().raw("uses-min", minUses).raw("uses-max", maxUses);
                ctx.sendError(KingdomsLang.COMMAND_INVITECODES_USES_OUT_OF_RANGE, new Object[0]);
                return;
            }
            Object object = $duration.element;
            Intrinsics.checkNotNull((Object)object);
            InviteCode code = $kingdom.generateInviteCode(Duration.ofMillis(((AtomicLong)object).get()), $player.getUniqueId(), uses);
            Map<String, InviteCode> map = $kingdom.getInviteCodes();
            Intrinsics.checkNotNullExpressionValue(map, (String)"getInviteCodes(...)");
            Map<String, InviteCode> map2 = map;
            map2.put(code.getCode(), code);
            ctx.endConversation();
            Companion.openGUI($player, $kingdom);
        }

        private static final void openGUI$lambda$7(Kingdom $kingdom, Player $player, OptionHandler ctx) {
            $kingdom.getInviteCodes().clear();
            Companion.openGUI($player, $kingdom);
            ctx.sendMessage((Messenger)KingdomsLang.COMMAND_INVITECODES_DELETED_ALL, new Object[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

