/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.invitations;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomInvite;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.general.KingdomInviteEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.locale.placeholders.target.PlaceholderTarget;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.conditions.ConditionProcessor;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.time.TimeUtils;

public class CommandInvite
extends KingdomsCommand
implements Listener {
    public CommandInvite() {
        super("invite", true);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        KingdomInvite previousInvite;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        final Player inviter = context.senderAsPlayer();
        final OfflinePlayer invited = context.getOfflinePlayer(0);
        if (invited == null) {
            return CommandResult.FAILED;
        }
        if (!KingdomsConfig.INVITATIONS_ALLOW_OFFLINE_INVITES.getManager().getBoolean() && !invited.isOnline()) {
            return context.fail(KingdomsLang.COMMAND_INVITE_CANNOT_INVITE_OFFLINE_PLAYER);
        }
        if (invited.getUniqueId().equals(inviter.getUniqueId())) {
            KingdomsLang.COMMAND_INVITE_SELF.sendError((CommandSender)inviter, new Object[0]);
            return CommandResult.FAILED;
        }
        KingdomPlayer inviterKp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)inviter);
        if (!inviterKp.hasKingdom()) {
            KingdomsLang.NO_KINGDOM_DEFAULT.sendError((CommandSender)inviter, new Object[0]);
            return CommandResult.FAILED;
        }
        if (!inviterKp.hasPermission(StandardKingdomPermission.INVITE)) {
            StandardKingdomPermission.INVITE.sendDeniedMessage(inviter);
            return CommandResult.FAILED;
        }
        final KingdomPlayer invitedPlayer = KingdomPlayer.getKingdomPlayer(invited);
        if (invitedPlayer.hasKingdom()) {
            if (invitedPlayer.getKingdomId().equals(inviterKp.getKingdomId())) {
                KingdomsLang.COMMAND_INVITE_ALREADY_JOINED.sendMessage((CommandSender)inviter, "invited", invited.getName());
                return CommandResult.FAILED;
            }
            if (!KingdomsConfig.INVITATIONS_ALLOW_FROM_OTHER_KINGDOMS.getBoolean()) {
                KingdomsLang.COMMAND_INVITE_ALREADY_IN_KINGDOM.sendMessage((CommandSender)inviter, "invited", invited.getName());
                return CommandResult.FAILED;
            }
        }
        if ((previousInvite = invitedPlayer.getInvites().get(inviterKp.getKingdomId())) != null) {
            KingdomsLang.COMMAND_INVITE_ALREADY_INVITED.sendMessage((CommandSender)inviter, "inviter", previousInvite.getKingdomPlayer().getOfflinePlayer().getName());
            return CommandResult.FAILED;
        }
        if (KingdomsConfig.INVITATIONS_ALLOW_MULTIPLE_INVITES.getManager().getBoolean() && !invitedPlayer.getInvites().isEmpty()) {
            return context.fail(KingdomsLang.COMMAND_INVITE_ALREADY_INVITED_BY_OTHER_KINGDOM);
        }
        ConfigSection otherConditions = KingdomsConfig.INVITATIONS_ALLOW_OTHER_CONDITIONS.getManager().getSection().getSection();
        Messenger matched = ConditionProcessor.mapConditions(otherConditions, false).evaluate(new PlaceholderContextBuilder().withContext(inviter).other(PlaceholderTarget.of(invited)), true);
        if (matched != null) {
            return context.fail(matched);
        }
        final Kingdom kingdom = inviterKp.getKingdom();
        Long time = null;
        if (context.assertArgs(2)) {
            time = TimeUtils.parseTime(context.arg(1));
        }
        if (time == null) {
            time = TimeUtils.parseTime(KingdomsConfig.INVITATIONS_EXPIRATION_DEFAULT_EXPIRE.getString());
        }
        KingdomInviteEvent event = new KingdomInviteEvent(kingdom, invitedPlayer, inviterKp, time);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return CommandResult.FAILED;
        }
        time = event.getAcceptTime();
        final KingdomInvite invitation = new KingdomInvite(inviterKp.getId(), time);
        invitedPlayer.getInvites().put(kingdom.getId(), invitation);
        final Object[] edits = new Object[]{"inviter", inviter.getName(), "invited", invited.getName(), "kingdom", kingdom.getName()};
        if (time < TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS)) {
            new BukkitRunnable(){

                public void run() {
                    KingdomInvite currentInvite = invitedPlayer.getInvites().get(kingdom.getId());
                    if (currentInvite == invitation) {
                        invitedPlayer.getInvites().remove(kingdom.getId());
                        if (invited.isOnline()) {
                            KingdomsLang.COMMAND_INVITE_EXPIRED.sendMessage((CommandSender)invited.getPlayer(), edits);
                        }
                        if (inviter.isOnline()) {
                            KingdomsLang.COMMAND_INVITE_EXPIRED_NOTIFY.sendMessage((CommandSender)inviter, edits);
                        }
                    }
                }
            }.runTaskLaterAsynchronously((Plugin)Kingdoms.get(), TimeUnit.SECONDS.convert(time, TimeUnit.MILLISECONDS) * 20L);
        }
        if (KingdomsConfig.INVITATIONS_ANNOUNCE.getBoolean()) {
            for (Player member : kingdom.getOnlineMembers()) {
                KingdomsLang.COMMAND_INVITE_ANNOUNCE.sendMessage((CommandSender)member, edits);
            }
        }
        if (invited.isOnline()) {
            KingdomsLang.COMMAND_INVITE_INVITED.sendMessage((CommandSender)invited.getPlayer(), edits);
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        if (context.isPlayer()) {
            if (context.isAtArg(0)) {
                Kingdom kingdom = context.getKingdom();
                if (kingdom == null) {
                    return context.tabComplete((Messenger)KingdomsLang.NO_KINGDOM_DEFAULT);
                }
                return context.getPlayers(0, p -> !kingdom.isMember((OfflinePlayer)p));
            }
            if (context.isAtArg(1)) {
                return context.tabComplete((Messenger)KingdomsLang.COMMAND_INVITE_TAB_EXPIRATION);
            }
        }
        return context.emptyTab();
    }
}

