/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.invasions;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.logs.misc.challenge.LogKingdomChallenged;
import org.kingdoms.constants.group.model.logs.misc.challenge.LogKingdomChallenger;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.invasion.KingdomChallengeEvent;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.OptionCategory;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.server.core.Server;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.internal.functional.Fn;
import org.kingdoms.utils.time.TimeUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/kingdoms/commands/general/invasions/CommandChallenge;", "Lorg/kingdoms/commands/KingdomsCommand;", "<init>", "()V", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "tabComplete", "", "", "Lorg/kingdoms/commands/CommandTabContext;", "core"})
public final class CommandChallenge
extends KingdomsCommand {
    public CommandChallenge() {
        super("challenge", true);
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!KingdomsConfig.Invasions.CHALLENGES_ENABLED.getManager().getBoolean()) {
            MessageHandler.sendPluginMessage(context.getMessageReceiver(), "&4Challenges aren't enabled");
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        KingdomPlayer kp = context.getKingdomPlayer();
        Kingdom kingdom = kp.getKingdom();
        Intrinsics.checkNotNull((Object)kingdom);
        Kingdom challengerKingdom = kingdom;
        Player player = context.senderAsPlayer();
        if (!kp.hasPermission(StandardKingdomPermission.INVADE)) {
            CommandResult commandResult = context.fail(StandardKingdomPermission.INVADE.getDeniedMessage());
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        Kingdom kingdom2 = (Kingdom)context.generalSelector(false);
        if (kingdom2 == null) {
            return CommandResult.FAILED;
        }
        Kingdom challengedKingdom = kingdom2;
        if (Intrinsics.areEqual((Object)challengedKingdom.getId(), (Object)challengerKingdom.getId())) {
            CommandResult commandResult = context.fail(KingdomsLang.COMMAND_CHALLENGE_YOURSELF);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        if (challengedKingdom.getChallenges().containsKey(challengerKingdom.getId())) {
            CommandResult commandResult = context.fail(KingdomsLang.COMMAND_CHALLENGE_ALREADY_CHALLENGED);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        InteractiveGUI interactiveGUI = GUIAccessor.prepare(player, KingdomsGUI.CHALLENGE);
        if (interactiveGUI == null) {
            return CommandResult.FAILED;
        }
        InteractiveGUI gui = interactiveGUI;
        for (OptionCategory option : gui.getOptions("time")) {
            option.getOption().onNormalClicks(() -> CommandChallenge.execute$lambda$0(option, challengerKingdom, challengedKingdom, kp, player)).done();
        }
        InteractiveGUI.open$default(gui, false, false, 3, null);
        return CommandResult.SUCCESS;
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandTabContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List<String> list = context.tabCompleteGeneralSelector(false, true, Fn.alwaysTrue()).build();
        Intrinsics.checkNotNullExpressionValue(list, (String)"build(...)");
        return list;
    }

    private static final void execute$lambda$0(OptionCategory $option, Kingdom $challengerKingdom, Kingdom $challengedKingdom, KingdomPlayer $kp, Player $player) {
        ConfigSection settings = $option.getOption().getConfig();
        long l = System.currentTimeMillis();
        Long l2 = TimeUtils.parseTime(settings.getString("time"));
        Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"parseTime(...)");
        long startTime = l + ((Number)l2).longValue();
        Intrinsics.checkNotNull((Object)$kp);
        KingdomChallengeEvent event = new KingdomChallengeEvent($challengerKingdom, $challengedKingdom, $kp, startTime);
        Server.get().getEventHandler().callEvent(event);
        if (event.isCancelled()) {
            return;
        }
        Map<UUID, Long> map = $challengedKingdom.getChallenges();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getChallenges(...)");
        Map<UUID, Long> map2 = map;
        Iterator<Player> iterator = $challengerKingdom.getId();
        Long l3 = startTime;
        map2.put((UUID)((Object)iterator), l3);
        $challengedKingdom.log(new LogKingdomChallenged($challengerKingdom, $kp, startTime));
        $challengerKingdom.log(new LogKingdomChallenger($challengedKingdom, $kp, startTime));
        MessagePlaceholderProvider msgSettings = new MessagePlaceholderProvider().withContext($player).withContext($challengedKingdom);
        for (Player member : $challengedKingdom.getOnlineMembers()) {
            Intrinsics.checkNotNull((Object)member);
            CommandSender commandSender = (CommandSender)member;
            Intrinsics.checkNotNull((Object)msgSettings);
            KingdomsLang.COMMAND_CHALLENGE_CHALLENGED.sendMessage(commandSender, msgSettings);
        }
        for (Player member : $challengerKingdom.getOnlineMembers()) {
            Intrinsics.checkNotNull((Object)member);
            CommandSender commandSender = (CommandSender)member;
            Intrinsics.checkNotNull((Object)msgSettings);
            KingdomsLang.COMMAND_CHALLENGE_NOTIFY_SELF_MEMBERS.sendMessage(commandSender, msgSettings);
        }
        $player.closeInventory();
    }
}

