/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.home;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.general.LocationChangeEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;
import org.kingdoms.server.location.Location;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.MathUtils;

public class CommandSetHome
extends KingdomsCommand {
    public CommandSetHome() {
        super("sethome", true);
    }

    public static org.bukkit.Location readjustInternals(org.bukkit.Location home) {
        return KingdomsConfig.HOME_CENTER.getBoolean() ? LocationUtils.getPreciseLocation(home) : LocationUtils.roundLocationPrecision(home);
    }

    public static LocationChangeEvent setHome(Group group, Location newHome, KingdomPlayer by) {
        return group.setHome(BukkitAdapter.adapt(CommandSetHome.readjustInternals(BukkitAdapter.adapt(newHome))), by);
    }

    public static org.bukkit.Location readjustHomeLocation(CommandContext context, org.bukkit.Location home) {
        if (MathUtils.getFractionalPart(home.getY()) > 0.9) {
            home.setY(Math.ceil(home.getY()));
        }
        if (context.assertArgs(1)) {
            String center;
            switch (center = context.arg(0).toLowerCase()) {
                case "center": {
                    home = LocationUtils.cleanLocation(home);
                    break;
                }
                case "centeraxis": {
                    home = LocationUtils.centerAxis(home);
                    break;
                }
                case "centerview": {
                    home = LocationUtils.centerView(home);
                }
            }
        }
        home = CommandSetHome.readjustInternals(home);
        return home;
    }

    @Override
    public CommandResult execute(CommandContext context) {
        org.bukkit.Location home;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)player, KingdomsLang.DISABLED_WORLD)) {
            return CommandResult.FAILED;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasKingdom()) {
            KingdomsLang.NO_KINGDOM_DEFAULT.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        Kingdom kingdom = kp.getKingdom();
        if (!kp.hasPermission(StandardKingdomPermission.SET_HOME)) {
            StandardKingdomPermission.SET_HOME.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        String[] args = context.args;
        CommandSender sender = context.getMessageReceiver();
        Land land = Land.getLand(player.getLocation());
        if (land == null || !land.isClaimed()) {
            if (KingdomsConfig.HOME_CLAIMED.getBoolean()) {
                KingdomsLang.COMMAND_SETHOME_NOT_CLAIMED.sendMessage(sender);
                return CommandResult.FAILED;
            }
        } else {
            if (!land.getKingdomId().equals(kingdom.getId())) {
                KingdomsLang.COMMAND_SETHOME_OTHERS_LAND.sendMessage((CommandSender)player);
                return CommandResult.FAILED;
            }
            if (KingdomsConfig.HOME_NEXUS_LAND.getBoolean() && !land.isNexusLand()) {
                KingdomsLang.COMMAND_SETHOME_NEXUS_LAND.sendMessage((CommandSender)player);
                return CommandResult.FAILED;
            }
        }
        if (kingdom.setHome(BukkitAdapter.adapt(home = CommandSetHome.readjustHomeLocation(context, player.getLocation())), kp).isCancelled()) {
            return CommandResult.FAILED;
        }
        for (Player member : kingdom.getOnlineMembers()) {
            KingdomsLang.COMMAND_SETHOME_SET.sendMessage((CommandSender)member, "x", home.getBlockX(), "y", home.getBlockY(), "z", home.getBlockZ());
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        return context instanceof Player && context.isAtArg(0) ? Arrays.asList("center", "centerAxis", "centerView") : new ArrayList<String>();
    }
}

