/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.home;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.namespaces.DefaultTaxes;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.general.GroupHomeTeleportEvent;
import org.kingdoms.events.general.KingdomSetHomeEvent;
import org.kingdoms.libs.caffeine.cache.Cache;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.managers.teleportation.IsolatedTpManager;
import org.kingdoms.managers.teleportation.TeleportTask;
import org.kingdoms.managers.teleportation.TpManager;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;
import org.kingdoms.services.ServiceVault;
import org.kingdoms.services.VaultBalance;
import org.kingdoms.services.VaultEconomy;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.cache.caffeine.CacheHandler;
import org.kingdoms.utils.compilers.expressions.MathExpression;
import org.kingdoms.utils.internal.functional.Finalizer;

public class CommandHome
extends KingdomsCommand
implements Listener {
    private static final Cache<UUID, Boolean> LAST_HOME_TELEPORT = CacheHandler.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
    private static final IsolatedTpManager TELEPORTS = new IsolatedTpManager();

    public CommandHome() {
        super("home", true);
    }

    public static Location callEvent(Group group, Player player, Location location, GroupHomeTeleportEvent.LocationType locationType) {
        GroupHomeTeleportEvent event = new GroupHomeTeleportEvent(group, player, location, locationType);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event.isCancelled() ? null : event.getLocation();
    }

    @Override
    public CommandResult execute(CommandContext context) {
        BukkitTask task;
        Location home;
        Kingdom kingdom;
        boolean selfKingdom;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        final Player player = context.senderAsPlayer();
        if (TpManager.alreadyTping(player)) {
            return CommandResult.FAILED;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        GroupHomeTeleportEvent.LocationType locType = GroupHomeTeleportEvent.LocationType.HOME;
        Finalizer finalizer = new Finalizer();
        if (!context.assertArgs(1)) {
            selfKingdom = true;
            if (context.assertHasKingdom()) {
                return CommandResult.FAILED;
            }
            if (!kp.hasPermission(StandardKingdomPermission.HOME)) {
                StandardKingdomPermission.HOME.sendDeniedMessage(player);
                return CommandResult.FAILED;
            }
            kingdom = kp.getKingdom();
            Location location = home = kingdom.getHome() == null ? null : BukkitAdapter.adapt(kingdom.getHome());
            if (home == null) {
                Structure structure;
                SimpleChunkLocation chunk;
                Land nexusLand;
                if (KingdomsConfig.HOME_USE_NEXUS_IF_NOT_SET.getBoolean() && kingdom.getNexus() != null && (nexusLand = (chunk = kingdom.getNexus().toSimpleChunkLocation()).getLand()) != null && (structure = nexusLand.getStructure(struct -> ((StructureType)((StructureStyle)struct.getStyle()).getType()).isNexus())) != null) {
                    home = LocationUtils.findSafeLocation(structure.getOrigin().toBukkitLocation().add(0.5, 0.0, 0.5));
                    locType = GroupHomeTeleportEvent.LocationType.NEXUS;
                }
                if (home == null) {
                    context.sendError(KingdomsLang.COMMAND_HOME_NOT_SET, new Object[0]);
                    return CommandResult.FAILED;
                }
            }
        } else {
            if (!context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_HOME_OTHERS, true)) {
                context.sendError(KingdomsLang.COMMAND_HOME_PERMISSION, new Object[0]);
                return CommandResult.FAILED;
            }
            kingdom = context.getKingdom(0);
            if (kingdom == null) {
                return CommandResult.FAILED;
            }
            home = BukkitAdapter.adapt(kingdom.getHome());
            if (home == null) {
                context.sendError(KingdomsLang.COMMAND_HOME_NOT_SET_OTHERS, "kingdom", kingdom.getName());
                return CommandResult.FAILED;
            }
            selfKingdom = kingdom.isMember((OfflinePlayer)player);
            if (!kp.isAdmin() && !selfKingdom) {
                MathExpression tax;
                if (!kingdom.isHomePublic()) {
                    context.sendError(KingdomsLang.COMMAND_HOME_NOT_PUBLIC, "kingdom", kingdom.getName());
                    return CommandResult.FAILED;
                }
                if (!kingdom.hasAttribute(kp.getKingdom(), (RelationAttribute)StandardRelationAttribute.HOME)) {
                    context.sendError(KingdomsLang.COMMAND_HOME_CANT_USE_PUBLIC_HOME, "kingdom", kingdom.getName());
                    return CommandResult.FAILED;
                }
                if (Land.getLand(BukkitAdapter.adapt(kingdom.getHome())).isBeingInvaded()) {
                    context.sendError(KingdomsLang.COMMAND_HOME_BEING_INVADED, "kingdom", kingdom.getName());
                    return CommandResult.FAILED;
                }
                if (LAST_HOME_TELEPORT.getIfPresent((Object)player.getUniqueId()) == null && VaultEconomy.INSTANCE.isAvailable() && (tax = kingdom.getTax(DefaultTaxes.PUBLIC_HOME)) != null) {
                    VaultBalance bal = ServiceVault.getBalance((OfflinePlayer)player);
                    double taxAmt = MathUtils.eval(tax, (PlaceholderProvider)new PlaceholderContextBuilder().withContext(player).raw("money", bal));
                    context.var("home_tax", taxAmt).var("balance", bal);
                    if (bal.has(taxAmt)) {
                        context.requireYesNo(KingdomsLang.COMMAND_HOME_TAX_CONFIRM);
                        finalizer.add(() -> {
                            bal.subtract(taxAmt);
                            kingdom.getBank().add(taxAmt);
                            context.sendMessage((Messenger)KingdomsLang.COMMAND_HOME_TAX_PAID, new Object[0]);
                            LAST_HOME_TELEPORT.put((Object)player.getUniqueId(), (Object)true);
                        });
                    } else {
                        return context.fail(KingdomsLang.COMMAND_HOME_TAX_NOT_ENOUGH);
                    }
                }
            }
        }
        if ((selfKingdom ? KingdomsConfig.HOME_CHECK_SAFE_SELF : KingdomsConfig.HOME_CHECK_SAFE_OTHERS).getManager().getBoolean()) {
            Location safeLocation = LocationUtils.findSafeLocation(home, 5);
            if (safeLocation != null) {
                home = safeLocation;
            } else {
                context.requireYesNo(KingdomsLang.COMMAND_HOME_UNSAFE);
            }
        }
        finalizer.run();
        final int timer = KingdomsConfig.HOME_TELEPORT_DELAY.getInt();
        if (timer <= 0 || kp.isAdmin() || context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_HOME_BYPASS_TIMER) || PlayerUtils.invulnerableGameMode(player)) {
            if ((home = CommandHome.callEvent(kingdom, player, home, locType)) == null) {
                return CommandResult.FAILED;
            }
            player.teleport(home);
            context.sendMessage((Messenger)KingdomsLang.COMMAND_HOME_SUCCESS, new Object[0]);
            return CommandResult.SUCCESS;
        }
        final Location finalHome = home;
        final GroupHomeTeleportEvent.LocationType finalLocType = locType;
        if (KingdomsConfig.HOME_USE_TIMER_MESSAGE.getBoolean()) {
            task = new BukkitRunnable(){
                int timed;
                {
                    this.timed = timer;
                }

                public void run() {
                    if (this.timed <= 0) {
                        Location finalFinalHome = CommandHome.callEvent(kingdom, player, finalHome, finalLocType);
                        if (finalFinalHome != null) {
                            player.teleport(finalFinalHome);
                            KingdomsLang.COMMAND_HOME_SUCCESS.sendMessage((CommandSender)player);
                        }
                        TELEPORTS.end(player);
                        this.cancel();
                    } else {
                        KingdomsLang.COMMAND_HOME_TELEPORTING.sendMessage((CommandSender)player, "countdown", this.timed);
                        --this.timed;
                    }
                }
            }.runTaskTimer((Plugin)plugin, 0L, 20L);
        } else {
            KingdomsLang.COMMAND_HOME_TELEPORTING.sendMessage((CommandSender)player, "countdown", timer);
            task = new BukkitRunnable(){

                public void run() {
                    Location finalFinalHome = CommandHome.callEvent(kingdom, player, finalHome, finalLocType);
                    if (finalFinalHome != null) {
                        player.teleport(finalHome);
                        KingdomsLang.COMMAND_HOME_SUCCESS.sendMessage((CommandSender)player);
                    }
                    TELEPORTS.end(player);
                }
            }.runTaskLater((Plugin)plugin, (long)timer * 20L);
        }
        TeleportTask tpTask = new TeleportTask(player, task);
        tpTask.onAnyMove(event -> {
            KingdomsLang.TELEPORTS_MOVED.sendError((CommandSender)player, new Object[0]);
            return true;
        });
        TELEPORTS.put(tpTask);
        return CommandResult.SUCCESS;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onHomeSet(KingdomSetHomeEvent event) {
        ArrayList<Player> putAnEnd = new ArrayList<Player>();
        for (TeleportTask task : TELEPORTS.getTasks()) {
            if (!event.getKingdom().isMember((OfflinePlayer)task.player)) continue;
            KingdomsLang.COMMAND_HOME_CHANGED.sendError((CommandSender)task.player, new Object[0]);
            putAnEnd.add(task.player);
        }
        putAnEnd.forEach(TELEPORTS::end);
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0) && context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_HOME_OTHERS, true)) {
            return context.getKingdoms(0);
        }
        return CommandHome.emptyTab();
    }
}

