/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.election;

import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.election.CommandElection;
import org.kingdoms.commands.general.election.ElectionsCommand;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.daily.elections.ElectionCandidate;
import org.kingdoms.managers.daily.elections.Elections;
import org.kingdoms.managers.daily.elections.ElectionsManager;

public class CommandElectionStatement
extends KingdomsCommand
implements ElectionsCommand {
    public CommandElectionStatement(KingdomsParentCommand command) {
        super("statement", command);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        if (CommandElection.checkOngoingElection(context, this.getElectionsManager())) {
            return CommandResult.FAILED;
        }
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        ElectionCandidate candidate = this.getElectionsManager().getCandidate(player.getUniqueId());
        if (candidate == null) {
            return context.fail(KingdomsLang.COMMAND_ELECTION_STATEMENT_NOT_REGISTERED);
        }
        candidate.setStatement(context.joinArgs());
        context.sendMessage((Messenger)KingdomsLang.COMMAND_ELECTION_STATEMENT_SET, "statement", candidate.getStatement());
        return CommandResult.SUCCESS;
    }

    @Override
    @NotNull
    public ElectionsManager getElectionsManager() {
        return Elections.KINGDOMS;
    }
}

