/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.election;

import java.time.Duration;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.election.CommandElection;
import org.kingdoms.commands.general.election.ElectionsCommand;
import org.kingdoms.config.accessor.ConfigAccessor;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.managers.daily.elections.ElectionCandidate;
import org.kingdoms.managers.daily.elections.Elections;
import org.kingdoms.managers.daily.elections.ElectionsManager;
import org.kingdoms.services.ServiceVault;
import org.kingdoms.services.VaultBalance;
import org.kingdoms.services.managers.SoftService;
import org.kingdoms.utils.MathUtils;

public class CommandElectionRegister
extends KingdomsCommand
implements ElectionsCommand {
    public CommandElectionRegister(KingdomsParentCommand command) {
        super("register", command);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        if (CommandElection.checkOngoingElection(context, this.getElectionsManager())) {
            return CommandResult.FAILED;
        }
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        String statement = context.arg(0);
        context.var("candidacy_statement", statement);
        Player player = context.senderAsPlayer();
        ElectionCandidate candidate = this.getElectionsManager().getCandidate(player.getUniqueId());
        if (candidate != null) {
            return context.fail(KingdomsLang.COMMAND_ELECTION_REGISTER_ALREADY_REGISTERED);
        }
        ConfigAccessor requirements = this.getElectionsManager().getOption("candidate-requirements").getSection();
        Runnable finalizeFee = null;
        double fee = MathUtils.eval(requirements.get("fee").getMathExpression(), (PlaceholderProvider)context.getMessageContext());
        context.var("candidacy_fee", fee);
        if (fee > 0.0 && SoftService.VAULT.isAvailable() && ServiceVault.isAvailable(ServiceVault.Component.ECO)) {
            VaultBalance balance = ServiceVault.getBalance((OfflinePlayer)player);
            if (!balance.has(fee)) {
                return context.fail(KingdomsLang.COMMAND_ELECTION_REGISTER_REQUIREMENTS_FEE);
            }
            finalizeFee = () -> {
                balance.subtract(fee);
                context.getKingdom().getBank().add(fee);
            };
        }
        KingdomPlayer kp = context.getKingdomPlayer();
        Duration memberForReq = requirements.get("member-for").getTime(context.getMessageContext());
        Duration memberFor = Duration.ofMillis(System.currentTimeMillis() - kp.getJoinedAt());
        context.var("candidacy_member_for", memberForReq == null ? Integer.valueOf(0) : memberForReq);
        if (memberForReq != null && memberForReq.minus(memberFor).isNegative()) {
            return context.fail(KingdomsLang.COMMAND_ELECTION_REGISTER_REQUIREMENTS_MEMBER_FOR);
        }
        context.requireYesNo(KingdomsLang.COMMAND_ELECTION_REGISTER_REQUIREMENTS_CONFIRM);
        if (finalizeFee != null) {
            finalizeFee.run();
        }
        this.getElectionsManager().registerCandidate(player.getUniqueId(), statement);
        context.sendMessage((Messenger)KingdomsLang.COMMAND_ELECTION_REGISTER_REGISTERED, new Object[0]);
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        if (context.isAtArg(0)) {
            return context.tabComplete("<statement>");
        }
        return context.emptyTab();
    }

    @Override
    @NotNull
    public ElectionsManager getElectionsManager() {
        return Elections.KINGDOMS;
    }
}

