/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.election;

import java.time.Duration;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.election.ElectionsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.pagination.GUIPagination;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.daily.elections.ElectionCandidate;
import org.kingdoms.managers.daily.elections.ElectionsManager;
import org.kingdoms.utils.internal.sorting.SortingProcessor;

public abstract class AbstractCommandElectionVote
extends KingdomsCommand
implements ElectionsCommand {
    protected final ElectionsManager electionsManager;

    public AbstractCommandElectionVote(KingdomsParentCommand parent, ElectionsManager electionsManager) {
        super("vote", parent);
        this.electionsManager = electionsManager;
    }

    @Override
    @NotNull
    public ElectionsManager getElectionsManager() {
        return this.electionsManager;
    }

    protected abstract void addCandidates(Player var1, Runnable var2, GUIPagination<ElectionCandidate> var3);

    protected abstract boolean commonChecks(CommandContext var1);

    @Override
    public CommandResult execute(CommandContext context) {
        long passed;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (this.commonChecks(context)) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            context.sendMessage((Messenger)KingdomsLang.NO_KINGDOM_DEFAULT, new Object[0]);
            return CommandResult.FAILED;
        }
        Duration votingAge = this.electionsManager.getVotingAge();
        if (votingAge != null && !votingAge.isZero() && (passed = System.currentTimeMillis() - kp.getJoinedAt()) < votingAge.toMillis()) {
            context.var("voting_age", votingAge);
            return context.fail(KingdomsLang.COMMAND_ELECTION_VOTE_VOTING_AGE);
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> this.openCandidates(player, 0));
        return CommandResult.SUCCESS;
    }

    public void openCandidates(Player player, int page) {
        InteractiveGUI gui = GUIAccessor.prepare(player, (OfflinePlayer)player, "election-candidates", "page", page + 1);
        Collection<ElectionCandidate> members = this.electionsManager.getCandidates().values();
        members = SortingProcessor.copy(members).process(this.electionsManager.getCandidateSorter()).getProcessed();
        this.addCandidates(player, () -> this.openCandidates(player, page), GUIPagination.paginate(gui, members, "candidates", page, openPage -> this.openCandidates(player, (int)openPage)));
        gui.open();
    }
}

