/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.claims.unclaiming;

import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.claims.claiming.CommandClaimAuto;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;

public class CommandUnclaimAuto
extends KingdomsCommand {
    public CommandUnclaimAuto(KingdomsParentCommand parent) {
        super("auto", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        Player target = CommandClaimAuto.getTarget(context, KingdomsDefaultPluginPermission.COMMAND_UNCLAIM_AUTO_OTHERS);
        if (target == null) {
            return CommandResult.FAILED;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)target);
        if (!kp.hasPermission(StandardKingdomPermission.UNCLAIM) && !kp.hasPermission(StandardKingdomPermission.UNCLAIM)) {
            StandardKingdomPermission.UNCLAIM.sendDeniedMessage(target);
            return CommandResult.FAILED;
        }
        boolean wasAutoClaiming = kp.getAutoClaim() == Boolean.FALSE;
        kp.setAutoClaim(wasAutoClaiming ? null : Boolean.valueOf(false));
        KingdomsLang activation = wasAutoClaiming ? KingdomsLang.COMMAND_UNCLAIM_AUTO_OFF : KingdomsLang.COMMAND_UNCLAIM_AUTO_ON;
        activation.sendMessage((CommandSender)target);
        if (wasAutoClaiming) {
            if (CommandClaimAuto.cancelActionBar(target)) {
                KingdomsLang.AUTO_UNCLAIM_ACTIONBAR_DISABLED.sendMessage((CommandSender)target);
            }
        } else {
            CommandClaimAuto.cancelActionBar(target);
            if (KingdomsConfig.Claims.ACTIONBAR_AUTO_CLAIM.getManager().getBoolean()) {
                CommandClaimAuto.actionBar(target, KingdomsLang.AUTO_UNCLAIM_ACTIONBAR_ENABLED);
            }
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.assertArgs(1) && context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_UNCLAIM_AUTO_OTHERS)) {
            return context.getPlayers(0);
        }
        return CommandUnclaimAuto.emptyTab();
    }
}

