/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.claims.unclaiming;

import java.util.function.Predicate;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.lands.UnclaimLandEvent;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.utils.cooldown.EntityCooldown;

public class CommandUnclaimAll
extends KingdomsCommand {
    public CommandUnclaimAll(KingdomsParentCommand parent) {
        super("all", parent);
    }

    public static int unclaimAll(KingdomPlayer kp, UnclaimLandEvent.Reason reason, Kingdom kingdom) {
        Predicate<Land> filter = !KingdomsConfig.Claims.UNCLAIM_ALL_KEEP_NEXUS_LAND.getManager().getBoolean() ? null : land -> !land.isNexusLand();
        UnclaimLandEvent event = kingdom.unclaimIf(kp, reason, filter);
        return event.getLandLocations().size();
    }

    private static void unclaimAll(Player player, KingdomPlayer kp, Kingdom kingdom) {
        int lands = CommandUnclaimAll.unclaimAll(kp, UnclaimLandEvent.Reason.UNCLAIMED, kingdom);
        KingdomsLang.COMMAND_UNCLAIM_ALL_SUCCESS.sendMessage((CommandSender)player, "lands", lands);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        if (!kp.hasPermission(StandardKingdomPermission.UNCLAIM)) {
            StandardKingdomPermission.UNCLAIM.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        int cost = KingdomsConfig.Claims.UNCLAIM_ALL_COST.getManager().getInt();
        if (cost != 0 && !kingdom.getResourcePoints().has(cost)) {
            KingdomsLang.COMMAND_UNCLAIM_ALL_NOT_ENOUGH_RESOURCEPOINTS.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        if (KingdomsConfig.Claims.UNCLAIM_ALL_CONFIRM_ENABLED.getManager().getBoolean()) {
            if (KingdomsConfig.Claims.UNCLAIM_ALL_CONFIRM_GUI.getManager().getBoolean()) {
                InteractiveGUI gui = GUIAccessor.prepare(player, "confirm/unclaimall");
                if (gui == null) {
                    return CommandResult.FAILED;
                }
                gui.push("confirm", () -> {
                    player.closeInventory();
                    CommandUnclaimAll.unclaimAll(player, kp, kingdom);
                }, new Object[0]);
                gui.push("cancel", () -> ((Player)player).closeInventory(), new Object[0]);
                gui.open();
                return CommandResult.FAILED;
            }
            if (!EntityCooldown.add((Entity)player, "UNCLAIMALL", KingdomsConfig.Claims.UNCLAIM_ALL_CONFIRM_TIME.getManager().getInt())) {
                KingdomsLang.COMMAND_UNCLAIM_ALL_CONFIRM.sendMessage((CommandSender)player, "lands", kp.getKingdom().getLandLocations().size());
                return CommandResult.FAILED;
            }
        }
        CommandUnclaimAll.unclaimAll(player, kp, kingdom);
        return CommandResult.SUCCESS;
    }
}

