/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.claims.claiming;

import java.util.HashSet;
import java.util.Objects;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.lands.ClaimLandEvent;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.land.claiming.AbstractClaimProcessor;
import org.kingdoms.managers.land.claiming.ClaimClipboard;
import org.kingdoms.managers.land.claiming.ClaimProcessor;

public class CommandClaimConfirm
extends KingdomsCommand {
    public CommandClaimConfirm(KingdomsParentCommand parent) {
        super("confirm", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        ClaimClipboard session = ClaimClipboard.getClipboards().remove(player.getUniqueId());
        if (session == null) {
            context.sendError(KingdomsLang.COMMAND_CLAIM_CONFIRM_EMPTY, new Object[0]);
            return CommandResult.FAILED;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = Objects.requireNonNull(kp.getKingdom(), () -> "Player without a kingdom has a clipboard: " + player.getName());
        if (!kp.hasPermission(StandardKingdomPermission.CLAIM)) {
            StandardKingdomPermission.CLAIM.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        HashSet<SimpleChunkLocation> finalClaimables = new HashSet<SimpleChunkLocation>();
        for (AbstractClaimProcessor result : session.getClaims().getProcessedClaims().values()) {
            SimpleChunkLocation chunk = result.getChunk();
            if (!result.isSuccessful()) continue;
            ClaimProcessor newResult = (ClaimProcessor)result.reprocess();
            if (!newResult.isSuccessful()) {
                newResult.getMessageContext().raw("x", chunk.getX()).raw("z", chunk.getZ()).raw("error", newResult.getCombinedMessage());
                KingdomsLang.COMMAND_CLAIM_CONFIRM_FAIL.sendError(context.getMessageReceiver(), newResult.getMessageContext());
                continue;
            }
            newResult.finalizeProcess();
            finalClaimables.add(chunk);
        }
        if (!finalClaimables.isEmpty()) {
            context.var("claims", finalClaimables.size());
            context.sendMessage((Messenger)KingdomsLang.COMMAND_CLAIM_CONFIRM_SUCCESS, new Object[0]);
            kingdom.claim(finalClaimables, kp, ClaimLandEvent.Reason.CLAIMED, true);
        } else {
            context.sendMessage((Messenger)KingdomsLang.COMMAND_CLAIM_CONFIRM_NOTHING_CLAIMED, new Object[0]);
        }
        return CommandResult.SUCCESS;
    }
}

