/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.chat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.KingdomsChatChannel;
import org.kingdoms.events.members.PlayerChangeChatChannelEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.builders.MessageObjectBuilder;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.managers.chat.KingdomsChatProcessor;

public class CommandChat
extends KingdomsCommand {
    public CommandChat() {
        super("chat", true);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            if (context.assertPlayer()) {
                return;
            }
            if (context.requireArgs(1)) {
                return;
            }
            Player player = context.senderAsPlayer();
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            String chan = context.arg(0);
            KingdomsChatChannel channel = KingdomsChatChannel.getChannelUserFriendly(chan, context.getMessageContext());
            String prefix = KingdomsConfig.Chat.DIRECT_PREFIX.getManager().getString();
            boolean prefixed = false;
            if (channel == null && prefix != null && chan.startsWith(prefix)) {
                chan = chan.substring(prefix.length());
                prefixed = true;
                if (!context.assertArgs(2)) {
                    KingdomsLang.COMMAND_CHAT_DIRECT_MESSAGE_MISSING.sendError((CommandSender)player, "kingdom", chan);
                    return;
                }
            }
            if (!prefixed && channel == null) {
                KingdomsLang.COMMAND_CHAT_UNKNOWN_CHANNEL.sendError((CommandSender)player, "channel", chan);
                return;
            }
            if (channel == kp.getChatChannel()) {
                context.sendError(KingdomsLang.COMMAND_CHAT_ALREADY_IN_CHANNEL, new Object[0]);
                return;
            }
            if (prefix != null && context.assertArgs(2)) {
                String kingdomName = chan;
                if (channel == null) {
                    Kingdom kingdom = Kingdom.getKingdom(kingdomName);
                    if (kingdom == null) {
                        KingdomsLang.NOT_FOUND_KINGDOM.sendError((CommandSender)player, "kingdom", kingdomName);
                        return;
                    }
                    if (kingdom.getId().equals(kp.getKingdomId())) {
                        KingdomsLang.COMMAND_CHAT_DIRECT_MESSAGE_SELF.sendError((CommandSender)player, new Object[0]);
                        return;
                    }
                    String msg = context.joinArgs(" ", 1);
                    Kingdom senderKingdom = kp.getKingdom();
                    HashSet<UUID> chatParticipants = new HashSet<UUID>();
                    for (Player member : kp.getKingdom().getOnlineMembers()) {
                        KingdomsLang.COMMAND_CHAT_DIRECT_MESSAGE_SENDER_FORMAT.sendMessage((CommandSender)member, "receiver-kingdom", kingdom.getName(), "message", msg);
                        chatParticipants.add(member.getUniqueId());
                    }
                    for (Player member : kingdom.getOnlineMembers()) {
                        KingdomsLang.COMMAND_CHAT_DIRECT_MESSAGE_RECEIVER_FORMAT.sendMessage((CommandSender)member, "sender-kingdom", senderKingdom.getName(), "message", msg);
                        chatParticipants.add(member.getUniqueId());
                    }
                    for (Player spy : KingdomsChatProcessor.getSpies()) {
                        if (chatParticipants.contains(spy.getUniqueId())) continue;
                        KingdomsLang.COMMAND_CHAT_DIRECT_MESSAGE_SENDER_FORMAT.sendMessage((CommandSender)spy, "receiver-kingdom", kingdom.getName(), "message", msg);
                    }
                    return;
                }
                Messenger cantUse = channel.canUse(player);
                if (cantUse != null) {
                    cantUse.sendError((CommandSender)player, new Object[0]);
                    return;
                }
                KingdomsChatChannel previous = kp.getChatChannel();
                AsyncPlayerChatEvent asyncEvent = new AsyncPlayerChatEvent(true, player, context.joinArgs(" ", 1), new HashSet(Bukkit.getOnlinePlayers()));
                PlayerChangeChatChannelEvent event = kp.setChatChannel(channel);
                if (event.isCancelled()) {
                    return;
                }
                Bukkit.getPluginManager().callEvent((Event)asyncEvent);
                kp.setChatChannel(previous);
                return;
            }
            Messenger cantUse = channel.canUse(player);
            if (cantUse != null) {
                cantUse.sendError((CommandSender)player, new Object[0]);
                return;
            }
            PlayerChangeChatChannelEvent event = kp.setChatChannel(channel);
            if (event.isCancelled()) {
                return;
            }
            context.sendMessage((Messenger)KingdomsLang.COMMAND_CHAT_CHANGED, new Object[0]);
        });
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        if (!context.isPlayer()) {
            return CommandChat.emptyTab();
        }
        Player player = context.senderAsPlayer();
        if (context.isAtArg(0)) {
            Collection<KingdomsChatChannel> chans = KingdomsChatChannel.getChannels().values();
            String directPrefix = KingdomsConfig.Chat.DIRECT_PREFIX.getManager().getString();
            String first = context.arg(0);
            if (directPrefix != null && first.startsWith(directPrefix)) {
                return TabCompleteManager.getKingdoms(first.substring(directPrefix.length())).stream().map(x -> directPrefix + x).collect(Collectors.toList());
            }
            ArrayList<String> channels = new ArrayList<String>(chans.size());
            MessagePlaceholderProvider settings = new MessagePlaceholderProvider().withContext(player);
            for (KingdomsChatChannel chan : chans) {
                if (chan.canUse(player) != null) continue;
                MessageObjectBuilder messageObjectBuilder = chan.getName();
                channels.add(messageObjectBuilder.buildPlain(settings));
            }
            return context.suggest(0, channels);
        }
        if (context.isAtArg(1)) {
            return Collections.singletonList(context.tab("message"));
        }
        return CommandChat.emptyTab();
    }
}

