/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.building;

import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.building.CommandBuilding;
import org.kingdoms.constants.land.KingdomBlock;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.managers.land.KingdomBuildingManager;
import org.kingdoms.utils.display.visualizer.StructureVisualizer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/kingdoms/commands/general/building/CommandBuildingRepair;", "Lorg/kingdoms/commands/KingdomsCommand;", "parent", "Lorg/kingdoms/commands/KingdomsParentCommand;", "<init>", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "core"})
public final class CommandBuildingRepair
extends KingdomsCommand {
    public CommandBuildingRepair(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("repair", parent, PermissionDefault.TRUE);
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        KingdomBlock kingdomBlock = CommandBuilding.Companion.getKingdomBlock(context);
        if (kingdomBlock == null) {
            return CommandResult.FAILED;
        }
        KingdomBlock kingdomBlock2 = kingdomBlock;
        Player player = context.senderAsPlayer();
        KingdomBuilding building = (KingdomBuilding)kingdomBlock2;
        building.repair();
        Intrinsics.checkNotNull((Object)player);
        Namespace namespace = KingdomBuildingManager.PREVIEW_NS;
        Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"PREVIEW_NS");
        StructureVisualizer.Companion.stop(player, namespace);
        return CommandResult.SUCCESS;
    }
}

