/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.building;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.land.KingdomBuildingManager;
import org.kingdoms.utils.display.visualizer.StructureVisualizer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/kingdoms/commands/general/building/CommandBuildingPreview;", "Lorg/kingdoms/commands/KingdomsCommand;", "parent", "Lorg/kingdoms/commands/KingdomsParentCommand;", "<init>", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "Companion", "core"})
public final class CommandBuildingPreview
extends KingdomsCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<UUID> TOGGLES = new HashSet();

    public CommandBuildingPreview(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("preview", parent, PermissionDefault.TRUE);
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        UUID uUID = context.senderAsPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        UUID player = uUID;
        if (TOGGLES.add(player)) {
            context.sendMessage((Messenger)KingdomsLang.COMMAND_BUILDING_PREVIEW_ENABLED, new Object[0]);
        } else {
            TOGGLES.remove(player);
            context.sendMessage((Messenger)KingdomsLang.COMMAND_BUILDING_PREVIEW_DISABLED, new Object[0]);
            Player player2 = context.senderAsPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"senderAsPlayer(...)");
            Namespace namespace = KingdomBuildingManager.PREVIEW_NS;
            Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"PREVIEW_NS");
            StructureVisualizer.Companion.stop(player2, namespace);
        }
        return CommandResult.SUCCESS;
    }

    @NotNull
    public static final Set<UUID> getTOGGLES() {
        return Companion.getTOGGLES();
    }

    @JvmStatic
    public static final boolean isEnabled(@NotNull Player player) {
        return Companion.isEnabled(player);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007R\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/commands/general/building/CommandBuildingPreview$Companion;", "", "<init>", "()V", "TOGGLES", "", "Ljava/util/UUID;", "getTOGGLES$annotations", "getTOGGLES", "()Ljava/util/Set;", "isEnabled", "", "player", "Lorg/bukkit/entity/Player;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<UUID> getTOGGLES() {
            return TOGGLES;
        }

        @JvmStatic
        public static /* synthetic */ void getTOGGLES$annotations() {
        }

        @JvmStatic
        public final boolean isEnabled(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            return this.getTOGGLES().contains(player.getUniqueId());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

