/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.book;

import java.util.List;
import java.util.Map;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.book.CommandBook;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.BookChapter;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;

public class CommandBookRename
extends KingdomsCommand {
    public CommandBookRename(KingdomsParentCommand parent) {
        super("rename", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        BookChapter chapter = CommandBook.initialCheckup(context, KingdomsLang.COMMAND_BOOK_RENAME_USAGE, 2, true);
        if (chapter == null) {
            return CommandResult.FAILED;
        }
        String name = context.arg(1);
        Kingdom kingdom = context.getKingdom();
        Map<String, BookChapter> book = kingdom.getBook();
        if (book.containsKey(name)) {
            context.sendError(KingdomsLang.COMMAND_BOOK_RENAME_DUPLICATE, "chapter", name);
            return CommandResult.FAILED;
        }
        if (chapter.getName().equals(name)) {
            context.sendError(KingdomsLang.COMMAND_BOOK_RENAME_SAME, "chapter", name);
            return CommandResult.FAILED;
        }
        context.sendError(KingdomsLang.COMMAND_BOOK_RENAME_RENAMED, "old_chapter", chapter.getName(), "new_chapter", name);
        chapter.setName(name);
        book.put(name, chapter);
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            return CommandBook.tabCompleteBooks(context);
        }
        if (context.isAtArg(1)) {
            return CommandBookRename.tabComplete("<name>");
        }
        return CommandBookRename.emptyTab();
    }
}

