/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.book;

import java.util.List;
import java.util.Map;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.book.CommandBook;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.BookChapter;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.utils.nms.XBook;

public class CommandBookOpen
extends KingdomsCommand {
    public CommandBookOpen(KingdomsParentCommand parent) {
        super("open", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        if (context.assertArgs(1)) {
            BookChapter chapter = CommandBook.initialCheckup(context, KingdomsLang.COMMAND_BOOK_OPEN_USAGE, false);
            ItemStack book = XBook.getBook(chapter.getPages(), player, chapter.getName(), false, false);
            XBook.openBook(book, player);
            return CommandResult.FAILED;
        }
        Kingdom kingdom = context.getKingdom();
        Map<String, BookChapter> book = kingdom.getBook();
        InteractiveGUI gui = GUIAccessor.prepare(player, (OfflinePlayer)player, "book", "pages", book.size());
        if (gui == null) {
            return CommandResult.FAILED;
        }
        ReusableOptionHandler holder = gui.getReusableOption("chapters");
        for (BookChapter chapter : book.values()) {
            holder.setEdits("chapter", chapter.getName()).onNormalClicks(() -> {
                ItemStack bookItem = XBook.getBook(chapter.getPages(), player, chapter.getName(), false, false);
                player.closeInventory();
                XBook.openBook(bookItem, player);
            }).done();
        }
        gui.open();
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        return CommandBook.tabCompleteBooks(context);
    }
}

