/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.admin;

import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.namespace.NamespacedMap;
import org.kingdoms.libs.caffeine.cache.Cache;
import org.kingdoms.libs.caffeine.cache.Expiry;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.cache.caffeine.CacheHandler;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \b2\u00020\u0001:\u0003\b\t\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/kingdoms/commands/general/admin/CommandSession;", "Lorg/kingdoms/commands/KingdomsCommand;", "<init>", "()V", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "Companion", "Session", "SessionCallback", "core"})
public final class CommandSession
extends KingdomsCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final AtomicInteger ID_COUNTER = new AtomicInteger(0);
    @JvmField
    @NotNull
    public static final NamespacedMap<Cache<Integer, Session>> SESSIONS = new NamespacedMap();

    public CommandSession() {
        super("session");
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.requireArgs(3)) {
            return CommandResult.FAILED;
        }
        Namespace namespace = Namespace.fromString(context.arg(0));
        Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"fromString(...)");
        Namespace namespace2 = namespace;
        Object object = context.getNumber(1, true, false, null);
        if (object == null || (object = object.getValue()) == null) {
            return CommandResult.FAILED;
        }
        int id = ((Number)object).intValue();
        Cache<Integer, Session> nsSessions = SESSIONS.get(namespace2);
        Object object2 = nsSessions;
        if (object2 == null || (object2 = (Session)object2.getIfPresent((Object)id)) == null) {
            CommandResult commandResult = context.fail(KingdomsLang.COMMAND_SESSION_EXPIRED);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        Object session = object2;
        if (!((Session)session).getAuthorizedBy().test(PlayerUtils.getUniqueId(context.getMessageReceiver()))) {
            CommandResult commandResult = context.fail(KingdomsLang.COMMAND_SESSION_EXPIRED);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        SessionCallback sessionCallback = ((Session)session).getSessionCallback();
        String string = context.joinArgs("", 2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"joinArgs(...)");
        if (sessionCallback.callback(string)) {
            nsSessions.put((Object)id, session);
        } else {
            nsSessions.invalidate((Object)id);
        }
        return CommandResult.SUCCESS;
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final Session addSession(@NotNull Player authorizedBy, @NotNull Namespace namespace, @NotNull Duration expiresAfter, @NotNull MessagePlaceholderProvider messageContext, @NotNull SessionCallback callback) {
        return Companion.addSession(authorizedBy, namespace, expiresAfter, messageContext, callback);
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final Session addSession(@NotNull CommandContext context, @NotNull Duration expiresAfter, @NotNull SessionCallback callback) {
        return Companion.addSession(context, expiresAfter, callback);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0002J\b\u0010\f\u001a\u00020\tH\u0002J0\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J \u0010\r\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/kingdoms/commands/general/admin/CommandSession$Companion;", "", "<init>", "()V", "ID_COUNTER", "Ljava/util/concurrent/atomic/AtomicInteger;", "SESSIONS", "Lorg/kingdoms/constants/namespace/NamespacedMap;", "Lorg/kingdoms/libs/caffeine/cache/Cache;", "", "Lorg/kingdoms/commands/general/admin/CommandSession$Session;", "createCache", "incId", "addSession", "authorizedBy", "Lorg/bukkit/entity/Player;", "namespace", "Lorg/kingdoms/constants/namespace/Namespace;", "expiresAfter", "Ljava/time/Duration;", "messageContext", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "callback", "Lorg/kingdoms/commands/general/admin/CommandSession$SessionCallback;", "context", "Lorg/kingdoms/commands/CommandContext;", "core"})
    @SourceDebugExtension(value={"SMAP\nCommandSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandSession.kt\norg/kingdoms/commands/general/admin/CommandSession$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,148:1\n381#2,7:149\n381#2,7:156\n*S KotlinDebug\n*F\n+ 1 CommandSession.kt\norg/kingdoms/commands/general/admin/CommandSession$Companion\n*L\n85#1:149,7\n104#1:156,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Cache<Integer, Session> createCache() {
            Cache cache = CacheHandler.newBuilder().expireAfter((Expiry)new Expiry<Integer, Session>(){

                public long expireAfterCreate(int key, Session session, long currentTime) {
                    Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                    return session.getExpiresAfter().toNanos();
                }

                public long expireAfterUpdate(int key, Session session, long currentTime, long currentDuration) {
                    Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                    return currentDuration;
                }

                public long expireAfterRead(int key, Session session, long currentTime, long currentDuration) {
                    Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                    return currentDuration;
                }
            }).build();
            Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
            return cache;
        }

        private final int incId() {
            if (ID_COUNTER.get() >= Integer.MAX_VALUE) {
                ID_COUNTER.set(0);
                return 0;
            }
            return ID_COUNTER.getAndIncrement();
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @ApiStatus.Internal
        @NotNull
        public final Session addSession(@NotNull Player authorizedBy, @NotNull Namespace namespace, @NotNull Duration expiresAfter, @NotNull MessagePlaceholderProvider messageContext, @NotNull SessionCallback callback) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)authorizedBy, (String)"authorizedBy");
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            Intrinsics.checkNotNullParameter((Object)expiresAfter, (String)"expiresAfter");
            Intrinsics.checkNotNullParameter((Object)messageContext, (String)"messageContext");
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            Session session = new Session(namespace, this.incId(), arg_0 -> Companion.addSession$lambda$0(authorizedBy, arg_0), expiresAfter, callback);
            messageContext.raw("command_session_id", session.getId());
            messageContext.raw("command_namespace", session.getNamespace().asString());
            Map map = SESSIONS;
            Namespace key$iv = session.getNamespace();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Cache<Integer, Session> answer$iv = Companion.createCache();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Cache nsSessions = (Cache)object;
            nsSessions.put((Object)session.getId(), (Object)session);
            return session;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @ApiStatus.Internal
        @NotNull
        public final Session addSession(@NotNull CommandContext context, @NotNull Duration expiresAfter, @NotNull SessionCallback callback) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)expiresAfter, (String)"expiresAfter");
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            StringBuilder stringBuilder = new StringBuilder().append("COMMAND_");
            String string = context.getCommand().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Object object2 = string;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string2 = ((String)object2).toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            Namespace namespace = Namespace.kingdoms(stringBuilder.append(string2).toString());
            Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"kingdoms(...)");
            Session session = new Session(namespace, this.incId(), arg_0 -> Companion.addSession$lambda$2(context, arg_0), expiresAfter, callback);
            context.getMessageContext().raw("command_session_id", session.getId());
            context.getMessageContext().raw("command_namespace", session.getNamespace().asString());
            object2 = SESSIONS;
            Namespace key$iv = session.getNamespace();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Cache<Integer, Session> answer$iv = Companion.createCache();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Cache nsSessions = (Cache)object;
            nsSessions.put((Object)session.getId(), (Object)session);
            return session;
        }

        private static final boolean addSession$lambda$0(Player $authorizedBy, UUID it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)it, (Object)PlayerUtils.getUniqueId((CommandSender)$authorizedBy));
        }

        private static final boolean addSession$lambda$2(CommandContext $context, UUID it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)it, (Object)PlayerUtils.getUniqueId($context.getMessageReceiver()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lorg/kingdoms/commands/general/admin/CommandSession$Session;", "", "namespace", "Lorg/kingdoms/constants/namespace/Namespace;", "id", "", "authorizedBy", "Ljava/util/function/Predicate;", "Ljava/util/UUID;", "expiresAfter", "Ljava/time/Duration;", "sessionCallback", "Lorg/kingdoms/commands/general/admin/CommandSession$SessionCallback;", "<init>", "(Lorg/kingdoms/constants/namespace/Namespace;ILjava/util/function/Predicate;Ljava/time/Duration;Lorg/kingdoms/commands/general/admin/CommandSession$SessionCallback;)V", "getNamespace", "()Lorg/kingdoms/constants/namespace/Namespace;", "getId", "()I", "getAuthorizedBy", "()Ljava/util/function/Predicate;", "getExpiresAfter", "()Ljava/time/Duration;", "getSessionCallback", "()Lorg/kingdoms/commands/general/admin/CommandSession$SessionCallback;", "core"})
    public static final class Session {
        @NotNull
        private final Namespace namespace;
        private final int id;
        @NotNull
        private final Predicate<UUID> authorizedBy;
        @NotNull
        private final Duration expiresAfter;
        @NotNull
        private final SessionCallback sessionCallback;

        public Session(@NotNull Namespace namespace, int id, @NotNull Predicate<UUID> authorizedBy, @NotNull Duration expiresAfter, @NotNull SessionCallback sessionCallback) {
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            Intrinsics.checkNotNullParameter(authorizedBy, (String)"authorizedBy");
            Intrinsics.checkNotNullParameter((Object)expiresAfter, (String)"expiresAfter");
            Intrinsics.checkNotNullParameter((Object)sessionCallback, (String)"sessionCallback");
            this.namespace = namespace;
            this.id = id;
            this.authorizedBy = authorizedBy;
            this.expiresAfter = expiresAfter;
            this.sessionCallback = sessionCallback;
        }

        @NotNull
        public final Namespace getNamespace() {
            return this.namespace;
        }

        public final int getId() {
            return this.id;
        }

        @NotNull
        public final Predicate<UUID> getAuthorizedBy() {
            return this.authorizedBy;
        }

        @NotNull
        public final Duration getExpiresAfter() {
            return this.expiresAfter;
        }

        @NotNull
        public final SessionCallback getSessionCallback() {
            return this.sessionCallback;
        }
    }

    @FunctionalInterface
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00e7\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lorg/kingdoms/commands/general/admin/CommandSession$SessionCallback;", "", "callback", "", "answer", "", "core"})
    public static interface SessionCallback {
        public boolean callback(@NotNull String var1);
    }
}

