/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.admin;

import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.kingdoms.addons.Addon;
import org.kingdoms.addons.AddonRegistry;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsCommandHandler;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.managers.ConfigManager;
import org.kingdoms.config.managers.ConfigWatcher;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.upgradable.Powerup;
import org.kingdoms.constants.land.structures.StructureRegistry;
import org.kingdoms.constants.land.turrets.TurretRegistry;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.data.centers.DataCenter;
import org.kingdoms.gui.GUIConfig;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.StandardKingdomsPlaceholder;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.services.ServiceDiscordSRV;
import org.kingdoms.utils.config.adapters.YamlResource;

public class CommandReload
extends KingdomsCommand {
    private static boolean reloading;

    public CommandReload() {
        super("reload");
    }

    public static boolean isReloading() {
        return reloading;
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (reloading) {
            MessageHandler.sendPluginMessage(context.getMessageReceiver(), "&4The plugin is still in the process of reloading... Please wait.");
            return CommandResult.FAILED;
        }
        reloading = true;
        ConfigWatcher.setAccepting(false);
        KLogger.info("Performing a full reload for the plugin...");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            try {
                KLogger.info("Setting up file manager...");
                ConfigManager manager = new ConfigManager(Kingdoms.get());
                manager.createDataFolderIfMissing();
                KLogger.info("Reloading langauge and GUI files...");
                LanguageManager.loadAll();
                GUIConfig.reloadAll();
                KLogger.info("Reloading configs...");
                for (YamlResource config : ConfigManager.getConfigs()) {
                    config.reload();
                }
                if (KingdomsConfig.UPDATES_CONFIGS.getBoolean()) {
                    ConfigManager.updateConfigs();
                }
                manager.validateConfigs();
                KLogger.info("Reregistering event listeners...");
                HandlerList.unregisterAll((Plugin)plugin);
                Kingdoms.get().registerAllEvents();
                KLogger.info("Registering commands...");
                KingdomsCommandHandler.reload();
                KLogger.info("Reinitializing other services...");
                Rank.init();
                KingdomRelation.init();
                Powerup.init();
                ServiceDiscordSRV.init(true);
                StandardKingdomsPlaceholder.init();
                TurretRegistry.get().init();
                StructureRegistry.get().init();
                plugin.getDataCenter().getKingdomManager().configureTopData();
                plugin.getDataCenter().getNationManager().configureTopData();
                plugin.getDataCenter().saveAll(DataCenter.SaveType.MANUAL);
                Collection<Addon> addons = AddonRegistry.getAddons().values();
                if (!addons.isEmpty()) {
                    KLogger.info("Reloading addons...");
                    for (Addon addon : addons) {
                        try {
                            addon.reloadAddon();
                        }
                        catch (Exception ex) {
                            KLogger.error("Error while reloading '" + addon.getName() + "' addon");
                            ex.printStackTrace();
                        }
                    }
                }
                context.sendMessage((Messenger)KingdomsLang.COMMAND_RELOAD_SUCCESS, new Object[0]);
                KLogger.info("Reloading done.");
                reloading = false;
                ConfigWatcher.setAccepting(true);
            }
            catch (Throwable ex) {
                reloading = false;
                context.fail(KingdomsLang.COMMAND_RELOAD_ERROR);
                ex.printStackTrace();
            }
        });
        return CommandResult.SUCCESS;
    }
}

