/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.nexus;

import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.utils.internal.functional.Fn;

public class CommandAdminNexusTeleport
extends KingdomsCommand {
    public CommandAdminNexusTeleport(KingdomsParentCommand admin) {
        super("teleport", admin);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        context.assertPlayer();
        Player player = context.senderAsPlayer();
        Kingdom kingdom = (Kingdom)context.generalSelector(false);
        SimpleLocation nexus = kingdom.getNexus();
        if (nexus == null) {
            KingdomsLang.COMMAND_ADMIN_NEXUS_TELEPORT_NOT_SET.sendMessage((CommandSender)player, "kingdom", kingdom.getName());
            return CommandResult.FAILED;
        }
        KingdomsLang.COMMAND_ADMIN_NEXUS_TELEPORT_TELEPORTING.sendMessage((CommandSender)player, "kingdom", kingdom.getName());
        player.teleport(nexus.toBukkitLocation());
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        return context.tabCompleteGeneralSelector(false, true, Fn.alwaysTrue()).build();
    }
}

