/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.nexus;

import java.util.List;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.building.Building;
import org.kingdoms.constants.land.building.BuildingConstruction;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.utils.internal.functional.Fn;
import org.kingdoms.utils.internal.numbers.AnyNumber;
import org.kingdoms.utils.internal.numbers.NumberConstraint;

public class CommandAdminNexusLevel
extends KingdomsCommand {
    public CommandAdminNexusLevel(KingdomsParentCommand admin) {
        super("level", admin);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        context.assertPlayer();
        Kingdom kingdom = (Kingdom)context.generalSelector(false);
        AnyNumber newLevel = context.numberModifier("level", kingdom.getLevel(), NumberConstraint.INTEGER_ONLY, NumberConstraint.POSITIVE);
        int currentLevel = kingdom.getLevel();
        int targetLevel = newLevel.getValue().intValue();
        if (currentLevel == targetLevel) {
            context.var("level", currentLevel);
            return context.fail(KingdomsLang.COMMAND_ADMIN_NEXUS_LEVEL_ALREADY_LEVEL);
        }
        if (targetLevel < currentLevel) {
            return context.fail(KingdomsLang.COMMAND_ADMIN_NEXUS_LEVEL_CANT_DOWNGRADE);
        }
        while (currentLevel != targetLevel) {
            Structure nexusStruct;
            Building building;
            Land nexusLand;
            kingdom.changeLevel(currentLevel + 1, context.senderAsPlayer());
            SimpleLocation nexus = kingdom.getNexus();
            if (nexus != null && (nexusLand = nexus.toSimpleChunkLocation().getLand()) != null && (building = (nexusStruct = nexusLand.getKingdomBlock(nexus.toBlockVector(), Structure.class)).getBuilding()) instanceof BuildingConstruction) {
                ((BuildingConstruction)building).finishInstantly();
            }
            currentLevel = kingdom.getLevel();
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        return context.tabCompleteGeneralSelector(false, true, Fn.alwaysTrue()).then(() -> context.tabCompleteNumberModifier("level", new NumberConstraint[0])).build();
    }
}

