/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.nation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.events.general.GroupDisband;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;

public class CommandAdminNationDisband
extends KingdomsCommand {
    public CommandAdminNationDisband(KingdomsParentCommand parent) {
        super("disband", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        String[] args = context.args;
        CommandSender sender = context.getMessageReceiver();
        Nation nation = Nation.getNation(args[0]);
        if (nation == null) {
            KingdomsLang.NOT_FOUND_NATION.sendMessage(sender);
            return CommandResult.FAILED;
        }
        if (nation.disband(GroupDisband.Reason.ADMIN).isCancelled()) {
            return CommandResult.FAILED;
        }
        KingdomsLang.COMMAND_ADMIN_NATION_DISBAND_SUCCESS.sendMessage(sender, "nation", nation.getName());
        if ((context.isAtArg(0) || !args[1].equalsIgnoreCase("silent")) && KingdomsConfig.DISBAND_ANNOUNCE.getBoolean()) {
            for (Player players : Bukkit.getOnlinePlayers()) {
                KingdomsLang.COMMAND_ADMIN_NATION_DISBAND_ANNOUNCE.sendMessage((CommandSender)players, "player", sender.getName(), "nation", nation.getName());
            }
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        if (context.isAtArg(0)) {
            return context.getNations(0);
        }
        if (context.isAtArg(1)) {
            return Collections.singletonList("silent");
        }
        return new ArrayList<String>();
    }
}

