/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.item;

import com.google.common.base.Enums;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.kingdoms.commands.admin.CommandAdminLanguagePack;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.GUIBuilder;
import org.kingdoms.gui.GUIOption;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.InventoryInteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.OptionCategory;
import org.kingdoms.gui.OptionHandler;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Unit;
import org.kingdoms.libs.kotlin.collections.ArraysKt;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.ArrayIteratorKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.Reflection;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.libs.xseries.XEnchantment;
import org.kingdoms.libs.xseries.XItemFlag;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.profiles.builder.XSkull;
import org.kingdoms.libs.xseries.profiles.objects.Profileable;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageCompilerSettings;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.nbt.tag.NBTTag;
import org.kingdoms.nbt.tag.NBTTagByte;
import org.kingdoms.nbt.tag.NBTTagByteArray;
import org.kingdoms.nbt.tag.NBTTagCompound;
import org.kingdoms.nbt.tag.NBTTagDouble;
import org.kingdoms.nbt.tag.NBTTagEnd;
import org.kingdoms.nbt.tag.NBTTagFloat;
import org.kingdoms.nbt.tag.NBTTagInt;
import org.kingdoms.nbt.tag.NBTTagIntArray;
import org.kingdoms.nbt.tag.NBTTagList;
import org.kingdoms.nbt.tag.NBTTagLong;
import org.kingdoms.nbt.tag.NBTTagLongArray;
import org.kingdoms.nbt.tag.NBTTagShort;
import org.kingdoms.nbt.tag.NBTTagString;
import org.kingdoms.nbt.tag.NBTTagType;
import org.kingdoms.platform.bukkit.item.ItemNBT;
import org.kingdoms.utils.ProcessToMessage;
import org.kingdoms.utils.cache.EnumCache;
import org.kingdoms.utils.internal.numbers.AnyNumber;
import org.kingdoms.utils.internal.numbers.NumberConstraint;
import org.kingdoms.utils.internal.numbers.NumberProcessor;
import org.kingdoms.utils.string.Strings;
import org.kingdoms.utils.string.tree.StringPathBuilder;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001/B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0002J!\u0010\u000e\u001a\n \n*\u0004\u0018\u00010\u000f0\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J&\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\"\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\u0006\u0010\u0019\u001a\u00020\u000f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u001e\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u000fJ\u0012\u0010\"\u001a\u00020\u0005*\u00020\u00052\u0006\u0010#\u001a\u00020\u0005J.\u0010$\u001a\u00020\u001d2\b\u0010%\u001a\u0004\u0018\u00010&2\u000e\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010&0(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001d0(J*\u0010*\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020+2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020+0(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001d0(J\u0006\u0010,\u001a\u00020\u0014J\u0006\u0010-\u001a\u00020\u0014J\u0010\u0010.\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u00060"}, d2={"Lorg/kingdoms/commands/admin/item/ItemEditor;", "", "player", "Lorg/bukkit/entity/Player;", "item", "Lorg/bukkit/inventory/ItemStack;", "<init>", "(Lorg/bukkit/entity/Player;Lorg/bukkit/inventory/ItemStack;)V", "rootNBT", "Lorg/kingdoms/nbt/tag/NBTTagCompound;", "org.kingdoms.libs.kotlin.jvm.PlatformType", "Lorg/kingdoms/nbt/tag/NBTTagCompound;", "getEditsForItem", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "getTypeOfNBT", "", "nbt", "Lorg/kingdoms/nbt/tag/NBTTag;", "(Lorg/kingdoms/nbt/tag/NBTTag;)Ljava/lang/String;", "buildPathsFrom", "", "list", "", "currentPath", "constructNBT", "type", "value", "", "openGUI", "Lorg/kingdoms/gui/InteractiveGUI;", "getItemFromGUI", "gui", "Lorg/kingdoms/gui/KingdomsGUI;", "optionName", "inheritLoreAndType", "other", "openEquipmentSlotSelector", "currentValue", "Lorg/bukkit/inventory/EquipmentSlot;", "selected", "Ljava/util/function/Consumer;", "guiModifier", "openAttributeOperationsGUI", "Lorg/bukkit/attribute/AttributeModifier$Operation;", "openFlagsGUI", "openEnchantsGUI", "finalize", "NBTEditor", "core"})
@SourceDebugExtension(value={"SMAP\nCommandAdminItemEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandAdminItemEditor.kt\norg/kingdoms/commands/admin/item/ItemEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,802:1\n1557#2:803\n1628#2,3:804\n1557#2:807\n1628#2,3:808\n1557#2:811\n1628#2,3:812\n1557#2:815\n1628#2,3:816\n1557#2:819\n1628#2,3:820\n1863#2,2:827\n37#3:823\n36#3,3:824\n*S KotlinDebug\n*F\n+ 1 CommandAdminItemEditor.kt\norg/kingdoms/commands/admin/item/ItemEditor\n*L\n142#1:803\n142#1:804,3\n152#1:807\n152#1:808,3\n153#1:811\n153#1:812,3\n154#1:815\n154#1:816,3\n409#1:819\n409#1:820,3\n786#1:827,2\n735#1:823\n735#1:824,3\n*E\n"})
public final class ItemEditor {
    @NotNull
    private final Player player;
    @NotNull
    private ItemStack item;
    private final NBTTagCompound rootNBT;

    public ItemEditor(@NotNull Player player, @NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.player = player;
        this.item = item;
        this.rootNBT = ItemNBT.getTag(this.item);
    }

    private final MessagePlaceholderProvider getEditsForItem() {
        String string;
        ItemMeta itemMeta = this.item.getItemMeta();
        Intrinsics.checkNotNull((Object)itemMeta);
        ItemMeta meta = itemMeta;
        MessagePlaceholderProvider messagePlaceholderProvider = new MessagePlaceholderProvider();
        Object[] objectArray = new Object[2];
        objectArray[0] = "item_name";
        if (meta.hasDisplayName()) {
            String string2 = meta.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
            string = StringsKt.replace$default((String)string2, (char)'\u00a7', (char)'&', (boolean)false, (int)4, null);
        } else {
            string = Strings.capitalize(this.item.getType().name());
        }
        objectArray[1] = string;
        MessagePlaceholderProvider settings = messagePlaceholderProvider.placeholders(objectArray).raw("item_amount", this.item.getAmount()).parse("item_material", KingdomsLang.translate(XMaterial.matchXMaterial((ItemStack)this.item))).raw("item_custom_model_data", XReflection.supports((int)14) && meta.hasCustomModelData() ? meta.getCustomModelData() : 0).raw("item_unbreakable", meta.isUnbreakable());
        for (XItemFlag flag : XItemFlag.getValues()) {
            String string3;
            StringBuilder stringBuilder = new StringBuilder().append("item_flag_");
            Intrinsics.checkNotNullExpressionValue((Object)flag.name(), (String)"<get-name>(...)");
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string4 = string3.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            settings.raw(stringBuilder.append(string4).toString(), flag.has(meta) ? KingdomsLang.ENABLED.parse(new Object[0]) : KingdomsLang.DISABLED.parse(new Object[0]));
        }
        Intrinsics.checkNotNull((Object)settings);
        return settings;
    }

    private final String getTypeOfNBT(NBTTag<?> nbt) {
        NBTTag<?> nBTTag = nbt;
        return nBTTag instanceof NBTTagString ? "string" : (nBTTag instanceof NBTTagInt ? "int" : (nBTTag instanceof NBTTagDouble ? "double" : (nBTTag instanceof NBTTagByte ? "byte" : (nBTTag instanceof NBTTagLong ? "long" : (nBTTag instanceof NBTTagShort ? "short" : (nBTTag instanceof NBTTagEnd ? "end" : (nBTTag instanceof NBTTagFloat ? "float" : (nBTTag instanceof NBTTagCompound ? "compound" : (nBTTag instanceof NBTTagList ? "list" : (nBTTag instanceof NBTTagIntArray ? "intArray" : (nBTTag instanceof NBTTagLongArray ? "longArray" : (nBTTag instanceof NBTTagByteArray ? "byteArray" : nbt.getClass().getSimpleName()))))))))))));
    }

    private final void buildPathsFrom(List<String> list, NBTTagCompound nbt, String currentPath) {
        if (nbt.value().isEmpty()) {
            list.add(currentPath);
            return;
        }
        Object object = nbt.value();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
        for (Map.Entry entry : object.entrySet()) {
            String path;
            String key = (String)entry.getKey();
            NBTTag value = (NBTTag)entry.getValue();
            String string = path = ((CharSequence)currentPath).length() == 0 ? key : currentPath + '/' + key;
            if (value instanceof NBTTagCompound) {
                NBTTagCompound nBTTagCompound = (NBTTagCompound)value;
                Intrinsics.checkNotNull((Object)path);
                this.buildPathsFrom(list, nBTTagCompound, path);
                continue;
            }
            Intrinsics.checkNotNull((Object)path);
            list.add(path);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final NBTTag<?> constructNBT(@NotNull String type, @NotNull Collection<String> value) {
        NBTTag nBTTag;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        switch (type) {
            case "NBTTagCompound": {
                nBTTag = NBTTagCompound.empty();
                break;
            }
            case "NBTTagString": {
                nBTTag = NBTTagString.of(CollectionsKt.joinToString$default((Iterable)value, null, null, null, (int)0, null, null, (int)63, null));
                break;
            }
            case "NBTTagList": {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = value;
                NBTTagType<NBTTagString> nBTTagType = NBTTagType.STRING;
                boolean $i$f$map = false;
                void var6_16 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void x;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(NBTTagString.of((String)x));
                }
                nBTTag = NBTTagList.of(nBTTagType, (List)destination$iv$iv);
                break;
            }
            case "NBTTagEnd": {
                nBTTag = NBTTagEnd.instance();
                break;
            }
            case "NBTTagByte": {
                nBTTag = NBTTagByte.of(Byte.parseByte(CollectionsKt.joinToString$default((Iterable)value, null, null, null, (int)0, null, null, (int)63, null)));
                break;
            }
            case "NBTTagShort": {
                nBTTag = NBTTagShort.of(Short.parseShort(CollectionsKt.joinToString$default((Iterable)value, null, null, null, (int)0, null, null, (int)63, null)));
                break;
            }
            case "NBTTagInt": {
                nBTTag = NBTTagInt.of(Integer.parseInt(CollectionsKt.joinToString$default((Iterable)value, null, null, null, (int)0, null, null, (int)63, null)));
                break;
            }
            case "NBTTagLong": {
                nBTTag = NBTTagLong.of(Long.parseLong(CollectionsKt.joinToString$default((Iterable)value, null, null, null, (int)0, null, null, (int)63, null)));
                break;
            }
            case "NBTTagFloat": {
                nBTTag = NBTTagFloat.of(Float.parseFloat(CollectionsKt.joinToString$default((Iterable)value, null, null, null, (int)0, null, null, (int)63, null)));
                break;
            }
            case "NBTTagDouble": {
                nBTTag = NBTTagDouble.of(Double.parseDouble(CollectionsKt.joinToString$default((Iterable)value, null, null, null, (int)0, null, null, (int)63, null)));
                break;
            }
            case "NBTTagByteArray": {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = value;
                boolean $i$f$map = false;
                Iterable destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void x;
                    String bl = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(Byte.parseByte((String)x));
                }
                byte[] byArray = CollectionsKt.toByteArray((Collection)((List)destination$iv$iv2));
                nBTTag = NBTTagByteArray.of(Arrays.copyOf(byArray, byArray.length));
                break;
            }
            case "NBTTagIntArray": {
                Iterable $this$map$iv = value;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String x = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Integer.parseInt(x));
                }
                int[] nArray = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
                nBTTag = NBTTagIntArray.of(Arrays.copyOf(nArray, nArray.length));
                break;
            }
            case "NBTTagLongArray": {
                Iterable $this$map$iv = value;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String x = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Long.parseLong(x));
                }
                long[] lArray = CollectionsKt.toLongArray((Collection)((List)destination$iv$iv));
                nBTTag = NBTTagLongArray.of(Arrays.copyOf(lArray, lArray.length));
                break;
            }
            default: {
                nBTTag = null;
            }
        }
        return nBTTag;
    }

    @NotNull
    public final InteractiveGUI openGUI() {
        Object t = new GUIBuilder(KingdomsGUI.ITEM$EDITOR_MAIN).forPlayer(this.player).withSettings(this.getEditsForItem()).inventoryGUIOnly().build();
        Intrinsics.checkNotNull(t);
        InventoryInteractiveGUI gui = (InventoryInteractiveGUI)t;
        ItemMeta itemMeta = this.item.getItemMeta();
        Intrinsics.checkNotNull((Object)itemMeta);
        ItemMeta meta = itemMeta;
        gui.option("item").editItem(arg_0 -> ItemEditor.openGUI$lambda$4(this, arg_0)).done();
        gui.option("name").onNormalClicks(ItemEditor::openGUI$lambda$5).setConversation((arg_0, arg_1) -> ItemEditor.openGUI$lambda$6(meta, this, arg_0, arg_1)).done();
        gui.option("lore").onNormalClicks(ItemEditor::openGUI$lambda$7).setConversation((arg_0, arg_1) -> ItemEditor.openGUI$lambda$8(meta, this, arg_0, arg_1)).editItem(arg_0 -> ItemEditor.openGUI$lambda$10(meta, arg_0)).done();
        gui.option("material").onNormalClicks(ItemEditor::openGUI$lambda$11).setConversation((arg_0, arg_1) -> ItemEditor.openGUI$lambda$12(this, arg_0, arg_1)).editItem(arg_0 -> ItemEditor.openGUI$lambda$13(this, arg_0)).done();
        gui.option("amount").onNormalClicks(ItemEditor::openGUI$lambda$14).setConversation((arg_0, arg_1) -> ItemEditor.openGUI$lambda$15(this, arg_0, arg_1)).done();
        gui.option("custom-model-data").onNormalClicks(ItemEditor::openGUI$lambda$16).setConversation((arg_0, arg_1) -> ItemEditor.openGUI$lambda$17(meta, this, arg_0, arg_1)).done();
        gui.option("enchantments").onNormalClicks(() -> ItemEditor.openGUI$lambda$18(this)).editItem(arg_0 -> ItemEditor.openGUI$lambda$19(meta, arg_0)).done();
        gui.option("flags").onNormalClicks(() -> ItemEditor.openGUI$lambda$20(this)).done();
        gui.option("nbt").onNormalClicks(() -> ItemEditor.openGUI$lambda$23(this)).editItem(arg_0 -> ItemEditor.openGUI$lambda$25(this, arg_0)).done();
        gui.option("unbreakable").onNormalClicks(() -> ItemEditor.openGUI$lambda$26(meta, this)).done();
        gui.onClose(() -> ItemEditor.openGUI$lambda$27(gui, this));
        InteractiveGUI.open$default(gui, false, false, 3, null);
        return gui;
    }

    @NotNull
    public final ItemStack getItemFromGUI(@NotNull KingdomsGUI gui, @NotNull Player player, @NotNull String optionName) {
        Intrinsics.checkNotNullParameter((Object)gui, (String)"gui");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)optionName, (String)"optionName");
        InteractiveGUI fakeGUI = GUIAccessor.prepare(player, gui);
        Object[] objectArray = new Object[]{"enabled", true};
        OptionHandler opt = fakeGUI.option(optionName).setEdits(objectArray);
        GUIOption obj = opt.constructGUIOptionObject();
        obj.defineVariables(opt.getMessageContext());
        ItemStack itemStack = obj.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
        return itemStack;
    }

    @NotNull
    public final ItemStack inheritLoreAndType(@NotNull ItemStack $this$inheritLoreAndType, @NotNull ItemStack other) {
        Intrinsics.checkNotNullParameter((Object)$this$inheritLoreAndType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        $this$inheritLoreAndType.setType(other.getType());
        if (other.hasItemMeta()) {
            GameProfile skinValue;
            ItemMeta itemMeta = other.getItemMeta();
            Intrinsics.checkNotNull((Object)itemMeta);
            ItemMeta otherMeta = itemMeta;
            ItemMeta itemMeta2 = $this$inheritLoreAndType.getItemMeta();
            Intrinsics.checkNotNull((Object)itemMeta2);
            ItemMeta meta = itemMeta2;
            if (otherMeta instanceof SkullMeta && (skinValue = XSkull.of((ItemMeta)otherMeta).getProfile()) != null) {
                XSkull.of((ItemMeta)((ItemMeta)((SkullMeta)meta))).profile(Profileable.of((GameProfile)skinValue)).apply();
            }
            if (otherMeta.hasLore()) {
                meta.setLore(otherMeta.getLore());
            }
            $this$inheritLoreAndType.setItemMeta(meta);
        }
        return $this$inheritLoreAndType;
    }

    @NotNull
    public final InteractiveGUI openEquipmentSlotSelector(@Nullable EquipmentSlot currentValue, @NotNull Consumer<EquipmentSlot> selected, @NotNull Consumer<InteractiveGUI> guiModifier) {
        Intrinsics.checkNotNullParameter(selected, (String)"selected");
        Intrinsics.checkNotNullParameter(guiModifier, (String)"guiModifier");
        InteractiveGUI gui = GUIAccessor.prepare(this.player, KingdomsGUI.ITEM$EDITOR_ATTRIBUTES_EQUIPMENT$SLOTS);
        Object[] objectArray = ArrayIteratorKt.iterator((Object[])EnumCache.EQUIPMENT_SLOTS);
        while (objectArray.hasNext()) {
            EquipmentSlot equipSlot = (EquipmentSlot)objectArray.next();
            String string = Strings.configOption((Enum)equipSlot);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configOption(...)");
            Object[] objectArray2 = new Object[]{"enabled", currentValue == equipSlot};
            gui.option(string).setEdits(objectArray2).onNormalClicks(() -> ItemEditor.openEquipmentSlotSelector$lambda$28(selected, equipSlot)).done();
        }
        objectArray = new Object[]{"enabled", currentValue == null};
        gui.option("none").setEdits(objectArray).onNormalClicks(() -> ItemEditor.openEquipmentSlotSelector$lambda$29(selected)).done();
        guiModifier.accept(gui);
        Intrinsics.checkNotNull((Object)gui);
        return this.finalize(gui);
    }

    @NotNull
    public final InteractiveGUI openAttributeOperationsGUI(@NotNull AttributeModifier.Operation currentValue, @NotNull Consumer<AttributeModifier.Operation> selected, @NotNull Consumer<InteractiveGUI> guiModifier) {
        Intrinsics.checkNotNullParameter((Object)currentValue, (String)"currentValue");
        Intrinsics.checkNotNullParameter(selected, (String)"selected");
        Intrinsics.checkNotNullParameter(guiModifier, (String)"guiModifier");
        InteractiveGUI gui = GUIAccessor.prepare(this.player, KingdomsGUI.ITEM$EDITOR_ATTRIBUTES_OPERATIONS);
        for (AttributeModifier.Operation operation : AttributeModifier.Operation.values()) {
            String string = Strings.configOption((Enum)operation);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configOption(...)");
            Object[] objectArray = new Object[]{"enabled", currentValue == operation};
            gui.option(string).setEdits(objectArray).onNormalClicks(() -> ItemEditor.openAttributeOperationsGUI$lambda$30(selected, operation)).done();
        }
        guiModifier.accept(gui);
        Intrinsics.checkNotNull((Object)gui);
        return this.finalize(gui);
    }

    public final void openFlagsGUI() {
        InteractiveGUI gui = GUIAccessor.prepare(this.player, KingdomsGUI.ITEM$EDITOR_FLAGS, this.getEditsForItem());
        ItemMeta itemMeta = this.item.getItemMeta();
        Intrinsics.checkNotNull((Object)itemMeta);
        ItemMeta meta = itemMeta;
        for (OptionCategory option : gui.getOptions("flag")) {
            Object[] objectArray = option.getName();
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string = objectArray.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            com.google.common.base.Optional flagOpt = Enums.getIfPresent(ItemFlag.class, (String)StringsKt.replace$default((String)string, (char)'-', (char)'_', (boolean)false, (int)4, null));
            if (flagOpt.isPresent()) {
                ItemFlag flag = (ItemFlag)flagOpt.get();
                Object[] objectArray2 = new Object[]{"supported", true, "enabled", meta.hasItemFlag(flag)};
                option.getOption().setEdits(objectArray2).onNormalClicks(() -> ItemEditor.openFlagsGUI$lambda$31(meta, flag, this)).done();
                continue;
            }
            objectArray = new Object[]{"supported", false, "enabled", false};
            option.getOption().setEdits(objectArray).done();
        }
        gui.option("remove-all").onNormalClicks(() -> ItemEditor.openFlagsGUI$lambda$36(meta, this)).done();
        gui.option("back").onNormalClicks(() -> ItemEditor.openFlagsGUI$lambda$37(this)).done();
        Intrinsics.checkNotNull((Object)gui);
        this.finalize(gui);
    }

    public final void openEnchantsGUI() {
        InteractiveGUI gui = GUIAccessor.prepare(this.player, KingdomsGUI.ITEM$EDITOR_ENCHANTMENTS, this.getEditsForItem());
        ItemMeta itemMeta = this.item.getItemMeta();
        Intrinsics.checkNotNull((Object)itemMeta);
        ItemMeta meta = itemMeta;
        for (OptionCategory entry : gui.getOptions("enchant")) {
            Optional xEnchant = XEnchantment.of((String)entry.getName());
            OptionHandler option = entry.getOption();
            if (!xEnchant.isPresent() || !((XEnchantment)xEnchant.get()).isSupported()) {
                Object[] objectArray = new Object[]{"enabled", false, "supported", false};
                option.setEdits(objectArray).done();
                continue;
            }
            Object object = ((XEnchantment)xEnchant.get()).get();
            Intrinsics.checkNotNull((Object)object);
            Enchantment enchant = (Enchantment)object;
            Object[] objectArray = new Object[]{"enabled", meta.hasEnchant(enchant), "supported", true, "level", meta.getEnchantLevel(enchant)};
            option.setEdits(objectArray).on(ClickType.LEFT, ItemEditor::openEnchantsGUI$lambda$38).setConversation((arg_0, arg_1) -> ItemEditor.openEnchantsGUI$lambda$39(meta, enchant, this, arg_0, arg_1)).on(ClickType.RIGHT, () -> ItemEditor.openEnchantsGUI$lambda$40(meta, enchant, this)).done();
        }
        gui.option("remove-all").onNormalClicks(() -> ItemEditor.openEnchantsGUI$lambda$42(meta, this)).done();
        gui.option("back").onNormalClicks(() -> ItemEditor.openEnchantsGUI$lambda$43(this)).done();
        Intrinsics.checkNotNull((Object)gui);
        this.finalize(gui);
    }

    private final InteractiveGUI finalize(InteractiveGUI gui) {
        gui.onClose(() -> ItemEditor.finalize$lambda$44(gui, this));
        InteractiveGUI.open$default(gui, false, false, 3, null);
        return gui;
    }

    private static final ItemStack openGUI$lambda$4(ItemEditor this$0, ItemStack it) {
        return this$0.item;
    }

    private static final void openGUI$lambda$5(OptionHandler ctx) {
        ctx.sendMessage((Messenger)KingdomsLang.ITEM_EDITOR_NAME_ENTER, new Object[0]);
        ctx.startConversation();
    }

    private static final void openGUI$lambda$6(ItemMeta $meta, ItemEditor this$0, OptionHandler ctx, String input) {
        $meta.setDisplayName(input);
        this$0.item.setItemMeta($meta);
        ctx.endConversation();
        this$0.openGUI();
    }

    private static final void openGUI$lambda$7(OptionHandler ctx) {
        ctx.sendMessage((Messenger)KingdomsLang.ITEM_EDITOR_LORE_ENTER, new Object[0]);
        ctx.startConversation();
    }

    private static final void openGUI$lambda$8(ItemMeta $meta, ItemEditor this$0, OptionHandler ctx, String input) {
        Intrinsics.checkNotNull((Object)input);
        String[] stringArray = new String[]{"\\n"};
        $meta.setLore(CollectionsKt.toList((Iterable)StringsKt.split$default((CharSequence)input, (String[])stringArray, (boolean)false, (int)0, (int)6, null)));
        this$0.item.setItemMeta($meta);
        ctx.endConversation();
        this$0.openGUI();
    }

    private static final ItemStack openGUI$lambda$10(ItemMeta $meta, ItemStack optionItem) {
        block0: {
            ItemMeta itemMeta = optionItem.getItemMeta();
            if (itemMeta == null) break block0;
            ItemMeta optionMeta = itemMeta;
            boolean bl = false;
            optionMeta.setLore($meta.getLore());
            optionItem.setItemMeta(optionMeta);
        }
        return optionItem;
    }

    private static final void openGUI$lambda$11(OptionHandler ctx) {
        ctx.sendMessage((Messenger)KingdomsLang.ITEM_EDITOR_MATERIAL_ENTER, new Object[0]);
        ctx.startConversation();
    }

    private static final void openGUI$lambda$12(ItemEditor this$0, OptionHandler ctx, String input) {
        Optional optional = XMaterial.matchXMaterial((String)input);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"matchXMaterial(...)");
        Optional material = optional;
        if (!material.isPresent()) {
            ctx.getMessageContext().raw("material", input);
            ctx.sendError(KingdomsLang.INVALID_MATERIAL, new Object[0]);
            return;
        }
        ((XMaterial)material.get()).setType(this$0.item);
        ctx.endConversation();
        this$0.openGUI();
    }

    private static final ItemStack openGUI$lambda$13(ItemEditor this$0, ItemStack optionItem) {
        optionItem.setType(this$0.item.getType());
        return optionItem;
    }

    private static final void openGUI$lambda$14(OptionHandler ctx) {
        ctx.sendMessage((Messenger)KingdomsLang.ITEM_EDITOR_AMOUNT_ENTER, new Object[0]);
        ctx.startConversation();
    }

    private static final void openGUI$lambda$15(ItemEditor this$0, OptionHandler ctx, String input) {
        Intrinsics.checkNotNull((Object)input);
        NumberConstraint[] numberConstraintArray = new NumberConstraint[]{NumberConstraint.INTEGER_ONLY, NumberConstraint.POSITIVE};
        AnyNumber anyNumber = ProcessToMessage.getNumberOrError(new NumberProcessor(input).withAllDecorators().withConstraints(numberConstraintArray), "item amount", ctx);
        if (anyNumber == null) {
            return;
        }
        AnyNumber amount = anyNumber;
        if (amount.compareTo(AnyNumber.Companion.getAbstractNumber(127)) > 0) {
            ctx.sendError(KingdomsLang.ITEM_EDITOR_AMOUNT_WARNING, new Object[0]);
        }
        this$0.item.setAmount(amount.getValue().intValue());
        ctx.endConversation();
        this$0.openGUI();
    }

    private static final void openGUI$lambda$16(OptionHandler ctx) {
        if (!XReflection.supports((int)14)) {
            ctx.sendError(KingdomsLang.ITEM_EDITOR_CUSTOM_MODEL_DATA_NOT_SUPPORTED, new Object[0]);
            return;
        }
        ctx.sendMessage((Messenger)KingdomsLang.ITEM_EDITOR_CUSTOM_MODEL_DATA_ENTER, new Object[0]);
        ctx.startConversation();
    }

    private static final void openGUI$lambda$17(ItemMeta $meta, ItemEditor this$0, OptionHandler ctx, String input) {
        Intrinsics.checkNotNull((Object)input);
        NumberConstraint[] numberConstraintArray = new NumberConstraint[]{NumberConstraint.INTEGER_ONLY, NumberConstraint.POSITIVE};
        AnyNumber anyNumber = ProcessToMessage.getNumberOrError(new NumberProcessor(input).withAllDecorators().withConstraints(numberConstraintArray), "custom model data", ctx);
        if (anyNumber == null) {
            return;
        }
        AnyNumber amount = anyNumber;
        $meta.setCustomModelData(Integer.valueOf(amount.getValue().intValue()));
        this$0.item.setItemMeta($meta);
        ctx.endConversation();
        this$0.openGUI();
    }

    private static final void openGUI$lambda$18(ItemEditor this$0) {
        this$0.openEnchantsGUI();
    }

    private static final ItemStack openGUI$lambda$19(ItemMeta $meta, ItemStack innerItem) {
        List list;
        ItemMeta itemMeta = innerItem.getItemMeta();
        Intrinsics.checkNotNull((Object)itemMeta);
        ItemMeta innerMeta = itemMeta;
        if (innerMeta.hasLore()) {
            List list2 = innerMeta.getLore();
            list = list2;
            Intrinsics.checkNotNull((Object)list2);
        } else {
            list = new ArrayList();
        }
        List lore = list;
        Map map = $meta.getEnchants();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnchants(...)");
        for (Map.Entry entry : map.entrySet()) {
            Enchantment enchant = (Enchantment)entry.getKey();
            Integer level = (Integer)entry.getValue();
            String string = MessageCompiler.compile("{$dot} {$p}" + XEnchantment.of((Enchantment)enchant) + "{$sep}: {$s}" + level, MessageCompilerSettings.none().colorize().translatePlaceholders()).buildPlain(new MessagePlaceholderProvider());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buildPlain(...)");
            lore.add(string);
        }
        innerMeta.setLore(lore);
        innerItem.setItemMeta(innerMeta);
        return innerItem;
    }

    private static final void openGUI$lambda$20(ItemEditor this$0) {
        this$0.openFlagsGUI();
    }

    private static final void openGUI$lambda$23$lambda$22$lambda$21(ItemEditor this$0) {
        this$0.openGUI();
    }

    private static final void openGUI$lambda$23$lambda$22(ItemEditor this$0, InteractiveGUI innerGUI) {
        Intrinsics.checkNotNullParameter((Object)innerGUI, (String)"innerGUI");
        innerGUI.push("back", () -> ItemEditor.openGUI$lambda$23$lambda$22$lambda$21(this$0), new Object[0]);
    }

    private static final void openGUI$lambda$23(ItemEditor this$0) {
        NBTTagCompound nBTTagCompound = this$0.rootNBT;
        Intrinsics.checkNotNullExpressionValue((Object)nBTTagCompound, (String)"rootNBT");
        this$0.new NBTEditor(nBTTagCompound, new String[0], arg_0 -> ItemEditor.openGUI$lambda$23$lambda$22(this$0, arg_0)).openNBTViewerGUI();
    }

    /*
     * WARNING - void declaration
     */
    private static final ItemStack openGUI$lambda$25(ItemEditor this$0, ItemStack innerItem) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List list;
        ItemMeta itemMeta = innerItem.getItemMeta();
        Intrinsics.checkNotNull((Object)itemMeta);
        ItemMeta innerMeta = itemMeta;
        if (innerMeta.hasLore()) {
            List list2 = innerMeta.getLore();
            list = list2;
            Intrinsics.checkNotNull((Object)list2);
        } else {
            list = new ArrayList();
        }
        List lore = list;
        List builtPaths = new ArrayList();
        NBTTagCompound nBTTagCompound = this$0.rootNBT;
        Intrinsics.checkNotNullExpressionValue((Object)nBTTagCompound, (String)"rootNBT");
        this$0.buildPathsFrom(builtPaths, nBTTagCompound, "");
        Iterable iterable = new StringPathBuilder(builtPaths).toStringTree(CommandAdminLanguagePack.Companion.getTREE_STYLE()).print().getLines();
        List list3 = lore;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void x;
            StringBuilder stringBuilder = (StringBuilder)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = x.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            collection.add(string);
        }
        list3.addAll((List)destination$iv$iv);
        innerMeta.setLore(lore);
        innerItem.setItemMeta(innerMeta);
        return innerItem;
    }

    private static final void openGUI$lambda$26(ItemMeta $meta, ItemEditor this$0) {
        $meta.setUnbreakable(!$meta.isUnbreakable());
        this$0.item.setItemMeta($meta);
        this$0.openGUI();
    }

    private static final void openGUI$lambda$27(InventoryInteractiveGUI $gui, ItemEditor this$0) {
        if ($gui.wasSwitched()) {
            return;
        }
        int[] nArray = $gui.option("item").constructGUIOptionObject().getSettings().getSlots();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSlots(...)");
        int slot = ArraysKt.first((int[])nArray);
        ItemStack itemInSlot = $gui.getInventory().getItem(slot);
        if (itemInSlot != null) {
            ItemStack[] itemStackArray = new ItemStack[]{itemInSlot};
            XItemStack.giveOrDrop((Player)this$0.player, (ItemStack[])itemStackArray);
        }
    }

    private static final void openEquipmentSlotSelector$lambda$28(Consumer $selected, EquipmentSlot $equipSlot) {
        $selected.accept($equipSlot);
    }

    private static final void openEquipmentSlotSelector$lambda$29(Consumer $selected) {
        $selected.accept(null);
    }

    private static final void openAttributeOperationsGUI$lambda$30(Consumer $selected, AttributeModifier.Operation $operation) {
        $selected.accept($operation);
    }

    private static final void openFlagsGUI$lambda$31(ItemMeta $meta, ItemFlag $flag, ItemEditor this$0) {
        if ($meta.hasItemFlag($flag)) {
            ItemFlag[] itemFlagArray = new ItemFlag[]{$flag};
            $meta.removeItemFlags(itemFlagArray);
        } else {
            ItemFlag[] itemFlagArray = new ItemFlag[]{$flag};
            $meta.addItemFlags(itemFlagArray);
        }
        this$0.item.setItemMeta($meta);
        this$0.openFlagsGUI();
    }

    private static final boolean openFlagsGUI$lambda$36$lambda$32(XItemFlag it) {
        return it.isSupported();
    }

    private static final boolean openFlagsGUI$lambda$36$lambda$33(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final ItemFlag openFlagsGUI$lambda$36$lambda$34(XItemFlag it) {
        return it.get();
    }

    private static final ItemFlag openFlagsGUI$lambda$36$lambda$35(Function1 $tmp0, Object p0) {
        return (ItemFlag)$tmp0.invoke(p0);
    }

    private static final void openFlagsGUI$lambda$36(ItemMeta $meta, ItemEditor this$0) {
        List list = XItemFlag.getValues().stream().filter(arg_0 -> ItemEditor.openFlagsGUI$lambda$36$lambda$33(ItemEditor::openFlagsGUI$lambda$36$lambda$32, arg_0)).map(arg_0 -> ItemEditor.openFlagsGUI$lambda$36$lambda$35(ItemEditor::openFlagsGUI$lambda$36$lambda$34, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ItemFlag[] itemFlagArray = thisCollection$iv.toArray(new ItemFlag[0]);
        $meta.removeItemFlags(Arrays.copyOf(itemFlagArray, itemFlagArray.length));
        this$0.item.setItemMeta($meta);
        this$0.openFlagsGUI();
    }

    private static final void openFlagsGUI$lambda$37(ItemEditor this$0) {
        this$0.openGUI();
    }

    private static final void openEnchantsGUI$lambda$38(OptionHandler ctx) {
        ctx.sendMessage((Messenger)KingdomsLang.ITEM_EDITOR_ENCHANT_ENTER, new Object[0]);
        ctx.startConversation();
    }

    private static final void openEnchantsGUI$lambda$39(ItemMeta $meta, Enchantment $enchant, ItemEditor this$0, OptionHandler ctx, String input) {
        Intrinsics.checkNotNull((Object)input);
        NumberConstraint[] numberConstraintArray = new NumberConstraint[]{NumberConstraint.INTEGER_ONLY, NumberConstraint.POSITIVE};
        AnyNumber anyNumber = ProcessToMessage.getNumberOrError(new NumberProcessor(input).withAllDecorators().withConstraints(numberConstraintArray), "enchant level", ctx);
        if (anyNumber == null) {
            return;
        }
        AnyNumber level = anyNumber;
        $meta.addEnchant($enchant, level.getValue().intValue(), true);
        this$0.item.setItemMeta($meta);
        ctx.endConversation();
        this$0.openEnchantsGUI();
    }

    private static final void openEnchantsGUI$lambda$40(ItemMeta $meta, Enchantment $enchant, ItemEditor this$0) {
        if ($meta.hasEnchant($enchant)) {
            $meta.removeEnchant($enchant);
            this$0.item.setItemMeta($meta);
            this$0.openEnchantsGUI();
        }
    }

    private static final void openEnchantsGUI$lambda$42(ItemMeta $meta, ItemEditor this$0) {
        Iterable $this$forEach$iv = $meta.getEnchants().keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Enchantment enchantment = (Enchantment)element$iv;
            boolean bl = false;
            $meta.removeEnchant(enchantment);
        }
        this$0.item.setItemMeta($meta);
        this$0.openEnchantsGUI();
    }

    private static final void openEnchantsGUI$lambda$43(ItemEditor this$0) {
        this$0.openGUI();
    }

    private static final void finalize$lambda$44(InteractiveGUI $gui, ItemEditor this$0) {
        if ($gui.wasSwitched()) {
            return;
        }
        ItemStack[] itemStackArray = new ItemStack[]{this$0.item};
        XItemStack.giveOrDrop((Player)this$0.player, (ItemStack[])itemStackArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0004\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0013\u001a\u00020\tJ\u0006\u0010\u0014\u001a\u00020\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lorg/kingdoms/commands/admin/item/ItemEditor$NBTEditor;", "", "nbt", "Lorg/kingdoms/nbt/tag/NBTTagCompound;", "path", "", "", "handler", "Ljava/util/function/Consumer;", "Lorg/kingdoms/gui/InteractiveGUI;", "<init>", "(Lorg/kingdoms/commands/admin/item/ItemEditor;Lorg/kingdoms/nbt/tag/NBTTagCompound;[Ljava/lang/String;Ljava/util/function/Consumer;)V", "getNbt", "()Lorg/kingdoms/nbt/tag/NBTTagCompound;", "getPath", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getHandler", "()Ljava/util/function/Consumer;", "openNBTAdder", "openNBTViewerGUI", "core"})
    @SourceDebugExtension(value={"SMAP\nCommandAdminItemEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandAdminItemEditor.kt\norg/kingdoms/commands/admin/item/ItemEditor$NBTEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,802:1\n1557#2:803\n1628#2,3:804\n1557#2:807\n1628#2,3:808\n*S KotlinDebug\n*F\n+ 1 CommandAdminItemEditor.kt\norg/kingdoms/commands/admin/item/ItemEditor$NBTEditor\n*L\n229#1:803\n229#1:804,3\n232#1:807\n232#1:808,3\n*E\n"})
    public final class NBTEditor {
        @NotNull
        private final NBTTagCompound nbt;
        @NotNull
        private final String[] path;
        @NotNull
        private final Consumer<InteractiveGUI> handler;

        public NBTEditor(@NotNull NBTTagCompound nbt, @NotNull String[] path, Consumer<InteractiveGUI> handler) {
            Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            this.nbt = nbt;
            this.path = path;
            this.handler = handler;
        }

        @NotNull
        public final NBTTagCompound getNbt() {
            return this.nbt;
        }

        @NotNull
        public final String[] getPath() {
            return this.path;
        }

        @NotNull
        public final Consumer<InteractiveGUI> getHandler() {
            return this.handler;
        }

        @NotNull
        public final InteractiveGUI openNBTAdder() {
            InteractiveGUI gui = GUIAccessor.prepare(ItemEditor.this.player, KingdomsGUI.ITEM$EDITOR_NBT$TYPES);
            for (OptionCategory option : gui.getOptions("nbt")) {
                AtomicReference newName = new AtomicReference();
                option.getOption().onNormalClicks(NBTEditor::openNBTAdder$lambda$0).setConversation((arg_0, arg_1) -> NBTEditor.openNBTAdder$lambda$3(option, newName, ItemEditor.this, this, arg_0, arg_1)).done();
            }
            InteractiveGUI.open$default(gui, false, false, 3, null);
            Intrinsics.checkNotNull((Object)gui);
            return gui;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final InteractiveGUI openNBTViewerGUI() {
            InteractiveGUI gui = GUIAccessor.prepare(ItemEditor.this.player, KingdomsGUI.ITEM$EDITOR_NBT);
            gui.getMessageContext().parse("path", "{$s}" + ArraysKt.joinToString$default((Object[])this.path, (CharSequence)" {$sep}\u27a1 {$s}", null, null, (int)0, null, null, (int)62, null));
            ReusableOptionHandler reusableOptionHandler = gui.getReusableOption("tag");
            Intrinsics.checkNotNull((Object)reusableOptionHandler);
            ReusableOptionHandler tag = reusableOptionHandler;
            Object object = this.nbt.value();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
            for (Map.Entry entry : object.entrySet()) {
                List list;
                Collection collection;
                String key = (String)entry.getKey();
                NBTTag value = (NBTTag)entry.getValue();
                tag.getMessageContext().raw("nbt", value.getClass().getSimpleName());
                tag.getMessageContext().raw("key", key);
                MessagePlaceholderProvider messagePlaceholderProvider = tag.getMessageContext();
                Intrinsics.checkNotNull((Object)value);
                messagePlaceholderProvider.raw("tag", ItemEditor.this.getTypeOfNBT(value));
                NBTTag nBTTag = value;
                if (nBTTag instanceof NBTTagCompound) {
                    void $this$mapTo$iv$iv;
                    ArrayList builtPaths = new ArrayList();
                    ItemEditor.this.buildPathsFrom(builtPaths, (NBTTagCompound)value, "");
                    Iterable $this$map$iv = new StringPathBuilder(builtPaths).toStringTree(CommandAdminLanguagePack.Companion.getTREE_STYLE()).print().getLines();
                    boolean $i$f$map2 = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (NBTTag item$iv$iv2 : $this$mapTo$iv$iv) {
                        void x;
                        StringBuilder stringBuilder = (StringBuilder)((Object)item$iv$iv2);
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(x.toString());
                    }
                    list = (List)destination$iv$iv;
                } else if (nBTTag instanceof NBTTagList) {
                    void $this$mapTo$iv$iv;
                    Object object2 = ((NBTTagList)value).value();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"value(...)");
                    Iterable $this$map$iv = (Iterable)object2;
                    boolean $i$f$map = false;
                    Iterable $i$f$map2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void x;
                        NBTTag item$iv$iv2;
                        item$iv$iv2 = (NBTTag)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(x.toString());
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = CollectionsKt.listOf((Object)value.value().toString());
                }
                List stringValue = list;
                tag.editItem(arg_0 -> NBTEditor.openNBTViewerGUI$lambda$6(stringValue, arg_0));
                tag.on(ClickType.RIGHT, arg_0 -> NBTEditor.openNBTViewerGUI$lambda$7(this, key, arg_0));
                OptionHandler optionHandler = value instanceof NBTTagCompound ? (OptionHandler)tag.on(ClickType.LEFT, () -> NBTEditor.openNBTViewerGUI$lambda$10(ItemEditor.this, value, this, key)) : ((ReusableOptionHandler)tag.on(ClickType.LEFT, NBTEditor::openNBTViewerGUI$lambda$11)).setConversation((arg_0, arg_1) -> NBTEditor.openNBTViewerGUI$lambda$12(this, key, ItemEditor.this, value, arg_0, arg_1));
                tag.done();
                if (tag.hasNext()) continue;
            }
            gui.option("add-nbt").onNormalClicks(arg_0 -> NBTEditor.openNBTViewerGUI$lambda$13(this, arg_0)).done();
            this.handler.accept(gui);
            Intrinsics.checkNotNull((Object)gui);
            return ItemEditor.this.finalize(gui);
        }

        private static final void openNBTAdder$lambda$0(OptionHandler ctx) {
            ctx.sendMessage((Messenger)KingdomsLang.ITEM_EDITOR_NBT_NAME_ENTER, new Object[0]);
            ctx.startConversation();
        }

        private static final void openNBTAdder$lambda$3$lambda$2$lambda$1(ItemEditor this$0, NBTEditor this$1) {
            this$0.new NBTEditor(this$1.nbt, this$1.path, this$1.handler).openNBTViewerGUI();
        }

        private static final void openNBTAdder$lambda$3$lambda$2(ItemEditor this$0, NBTEditor this$1, InteractiveGUI innerGUI) {
            Intrinsics.checkNotNullParameter((Object)innerGUI, (String)"innerGUI");
            innerGUI.push("back", () -> NBTEditor.openNBTAdder$lambda$3$lambda$2$lambda$1(this$0, this$1), new Object[0]);
        }

        private static final void openNBTAdder$lambda$3(OptionCategory $option, AtomicReference $newName, ItemEditor this$0, NBTEditor this$1, OptionHandler ctx, String input) {
            Object object;
            boolean isCompound = Intrinsics.areEqual((Object)$option.getName(), (Object)"NBTTagCompound");
            if ($newName.get() == null && !isCompound) {
                ctx.sendMessage((Messenger)KingdomsLang.ITEM_EDITOR_NBT_VALUE_ENTER, new Object[0]);
                $newName.set(input);
                object = Unit.INSTANCE;
            } else {
                String[] stringArray;
                if (isCompound) {
                    $newName.set(input);
                }
                try {
                    List list;
                    String string = $option.getName();
                    if (isCompound) {
                        list = CollectionsKt.emptyList();
                    } else {
                        Intrinsics.checkNotNull((Object)input);
                        stringArray = new String[]{" "};
                        list = StringsKt.split$default((CharSequence)input, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    }
                    stringArray = this$0.constructNBT(string, list);
                }
                catch (Throwable ex) {
                    ctx.getMessageContext().raw("error", ex.getMessage());
                    ctx.sendError(KingdomsLang.ITEM_EDITOR_NBT_VALUE_ERROR, new Object[0]);
                    return;
                }
                String[] newNBT = stringArray;
                this$1.nbt.set((String)$newName.get(), newNBT);
                ctx.endConversation();
                this$0.item = ItemNBT.setTag(this$0.item, this$0.rootNBT);
                object = newNBT instanceof NBTTagCompound ? this$0.new NBTEditor((NBTTagCompound)newNBT, (String[])ArraysKt.plus((Object[])this$1.path, $newName.get()), arg_0 -> NBTEditor.openNBTAdder$lambda$3$lambda$2(this$0, this$1, arg_0)).openNBTViewerGUI() : this$1.openNBTViewerGUI();
            }
        }

        private static final ItemStack openNBTViewerGUI$lambda$6(List $stringValue, ItemStack item) {
            ItemMeta meta = item.getItemMeta();
            List lore = Strings.splitByLength($stringValue, 40);
            if (lore.size() > 20) {
                List list = lore;
                Intrinsics.checkNotNull(list);
                lore = CollectionsKt.take((Iterable)list, (int)20);
                lore.add("...");
            }
            ItemMeta itemMeta = meta;
            if (itemMeta != null) {
                itemMeta.setLore(lore);
            }
            item.setItemMeta(meta);
            return item;
        }

        private static final void openNBTViewerGUI$lambda$7(NBTEditor this$0, String $key, OptionHandler optionHandler) {
            this$0.nbt.remove($key);
            this$0.openNBTViewerGUI();
        }

        private static final void openNBTViewerGUI$lambda$10$lambda$9$lambda$8(ItemEditor this$0, NBTEditor this$1) {
            this$0.new NBTEditor(this$1.nbt, this$1.path, this$1.handler).openNBTViewerGUI();
        }

        private static final void openNBTViewerGUI$lambda$10$lambda$9(ItemEditor this$0, NBTEditor this$1, InteractiveGUI innerGUI) {
            Intrinsics.checkNotNullParameter((Object)innerGUI, (String)"innerGUI");
            innerGUI.push("back", () -> NBTEditor.openNBTViewerGUI$lambda$10$lambda$9$lambda$8(this$0, this$1), new Object[0]);
        }

        private static final void openNBTViewerGUI$lambda$10(ItemEditor this$0, NBTTag $value, NBTEditor this$1, String $key) {
            this$0.new NBTEditor((NBTTagCompound)$value, (String[])ArraysKt.plus((Object[])this$1.path, (Object)$key), arg_0 -> NBTEditor.openNBTViewerGUI$lambda$10$lambda$9(this$0, this$1, arg_0)).openNBTViewerGUI();
        }

        private static final void openNBTViewerGUI$lambda$11(OptionHandler ctx) {
            ctx.sendMessage((Messenger)KingdomsLang.ITEM_EDITOR_NBT_VALUE_ENTER, new Object[0]);
        }

        private static final void openNBTViewerGUI$lambda$12(NBTEditor this$0, String $key, ItemEditor this$1, NBTTag $value, OptionHandler ctx, String input) {
            NBTTagCompound nBTTagCompound = this$0.nbt;
            String string = Reflection.getOrCreateKotlinClass($value.getClass()).getSimpleName();
            Intrinsics.checkNotNull((Object)string);
            Intrinsics.checkNotNull((Object)input);
            String[] stringArray = new String[]{" "};
            nBTTagCompound.set($key, this$1.constructNBT(string, StringsKt.split$default((CharSequence)input, (String[])stringArray, (boolean)false, (int)0, (int)6, null)));
            ctx.endConversation();
            this$0.openNBTViewerGUI();
        }

        private static final void openNBTViewerGUI$lambda$13(NBTEditor this$0, OptionHandler optionHandler) {
            this$0.openNBTAdder();
        }
    }
}

