/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.item;

import com.google.common.base.Function;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.admin.item.CommandAdminItem;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.item.KingdomItemCreateSettings;
import org.kingdoms.constants.land.structures.StructureRegistry;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.utils.internal.functional.Fn;
import org.kingdoms.utils.string.Strings;

public class CommandAdminItemStructure
extends KingdomsCommand {
    public CommandAdminItemStructure(KingdomsParentCommand parent) {
        super("structure", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        KingdomPlayer kp;
        Kingdom kingdom;
        Player target;
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        StructureStyle style = StructureRegistry.get().getStyles().get(context.arg(0).toLowerCase(Locale.ENGLISH));
        if (style == null) {
            String styles = Strings.join("&8, ", StructureRegistry.get().getStyles().keySet(), (Function<String, String>)((Function)s -> "&6" + s));
            context.sendError(KingdomsLang.COMMAND_ADMIN_ITEM_STRUCTURE_UNKNOWN_STYLE, "style", context.arg(0), "styles", styles);
            return CommandResult.FAILED;
        }
        if (!style.hasItem()) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_ITEM_STYLE_HAS_NO_ITEM, "style", context.arg(0));
            return CommandResult.FAILED;
        }
        int amount = 1;
        if (context.assertArgs(2)) {
            if (!context.isNumber(1)) {
                context.sendError(KingdomsLang.INVALID_NUMBER, "arg", context.arg(1));
                return CommandResult.FAILED;
            }
            amount = Integer.parseInt(context.arg(1));
            if (amount < 1) {
                context.sendError(KingdomsLang.INVALID_AMOUNT, "amount", amount);
                return CommandResult.FAILED;
            }
        }
        if (context.assertArgs(3)) {
            target = context.getPlayer(2);
            if (target == null) {
                return CommandResult.FAILED;
            }
        } else {
            if (!context.isPlayer()) {
                context.wrongUsage();
                return CommandResult.FAILED;
            }
            target = context.senderAsPlayer();
        }
        if ((kingdom = (kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)target)).getKingdom()) == null) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_ITEM_NEEDS_KINGDOM, new Object[0]);
            return CommandResult.FAILED;
        }
        ItemStack item = style.buildItem(new KingdomItemCreateSettings(kingdom, kp)).getItem();
        item.setAmount(amount);
        XItemStack.giveOrDrop((Player)target, (ItemStack[])new ItemStack[]{item});
        context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_ITEM_STRUCTURE_DONE, "amount", amount, "item", context.arg(0), "target", target.getName());
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            return CommandAdminItem.getValidStyles((Map)Fn.cast(StructureRegistry.get().getStyles()));
        }
        if (context.isAtArg(1)) {
            return CommandAdminItemStructure.tabComplete("&9[amount]");
        }
        if (context.isAtArg(2)) {
            return context.getPlayers(2);
        }
        return CommandAdminItemStructure.emptyTab();
    }
}

