/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.item;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.item.KingdomItem;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.resourcepoints.ResourcePointManager;

public class CommandAdminItemResourcePoints
extends KingdomsCommand {
    public CommandAdminItemResourcePoints(KingdomsParentCommand parent) {
        super("resourcepoints", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        Player target;
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        if (!KingdomsConfig.ResourcePoints.CUSTOM_ITEMS.getManager().getSectionKeys().contains(context.arg(0))) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_ITEM_RESOURCEPOINTS_UNKNOWN_ITEM, "item", context.arg(0));
            return CommandResult.FAILED;
        }
        int amount = 1;
        if (context.assertArgs(2)) {
            if (!context.isNumber(1)) {
                context.sendError(KingdomsLang.INVALID_NUMBER, "arg", context.arg(1));
                return CommandResult.FAILED;
            }
            amount = Integer.parseInt(context.arg(1));
            if (amount < 1) {
                context.sendError(KingdomsLang.COMMAND_ADMIN_ITEM_RESOURCEPOINTS_INVALID_AMOUNT, "amount", amount);
                return CommandResult.FAILED;
            }
        }
        if (context.assertArgs(3)) {
            target = context.getPlayer(2);
            if (target == null) {
                return CommandResult.FAILED;
            }
        } else {
            if (!context.isPlayer()) {
                context.sendError(KingdomsLang.COMMAND_ADMIN_ITEM_RESOURCEPOINTS_USAGE, new Object[0]);
                return CommandResult.FAILED;
            }
            target = context.senderAsPlayer();
        }
        Pair<KingdomItem, Double> item = ResourcePointManager.buildItem(context.arg(0));
        item.getKey().getItem().setAmount(amount);
        XItemStack.giveOrDrop((Player)target, (ItemStack[])new ItemStack[]{item.getKey().getItem()});
        context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_ITEM_RESOURCEPOINTS_DONE, "amount", amount, "item", context.arg(0), "rp", item.getValue(), "target", target.getName());
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            return new ArrayList<String>(KingdomsConfig.ResourcePoints.CUSTOM_ITEMS.getManager().getSectionKeys());
        }
        if (context.isAtArg(1)) {
            return CommandAdminItemResourcePoints.tabComplete("&9[amount]");
        }
        if (context.isAtArg(2)) {
            return context.getPlayers(2);
        }
        return CommandAdminItemResourcePoints.emptyTab();
    }
}

