/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.debugging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageCompilerSettings;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.builders.context.PlainMessageBuilderContextProvider;
import org.kingdoms.locale.placeholders.KingdomsPlaceholderTranslator;
import org.kingdoms.locale.placeholders.StandardKingdomsPlaceholder;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.utils.string.Strings;

public class CommandAdminTest
extends KingdomsCommand {
    public CommandAdminTest(KingdomsParentCommand parent) {
        super("test", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        BaseComponent[][] create;
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        MessageCompiler messageCompiler = new MessageCompiler(MessageHandler.replace(context.joinArgs(), "\\n", "\n").toCharArray(), new MessageCompilerSettings(true, false, true, true, true, null));
        MessageObject compileObject = messageCompiler.compileObject();
        MessagePlaceholderProvider raw = new MessagePlaceholderProvider().withContext(context.getMessageReceiver()).raw("test_int", ThreadLocalRandom.current().nextInt(1, 100)).raw("test_string", Strings.random(5, 20, "aldfoasdbnopu2910871054sdfjvnaoghwhserm;sdfo$)@#&*)%^&*!@)#")).raw("test", ThreadLocalRandom.current().nextInt(1, 100));
        context.getMessageReceiver().sendMessage(MessageCompiler.compile("&2Compiled&8: &f%built%").buildPlain(new MessagePlaceholderProvider().raw("built", messageCompiler)));
        PlainMessageBuilderContextProvider plainMessageBuilderContextProvider = new PlainMessageBuilderContextProvider(raw);
        compileObject.build(plainMessageBuilderContextProvider);
        context.getMessageReceiver().sendMessage(plainMessageBuilderContextProvider.merge());
        MessageHandler.sendPluginMessage(context.getMessageReceiver(), "&7---------------- Complex:");
        BaseComponent[][] array = create = compileObject.buildComplex(raw).create();
        int length = create.length;
        for (int i = 0; i < length; ++i) {
            context.getMessageReceiver().spigot().sendMessage(array[i]);
        }
        MessageHandler.sendPluginMessage(context.getMessageReceiver(), "&7---------------- JSON:");
        BaseComponent[][] array2 = create;
        int length2 = create.length;
        for (int j = 0; j < length2; ++j) {
            context.getMessageReceiver().sendMessage(ComponentSerializer.toString((BaseComponent[])array2[j]));
        }
        if (messageCompiler.hasErrors()) {
            MessageHandler.sendPluginMessage(context.getMessageReceiver(), "&8==================");
            MessageHandler.sendPluginMessage(context.getMessageReceiver(), "&4Error(s)&8:");
            context.getMessageReceiver().sendMessage(messageCompiler.joinExceptions());
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public @Nullable List<String> tabComplete(@NonNull CommandTabContext context) {
        if (context.args.length == 0) {
            return new ArrayList<String>();
        }
        String last = context.args[context.args.length - 1];
        if (last.isEmpty()) {
            return new ArrayList<String>();
        }
        if (last.equals("~")) {
            CharSequence[] testArgs = (String[])Arrays.stream(context.args).limit((long)context.args.length - 1L).toArray(String[]::new);
            return context.tabComplete(Arrays.asList(String.join((CharSequence)" ", testArgs)));
        }
        if ("%kingdoms_".startsWith(last)) {
            return KingdomsPlaceholderTranslator.names().keySet().stream().map(x -> x.toLowerCase(Locale.ENGLISH)).map(x -> "%kingdoms_" + x + '%').collect(Collectors.toList());
        }
        if (last.startsWith("%kingdoms_")) {
            return KingdomsPlaceholderTranslator.names().keySet().stream().map(x -> x.toLowerCase(Locale.ENGLISH)).filter(x -> x.startsWith(last.substring(10))).map(x -> "%kingdoms_" + x + '%').collect(Collectors.toList());
        }
        if (last.startsWith("{$")) {
            ArrayList<String> macros = new ArrayList<String>(StandardKingdomsPlaceholder.getGlobalMacros().keySet());
            macros.addAll(LanguageManager.localeOf(context.getMessageReceiver()).getMessages().keySet().stream().filter(k -> k.getPath()[0].equals("variables")).map(k -> k.getPath()[1]).collect(Collectors.toList()));
            return macros.stream().filter(x -> last.equals("{$") || x.toLowerCase(Locale.ENGLISH).contains(last.substring(2).toLowerCase(Locale.ENGLISH))).map(x -> "{$" + x + '}').collect(Collectors.toList());
        }
        if (last.startsWith("{%")) {
            return Collections.singletonList("{%colorBackReferencePlaceholder [& colorIndex]}");
        }
        if ("hover:{".startsWith(last)) {
            return Collections.singletonList("hover:{}");
        }
        if (last.startsWith("hover:{")) {
            return Arrays.asList("message", "hover", "action");
        }
        if ("&#".startsWith(last)) {
            return Collections.singletonList("&#<hex>");
        }
        return new ArrayList<String>();
    }
}

