/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.debugging;

import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.libs.xseries.base.XModule;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.utils.string.Strings;

public class CommandAdminSound
extends KingdomsCommand {
    public CommandAdminSound(KingdomsParentCommand parent) {
        super("sound", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        XSound.Record record;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        try {
            record = XSound.parse((String)String.join((CharSequence)",", context.args));
        }
        catch (Throwable ex) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_SOUND_ERROR, "error", ex.getMessage());
            return CommandResult.FAILED;
        }
        if (record == null) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_SOUND_ERROR, "error", "No Sound");
        }
        context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_SOUND_PLAYING, "sound", record.toString());
        record.soundPlayer().forPlayers(new Player[]{context.senderAsPlayer()}).play();
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            String category;
            boolean publicSound;
            String arg = context.arg(0);
            if (arg.startsWith("~")) {
                publicSound = true;
                arg = arg.substring(1);
            } else {
                publicSound = false;
            }
            int index = arg.indexOf(64);
            if (index != -1) {
                category = arg.substring(0, index);
                arg = arg.substring(index + 1);
            } else {
                category = null;
            }
            String sound = Strings.replace(arg.toUpperCase(Locale.ENGLISH), '-', '_').toString();
            String soundBuilder = (publicSound ? "~" : "") + (category != null ? category + '@' : "");
            Stream stream = Arrays.stream(XSound.values()).map(XModule::name);
            if (sound.isEmpty()) {
                return stream.map(x -> soundBuilder + x).collect(Collectors.toList());
            }
            stream = Streams.concat((Stream[])new Stream[]{stream, Arrays.stream(SoundCategory.values()).map(x -> x.name() + '@')});
            return stream.filter(x -> x.contains(sound)).map(x -> soundBuilder + x).collect(Collectors.toList());
        }
        if (context.isAtArg(1)) {
            return CommandAdminSound.tabComplete("&9[volume]");
        }
        if (context.isAtArg(2)) {
            return CommandAdminSound.tabComplete("&6[pitch]");
        }
        if (context.isAtArg(3)) {
            return CommandAdminSound.tabComplete("&5[seed]");
        }
        return CommandAdminSound.emptyTab();
    }
}

