/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.debugging;

import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.XEntityType;
import org.kingdoms.locale.KingdomsLang;

public class CommandAdminHologram
extends KingdomsCommand {
    public CommandAdminHologram(KingdomsParentCommand parent) {
        super("hologram", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        int removed = 0;
        Double radius = context.getDouble(0);
        if (radius == null) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        for (Entity entity2 : player.getNearbyEntities(radius.doubleValue(), radius.doubleValue(), radius.doubleValue())) {
            ArmorStand armorStand;
            if (entity2.getType() != EntityType.ARMOR_STAND && XEntityType.TEXT_DISPLAY.isSupported() && XEntityType.TEXT_DISPLAY.get() != entity2.getType() || entity2 instanceof ArmorStand && ((armorStand = (ArmorStand)entity2).isVisible() || !armorStand.isCustomNameVisible())) continue;
            entity2.remove();
            ++removed;
        }
        KingdomsLang.COMMAND_ADMIN_HOLOGRAM_REMOVED.sendMessage((CommandSender)player, "removed", removed);
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        if (context.isAtArg(0)) {
            return Collections.singletonList("<radius>");
        }
        return CommandAdminHologram.emptyTab();
    }
}

