/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.create;

import java.util.List;
import org.bukkit.OfflinePlayer;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.admin.create.CommandAdminCreate;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.utils.PlayerUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/commands/admin/create/CommandAdminCreateAny;", "Lorg/kingdoms/commands/KingdomsCommand;", "parent", "Lorg/kingdoms/commands/KingdomsParentCommand;", "<init>", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "tabComplete", "", "", "Lorg/kingdoms/commands/CommandTabContext;", "core"})
public final class CommandAdminCreateAny
extends KingdomsCommand {
    public CommandAdminCreateAny(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("any", parent);
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        OfflinePlayer king = PlayerUtils.getFirstPlayerThat(CommandAdminCreateAny::execute$lambda$0);
        if (king == null) {
            CommandResult commandResult = context.fail(KingdomsLang.COMMAND_ADMIN_CREATE_ANY_NO_PLAYER_FOUND);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        context.var("target", king.getName());
        if (CommandAdminCreate.Companion.create(context, king.getUniqueId()) == null) {
            return CommandResult.FAILED;
        }
        context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_CREATE_CREATED, new Object[0]);
        return CommandResult.SUCCESS;
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandTabContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isAtArg(0)) {
            String[] stringArray = new String[]{"<name>"};
            List<String> list = context.tabComplete(stringArray);
            Intrinsics.checkNotNullExpressionValue(list, (String)"tabComplete(...)");
            return list;
        }
        List<String> list = context.emptyTab();
        Intrinsics.checkNotNullExpressionValue(list, (String)"emptyTab(...)");
        return list;
    }

    private static final boolean execute$lambda$0(OfflinePlayer pl) {
        Intrinsics.checkNotNullParameter((Object)pl, (String)"pl");
        return !KingdomPlayer.getKingdomPlayer(pl.getUniqueId()).hasKingdom();
    }
}

