/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.backup;

import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.admin.backup.CommandAdminBackup;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.backup.KingdomsBackup;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/kingdoms/commands/admin/backup/CommandAdminBackupTake;", "Lorg/kingdoms/commands/KingdomsCommand;", "parent", "Lorg/kingdoms/commands/KingdomsParentCommand;", "<init>", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "core"})
public final class CommandAdminBackupTake
extends KingdomsCommand {
    public CommandAdminBackupTake(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("take", parent);
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        KingdomsBackup kingdomsBackup = context.plugin.getBackupManager();
        Intrinsics.checkNotNullExpressionValue((Object)kingdomsBackup, (String)"getBackupManager(...)");
        KingdomsBackup backupManager = kingdomsBackup;
        String backupName = context.arg(0);
        Kingdoms.taskScheduler().async().execute(() -> CommandAdminBackupTake.execute$lambda$0(backupManager, context, backupName));
        return CommandResult.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void execute$lambda$0(KingdomsBackup $backupManager, CommandContext $context, String $backupName) {
        Lock writeLock = $backupManager.getLock().writeLock();
        Intrinsics.checkNotNull((Object)writeLock);
        if (!CommandAdminBackup.Companion.waitForLock(writeLock)) {
            $context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_BACKUP_BUSY, new Object[0]);
            return;
        }
        try {
            $context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_BACKUP_TAKE_TAKING, new Object[0]);
            Intrinsics.checkNotNull((Object)$backupName);
            String finalBackupName = StringsKt.contains$default((CharSequence)$backupName, (char)'.', (boolean)false, (int)2, null) ? $backupName : $backupName + ".zip";
            Path backupPath = $backupManager.getBackupsFolder().resolve(finalBackupName);
            $backupManager.takeBackup(backupPath);
            $context.var("backup_path", backupPath);
            $context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_BACKUP_TAKE_SUCCESS, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            $context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_BACKUP_TAKE_ERROR, new Object[0]);
        }
        finally {
            writeLock.unlock();
        }
    }
}

