/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.backup;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.admin.backup.CommandAdminBackup;
import org.kingdoms.config.managers.ConfigManager;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.backup.KingdomsBackup;
import org.kingdoms.utils.fs.FSUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/commands/admin/backup/CommandAdminBackupRestore;", "Lorg/kingdoms/commands/KingdomsCommand;", "parent", "Lorg/kingdoms/commands/KingdomsParentCommand;", "<init>", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "tabComplete", "", "", "Lorg/kingdoms/commands/CommandTabContext;", "core"})
public final class CommandAdminBackupRestore
extends KingdomsCommand {
    public CommandAdminBackupRestore(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("restore", parent);
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        Path destination;
        Path path;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        KingdomsBackup kingdomsBackup = context.plugin.getBackupManager();
        Intrinsics.checkNotNullExpressionValue((Object)kingdomsBackup, (String)"getBackupManager(...)");
        KingdomsBackup backupManager = kingdomsBackup;
        String backupName = context.arg(0);
        if (!FSUtil.isValidPath(backupName)) {
            CommandResult commandResult = context.var("arg", backupName).fail(KingdomsLang.INVALID_PATH);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        Path restoreFile = backupManager.getBackupsFolder().resolve(backupName);
        if (!Files.exists(restoreFile, new LinkOption[0])) {
            context.var("backup_path", restoreFile.toAbsolutePath());
            CommandResult commandResult = context.fail(KingdomsLang.COMMAND_ADMIN_BACKUP_RESTORE_DOESNT_EXIST);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        if (context.assertArgs(2)) {
            String destinationPath = context.arg(1);
            if (!FSUtil.isValidPath(destinationPath)) {
                CommandResult commandResult = context.var("arg", destinationPath).fail(KingdomsLang.INVALID_PATH);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
                return commandResult;
            }
            path = Kingdoms.getPath(destinationPath).normalize();
        } else {
            path = destination = Kingdoms.getFolder();
        }
        if (destination.startsWith(Kingdoms.getFolder())) {
            context.requireYesNo(Duration.ofSeconds(30L), arg_0 -> CommandAdminBackupRestore.execute$lambda$0(restoreFile, arg_0));
            context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_BACKUP_RESTORE_WARNING, new Object[0]);
        }
        context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_BACKUP_RESTORE_RESTORING, new Object[0]);
        Kingdoms.taskScheduler().async().execute(() -> CommandAdminBackupRestore.execute$lambda$1(backupManager, context, restoreFile, destination));
        return CommandResult.SUCCESS;
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandTabContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isAtArg(0)) {
            List<String> list;
            Path backupFolder = context.plugin.getBackupManager().getBackupsFolder();
            List files = !Files.exists(backupFolder, new LinkOption[0]) ? CollectionsKt.emptyList() : Files.list(backupFolder).filter(arg_0 -> CommandAdminBackupRestore.tabComplete$lambda$3(CommandAdminBackupRestore::tabComplete$lambda$2, arg_0)).map(arg_0 -> CommandAdminBackupRestore.tabComplete$lambda$5(CommandAdminBackupRestore::tabComplete$lambda$4, arg_0)).collect(Collectors.toList());
            Intrinsics.checkNotNull((Object)files);
            if (!((Collection)files).isEmpty()) {
                List<String> list2 = context.tabComplete(files);
                list = list2;
                Intrinsics.checkNotNullExpressionValue(list2, (String)"tabComplete(...)");
            } else {
                String[] stringArray = new String[]{"No backups available"};
                List<String> list3 = context.tabComplete(stringArray);
                list = list3;
                Intrinsics.checkNotNullExpressionValue(list3, (String)"tabComplete(...)");
            }
            return list;
        }
        if (context.isAtArg(1)) {
            String[] stringArray = new String[]{"[destination]"};
            List<String> list = context.tabComplete(stringArray);
            Intrinsics.checkNotNullExpressionValue(list, (String)"tabComplete(...)");
            return list;
        }
        List<String> list = context.emptyTab();
        Intrinsics.checkNotNullExpressionValue(list, (String)"emptyTab(...)");
        return list;
    }

    private static final boolean execute$lambda$0(Path $restoreFile, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ConfigManager.getGlobals().set("restore-backup.from", (Object)((Object)$restoreFile.toAbsolutePath()).toString());
        ConfigManager.getGlobalsAdapter().saveConfig();
        Bukkit.shutdown();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void execute$lambda$1(KingdomsBackup $backupManager, CommandContext $context, Path $restoreFile, Path $destination) {
        Lock lock = $backupManager.getLock().writeLock();
        Intrinsics.checkNotNull((Object)lock);
        if (!CommandAdminBackup.Companion.waitForLock(lock)) {
            $context.fail(KingdomsLang.COMMAND_ADMIN_BACKUP_BUSY);
            return;
        }
        try {
            KingdomsCommand.plugin.getBackupManager().restore($restoreFile, $destination, true);
        }
        finally {
            lock.unlock();
        }
        $context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_BACKUP_RESTORE_RESTORED, new Object[0]);
    }

    private static final boolean tabComplete$lambda$2(Path x) {
        Intrinsics.checkNotNull((Object)x);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isRegularFile(x, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private static final boolean tabComplete$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String tabComplete$lambda$4(Path x) {
        return ((Object)x.getFileName()).toString();
    }

    private static final String tabComplete$lambda$5(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

