/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.TurretRegistry;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.land.turrets.TurretType;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.main.Kingdoms;

public class CommandAdminTurret
extends KingdomsCommand {
    public CommandAdminTurret(KingdomsParentCommand parent) {
        super("turret", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (!context.assertArgs(2) || !context.argIsAny(0, "change", "remove") || context.argIsAny(0, "change") && !context.assertArgs(3)) {
            context.wrongUsage();
            return CommandResult.FAILED;
        }
        TurretStyle turret = TurretRegistry.get().getStyles().get(context.arg(1));
        if (turret == null) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_TURRET_UNKNOWN_STYLE, "style", context.arg(1));
            return CommandResult.FAILED;
        }
        boolean change = context.argIsAny(0, "change");
        TurretStyle changeToTurret = null;
        if (change && (changeToTurret = TurretRegistry.get().getStyles().get(context.arg(2))) == null) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_TURRET_UNKNOWN_STYLE, "style", context.arg(2));
            return CommandResult.FAILED;
        }
        int amount = 0;
        for (Land land : Kingdoms.get().getDataCenter().getLandManager().peekAllData()) {
            for (Turret landTurret : land.getTurrets().values()) {
                if (!((TurretStyle)landTurret.getStyle()).getName().equals(turret.getName())) continue;
                SimpleLocation location = landTurret.getOrigin();
                location.getBlock().setType(Material.AIR);
                landTurret.remove();
                if (change) {
                    KingdomBuilding newTurret = ((TurretType)changeToTurret.getType()).build(new KingdomItemBuilder(changeToTurret, location));
                    newTurret.setLevel(1);
                    land.unsafeGetTurrets().put(location.toBlockVector(), (Turret)newTurret);
                }
                ++amount;
            }
        }
        context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_TURRET_SUCCESS, "amount", amount);
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        if (context.isAtArg(0)) {
            return CommandAdminTurret.tabComplete("change", "remove");
        }
        if (context.isAtArg(1)) {
            return CommandAdminTurret.tabComplete(TurretRegistry.get().getStyles().keySet());
        }
        if (context.isAtArg(2) && context.args[0].equals("change")) {
            return TurretRegistry.get().getStyles().keySet().stream().filter(x -> x.equals(context.args[1])).collect(Collectors.toList());
        }
        return CommandAdminTurret.emptyTab();
    }
}

