/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.time.Duration;
import java.util.List;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.utils.internal.functional.Fn;
import org.kingdoms.utils.internal.numbers.AnyNumber;
import org.kingdoms.utils.internal.numbers.NumberConstraint;
import org.kingdoms.utils.time.TimeFormatter;

public class CommandAdminShield
extends KingdomsCommand {
    public CommandAdminShield(KingdomsParentCommand parent) {
        super("shield", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        Kingdom kingdom = (Kingdom)context.generalSelector(false);
        AnyNumber finalValue = context.durationModifier("shield", kingdom.getShield().getTimeLeft());
        kingdom.getShield().setDuration(Duration.ofMillis(finalValue.getValue().longValue()));
        context.var("kingdom", kingdom.getName());
        context.var("amount", TimeFormatter.of(kingdom.getShield().getTimeLeft()));
        context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_SHIELD_SUCCESS, new Object[0]);
        return CommandResult.SUCCESS;
    }

    @Override
    public @Nullable List<String> tabComplete(@NonNull CommandTabContext context) {
        return context.tabCompleteGeneralSelector(false, true, Fn.alwaysTrue()).then(() -> context.tabCompleteNumberModifier("shield", new NumberConstraint[0])).build();
    }
}

