/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.utils.internal.functional.Fn;
import org.kingdoms.utils.internal.numbers.AnyNumber;
import org.kingdoms.utils.internal.numbers.NumberConstraint;

public class CommandAdminResourcePoints
extends KingdomsCommand {
    public CommandAdminResourcePoints(KingdomsParentCommand parent) {
        super("resourcepoints", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        Kingdom kingdom = (Kingdom)context.generalSelector(false);
        AnyNumber finalValue = context.numberModifier("resource-points", kingdom.getResourcePoints().get(), new NumberConstraint[0]);
        kingdom.getResourcePoints().set(Math.max(0.0, finalValue.getValue().doubleValue()));
        context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_RESOURCEPOINTS_DONE, "kingdom", kingdom.getName(), "rp", kingdom.getResourcePoints().get());
        for (Player member : kingdom.getOnlineMembers()) {
            context.sendMessage((CommandSender)member, KingdomsLang.COMMAND_ADMIN_RESOURCEPOINTS_ADDED, "rp", kingdom.getResourcePoints().get());
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public @Nullable List<String> tabComplete(@NonNull CommandTabContext context) {
        return context.tabCompleteGeneralSelector(false, true, Fn.alwaysTrue()).then(() -> context.tabCompleteNumberModifier("resource-points", new NumberConstraint[0])).build();
    }
}

