/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.time.Duration;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.managers.ConfigManager;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.fs.FSUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/kingdoms/commands/admin/CommandAdminResetConfigs;", "Lorg/kingdoms/commands/KingdomsCommand;", "Lorg/bukkit/event/Listener;", "parent", "Lorg/kingdoms/commands/KingdomsParentCommand;", "<init>", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "onPlayerJoin", "", "event", "Lorg/bukkit/event/player/AsyncPlayerPreLoginEvent;", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "Companion", "core"})
public final class CommandAdminResetConfigs
extends KingdomsCommand
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static long ACCEPT_COOLDOWN;
    private static boolean RESETTING;
    private static boolean DONE;

    public CommandAdminResetConfigs(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("resetConfigs", parent);
    }

    @EventHandler(priority=EventPriority.LOW)
    public final void onPlayerJoin(@NotNull AsyncPlayerPreLoginEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!RESETTING) {
            return;
        }
        event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_WHITELIST, ChatColor.RED + " Server is currently whitelisted by kingdoms");
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getMessageReceiver() instanceof Player) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_RESETCONFIGS_CONSOLE_ONLY, new Object[0]);
            return CommandResult.FAILED;
        }
        if (RESETTING) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_RESETCONFIGS_ALREADY, new Object[0]);
            return CommandResult.FAILED;
        }
        if (ACCEPT_COOLDOWN == 0L || Duration.ofSeconds(5L).minus(Duration.ofMillis(System.currentTimeMillis() - ACCEPT_COOLDOWN)).isNegative()) {
            ACCEPT_COOLDOWN = System.currentTimeMillis();
            context.sendError(KingdomsLang.COMMAND_ADMIN_RESETCONFIGS_CONFIRM, new Object[0]);
            return CommandResult.PARTIAL;
        }
        ConfigManager.getGlobals().set("reset-configs-on-next-start", (Object)true);
        ConfigManager.getGlobalsAdapter().saveConfig();
        context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_RESETCONFIGS_REQUESTED, new Object[0]);
        Bukkit.getScheduler().runTaskLater((Plugin)KingdomsCommand.plugin, CommandAdminResetConfigs::execute$lambda$0, 200L);
        return CommandResult.SUCCESS;
    }

    private static final void execute$lambda$0() {
        KLogger.info("Shutting down...");
        Bukkit.shutdown();
    }

    @JvmStatic
    public static final void resetConfigs() {
        Companion.resetConfigs();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/kingdoms/commands/admin/CommandAdminResetConfigs$Companion;", "", "<init>", "()V", "ACCEPT_COOLDOWN", "", "RESETTING", "", "DONE", "resetConfigs", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void resetConfigs() {
            RESETTING = true;
            KLogger.info("----------------------------------------------------------------");
            KLogger.info("Resetting configs...");
            ConfigManager.getGlobals().set("reset-configs-on-next-start", null);
            ConfigManager.getGlobalsAdapter().saveConfig();
            KLogger.info("Deleting GUIs...");
            FSUtil.deleteFolder(Kingdoms.getPath("guis"));
            KLogger.info("Deleting languages...");
            FSUtil.deleteFolder(Kingdoms.getPath("languages"));
            KLogger.info("Deleting the repository...");
            FSUtil.deleteFolder(Kingdoms.getPath("repository"));
            KLogger.info("Deleting structure configs...");
            FSUtil.deleteFolder(Kingdoms.getPath("Structures"));
            KLogger.info("Deleting turrets configs...");
            FSUtil.deleteFolder(Kingdoms.getPath("Turrets"));
            KLogger.info("Deleting the main config files...");
            FSUtil.deleteAllFileTypes(Kingdoms.getFolder(), ".yml");
            KLogger.info("Deleting maps folder...");
            FSUtil.deleteFolder(Kingdoms.getPath("maps"));
            DONE = true;
            Thread.sleep(10000L);
            KLogger.info("Config resets are done.");
            KLogger.info("----------------------------------------------------------------");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

