/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.utils.kingdoms.RelationUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/commands/admin/CommandAdminRelationship;", "Lorg/kingdoms/commands/KingdomsCommand;", "parent", "Lorg/kingdoms/commands/KingdomsParentCommand;", "<init>", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "tabComplete", "", "", "Lorg/kingdoms/commands/CommandTabContext;", "core"})
@SourceDebugExtension(value={"SMAP\nCommandAdminRelationship.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandAdminRelationship.kt\norg/kingdoms/commands/admin/CommandAdminRelationship\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,44:1\n11158#2:45\n11493#2,3:46\n*S KotlinDebug\n*F\n+ 1 CommandAdminRelationship.kt\norg/kingdoms/commands/admin/CommandAdminRelationship\n*L\n41#1:45\n41#1:46,3\n*E\n"})
public final class CommandAdminRelationship
extends KingdomsCommand {
    public CommandAdminRelationship(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("relationship", parent);
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.requireArgs(2)) {
            return CommandResult.FAILED;
        }
        Kingdom kingdom = context.getKingdom(0);
        if (kingdom == null) {
            return CommandResult.FAILED;
        }
        Kingdom firstKingdom = kingdom;
        Kingdom kingdom2 = context.getKingdom(1);
        if (kingdom2 == null) {
            return CommandResult.FAILED;
        }
        Kingdom secondKingdom = kingdom2;
        context.getMessageContext().withContext(firstKingdom).other(secondKingdom);
        if (!context.assertArgs(3)) {
            context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_RELATIONSHIP_INFO, new Object[0]);
            return CommandResult.SUCCESS;
        }
        context.var("relation", context.arg(2));
        KingdomRelation kingdomRelation = RelationUtil.getRelation(context.arg(2), LanguageManager.localeOf(context.getMessageReceiver()));
        if (kingdomRelation == null) {
            CommandResult commandResult = context.fail(KingdomsLang.COMMAND_ADMIN_RELATIONSHIP_UNKNOWN_RELATION);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        KingdomRelation relation = kingdomRelation;
        KingdomRelation kingdomRelation2 = firstKingdom.getRelationWith(secondKingdom);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)kingdomRelation2), (String)"getRelationWith(...)");
        KingdomRelation currentRelation = kingdomRelation2;
        context.var("old-relation-color", currentRelation.getColor());
        context.var("old-relation-name", currentRelation.getName());
        if (currentRelation == relation) {
            CommandResult commandResult = context.fail(KingdomsLang.COMMAND_ADMIN_RELATIONSHIP_ALREADY_SET);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        firstKingdom.setRelationShipWith(secondKingdom, relation);
        context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_RELATIONSHIP_SET, new Object[0]);
        return CommandResult.SUCCESS;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandTabContext context) {
        List<String> list;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isAtArg(0)) {
            List<String> list2 = context.getKingdoms(0);
            list = list2;
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getKingdoms(...)");
        } else if (context.isAtArg(1)) {
            List<String> list3 = context.getKingdoms(1);
            list = list3;
            Intrinsics.checkNotNullExpressionValue(list3, (String)"getKingdoms(...)");
        } else if (context.isAtArg(2)) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            KingdomRelation[] kingdomRelationArray = KingdomRelation.values();
            int n = 2;
            CommandTabContext commandTabContext = context;
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n2 = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n2; ++i) {
                void x;
                void item$iv$iv;
                void var10_12 = item$iv$iv = $this$mapTo$iv$iv[i];
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(x.name());
            }
            collection = (List)destination$iv$iv;
            List<String> list4 = commandTabContext.suggest(n, collection);
            list = list4;
            Intrinsics.checkNotNullExpressionValue(list4, (String)"suggest(...)");
        } else {
            List<String> list5 = context.emptyTab();
            list = list5;
            Intrinsics.checkNotNullExpressionValue(list5, (String)"emptyTab(...)");
        }
        return list;
    }
}

