/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.List;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;

public class CommandAdminPermanent
extends KingdomsCommand {
    public CommandAdminPermanent(KingdomsParentCommand parent) {
        super("permanent", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        Kingdom kingdom = context.getKingdom(0);
        if (kingdom == null) {
            return CommandResult.FAILED;
        }
        kingdom.setPermanent(!kingdom.isPermanent());
        if (kingdom.isPermanent()) {
            context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_PERMANENT_ON, "kingdom", kingdom.getName());
        } else {
            context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_PERMANENT_OFF, "kingdom", kingdom.getName());
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            return context.getKingdoms(0);
        }
        return CommandAdminPermanent.emptyTab();
    }
}

