/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.admin.CommandAdminOpenFile;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.collections.MapsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.TempKingdomsFolder;
import org.kingdoms.utils.string.tree.StringPathBuilder;
import org.kingdoms.utils.string.tree.StringTree;
import org.kingdoms.utils.string.tree.TreeStyle;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/kingdoms/commands/admin/CommandAdminMissingGUIs;", "Lorg/kingdoms/commands/KingdomsCommand;", "parent", "Lorg/kingdoms/commands/KingdomsParentCommand;", "<init>", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "core"})
@SourceDebugExtension(value={"SMAP\nCommandAdminMissingGUIs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandAdminMissingGUIs.kt\norg/kingdoms/commands/admin/CommandAdminMissingGUIs\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1557#2:59\n1628#2,3:60\n*S KotlinDebug\n*F\n+ 1 CommandAdminMissingGUIs.kt\norg/kingdoms/commands/admin/CommandAdminMissingGUIs\n*L\n51#1:59\n51#1:60,3\n*E\n"})
public final class CommandAdminMissingGUIs
extends KingdomsCommand {
    public CommandAdminMissingGUIs(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("missingGUIs", parent);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Path output = TempKingdomsFolder.getOrCreateFolder("GUIS").resolve("Missing GUIs.txt");
        context.var("output", output);
        Intrinsics.checkNotNull((Object)output);
        context.var("sanitized_output", CommandAdminOpenFile.Companion.sanitize(output));
        ArrayList<String> files = new ArrayList<String>();
        List<SupportedLanguage> installed = SupportedLanguage.getInstalled();
        if (installed.isEmpty()) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_MISSINGGUIS_NO_LANGUAGE_PACKS_INSTALLED, new Object[0]);
            return CommandResult.FAILED;
        }
        for (SupportedLanguage supportedLanguage : installed) {
            if (supportedLanguage == Language.Companion.getDefault()) continue;
            for (String gui : Language.Companion.getDefault().getGUIs().keySet()) {
                boolean exists = supportedLanguage.getGUI(gui) != null;
                if (exists) continue;
                StringBuilder stringBuilder = new StringBuilder();
                String string = supportedLanguage.name();
                Locale locale = Locale.ENGLISH;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                String string2 = string.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                files.add(stringBuilder.append(string2).append(" (").append(supportedLanguage.getNativeName()).append(")/").append(gui).toString());
            }
        }
        if (files.isEmpty()) {
            CommandResult commandResult = context.fail(KingdomsLang.COMMAND_ADMIN_MISSINGGUIS_NO_MISSING_GUIS);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        TreeStyle treeStyle = new TreeStyle(StringTree.Companion.getUTF_CHARACTER_SET(), MapsKt.emptyMap());
        Object $this$execute_u24lambda_u240 = treeStyle;
        boolean bl = false;
        ((TreeStyle)$this$execute_u24lambda_u240).setFlatten(true);
        ((TreeStyle)$this$execute_u24lambda_u240).setIndentation(2);
        TreeStyle style = treeStyle;
        StringTree stringTree = new StringPathBuilder((List<String>)files).toStringTree(style).print();
        $this$execute_u24lambda_u240 = stringTree.getLines();
        Path path = output;
        boolean $i$f$map = false;
        void exists = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void x;
            StringBuilder stringBuilder = (StringBuilder)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(x.toString());
        }
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
        Files.write(path, (Iterable<? extends CharSequence>)((List)destination$iv$iv), openOptionArray);
        context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_MISSINGGUIS_DONE, new Object[0]);
        return CommandResult.SUCCESS;
    }
}

