/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.List;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.utils.internal.functional.Fn;
import org.kingdoms.utils.internal.numbers.AnyNumber;
import org.kingdoms.utils.internal.numbers.NumberConstraint;

public class CommandAdminMaxLandModifier
extends KingdomsCommand {
    public CommandAdminMaxLandModifier(KingdomsParentCommand parent) {
        super("maxLandModifier", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.requireArgs(2)) {
            return CommandResult.FAILED;
        }
        Kingdom kingdom = context.getKingdom(0);
        if (kingdom == null) {
            return CommandResult.FAILED;
        }
        AnyNumber result = context.numberModifier("lands", kingdom.getMaxLandsModifier(), new NumberConstraint[0]);
        kingdom.setMaxLandsModifier((Integer)result.getValue());
        context.var("kingdom", kingdom.getName()).var("amount", kingdom.getMaxLandsModifier());
        context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_MAXLANDMODIFIER_SUCCESS, new Object[0]);
        return CommandResult.SUCCESS;
    }

    @Override
    public @Nullable @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        return context.tabCompleteGeneralSelector(false, true, Fn.alwaysTrue()).then(() -> context.tabCompleteNumberModifier("resource-points", new NumberConstraint[0])).build();
    }
}

