/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.generator.WorldInfo;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.LocationLocale;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.PaperUtils;
import org.kingdoms.utils.internal.numbers.Numbers;

public class CommandAdminLand
extends KingdomsCommand {
    public CommandAdminLand(KingdomsParentCommand parent) {
        super("land", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        int z;
        int x;
        World world;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(2)) {
            return CommandResult.FAILED;
        }
        String[] args = context.args;
        CommandSender sender = context.getMessageReceiver();
        Player player = context.senderAsPlayer();
        int coordIndex = 0;
        if (args.length > 2) {
            world = Bukkit.getWorld((String)args[0]);
            if (world == null) {
                KingdomsLang.COMMAND_ADMIN_LAND_INVALID_WORLD.sendMessage((CommandSender)player, "world", args[0]);
                return CommandResult.FAILED;
            }
            coordIndex = 1;
        } else {
            world = player.getWorld();
        }
        try {
            x = Integer.parseInt(args[coordIndex]);
            z = Integer.parseInt(args[coordIndex + 1]);
        }
        catch (NumberFormatException ex) {
            KingdomsLang.COMMAND_ADMIN_LAND_INVALID_COORDINATES.sendMessage((CommandSender)player, "world", world.getName(), "x", args[coordIndex], "z", args[coordIndex + 1]);
            return CommandResult.FAILED;
        }
        context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_LAND_PREPARING, new Object[0]);
        SimpleChunkLocation chunk = new SimpleChunkLocation(world.getName(), x, z);
        PaperUtils.prepareChunks(chunk).thenRun(() -> {
            Location playerDir = player.getLocation();
            Location location = chunk.getCenterLocation();
            location.setYaw(playerDir.getYaw());
            location.setPitch(playerDir.getPitch());
            Kingdoms.taskScheduler().sync().execute(() -> player.teleport(location));
            LocationLocale.of(location).withBuilder(context.getMessageContext()).build();
            LocationLocale.of(chunk).withBuilder(context.getMessageContext()).withPrefix("chunk_").build();
            context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_LAND_TELEPORTED, new Object[0]);
        });
        return CommandResult.SUCCESS;
    }

    @Override
    public @Nullable @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        if (context.isAtArg(0)) {
            if (context.isNumber(0)) {
                return Collections.singletonList("<x>");
            }
            List<String> worlds2 = Bukkit.getWorlds().stream().map(WorldInfo::getName).filter(w -> w.startsWith(context.arg(0))).collect(Collectors.toList());
            worlds2.add(MessageHandler.colorize("&5<x>"));
            return worlds2;
        }
        if (context.isAtArg(1)) {
            if (context.isNumber(1)) {
                return Collections.singletonList(MessageHandler.colorize("&5<z>"));
            }
            return Collections.singletonList(MessageHandler.colorize("&5<x>"));
        }
        if (context.isAtArg(2) && !Numbers.isNumeric(context.arg(0))) {
            return Collections.singletonList(MessageHandler.colorize("&5<z>"));
        }
        return new ArrayList<String>();
    }
}

