/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.collections.SetsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.invasions.Invasion;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/commands/admin/CommandAdminInvasionEnd;", "Lorg/kingdoms/commands/KingdomsCommand;", "parent", "Lorg/kingdoms/commands/KingdomsParentCommand;", "<init>", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "tabComplete", "", "", "Lorg/kingdoms/commands/CommandTabContext;", "core"})
public final class CommandAdminInvasionEnd
extends KingdomsCommand {
    public CommandAdminInvasionEnd(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("invasionEnd", parent);
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        Kingdom kingdom;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        Kingdom kingdom2 = context.getKingdom(0);
        if (kingdom2 == null) {
            return CommandResult.FAILED;
        }
        Kingdom kingdom3 = kingdom2;
        Kingdom otherKingdom = null;
        context.getMessageContext().withContext(kingdom3);
        if (context.assertArgs(2)) {
            kingdom = context.getKingdom(1);
            if (kingdom == null) {
                return CommandResult.FAILED;
            }
        } else {
            if (kingdom3.getInvasions().size() > 1) {
                CommandResult commandResult = context.fail(KingdomsLang.NONE);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
                return commandResult;
            }
            Invasion first = (Invasion)CollectionsKt.first((Iterable)kingdom3.getInvasions().values());
            otherKingdom = Intrinsics.areEqual((Object)first.getAttacker(), (Object)kingdom3) ? first.getDefender() : first.getAttacker();
            context.getMessageContext().other(otherKingdom);
            context.sendMessage((Messenger)KingdomsLang.NONE, new Object[0]);
            return CommandResult.PARTIAL;
        }
        otherKingdom = kingdom;
        context.getMessageContext().other(otherKingdom);
        if (Intrinsics.areEqual((Object)kingdom3, (Object)otherKingdom)) {
            CommandResult commandResult = context.fail(KingdomsLang.NONE);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        if (kingdom3.getInvasions().isEmpty()) {
            CommandResult commandResult = context.fail(KingdomsLang.NONE);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        if (otherKingdom.getInvasions().isEmpty()) {
            CommandResult commandResult = context.fail(KingdomsLang.NONE);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        List invasionsBetweenTwo = new ArrayList();
        Map<KingdomPlayer, Invasion> map = kingdom3.getInvasions();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getInvasions(...)");
        Iterator<Map.Entry<KingdomPlayer, Invasion>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Invasion invasion = iterator.next().getValue();
            Kingdom defender = invasion.getDefender();
            Kingdom attacker = invasion.getAttacker();
            Object[] objectArray = new UUID[]{defender.getId(), attacker.getId()};
            HashSet set = SetsKt.hashSetOf((Object[])objectArray);
            if (!set.contains(attacker.getId()) || !set.contains(defender.getId())) continue;
            Intrinsics.checkNotNull((Object)invasion);
            invasionsBetweenTwo.add(invasion);
        }
        if (invasionsBetweenTwo.isEmpty()) {
            CommandResult commandResult = context.fail(KingdomsLang.NONE);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        if (invasionsBetweenTwo.size() > 1) {
            CommandResult commandResult = context.fail(KingdomsLang.NONE);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        for (Invasion invasion : invasionsBetweenTwo) {
            invasion.end(Invasion.Result.SUCCESS);
        }
        context.sendMessage((Messenger)KingdomsLang.NONE, new Object[0]);
        return CommandResult.SUCCESS;
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandTabContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isAtArg(0)) {
            context.getKingdoms(0);
        } else if (context.isAtArg(1)) {
            context.getKingdoms(1);
        }
        List<String> list = KingdomsCommand.emptyTab();
        Intrinsics.checkNotNullExpressionValue(list, (String)"emptyTab(...)");
        return list;
    }
}

