/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.general.GroupDisband;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;

public class CommandAdminDisband
extends KingdomsCommand {
    public CommandAdminDisband(KingdomsParentCommand parent) {
        super("disband", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        Kingdom kingdom;
        if (!context.assertArgs(1)) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_DISBAND_USAGE, new Object[0]);
            return CommandResult.FAILED;
        }
        boolean silent = false;
        int silentArgIndex = 1;
        if (context.argEquals(0, KingdomsLang.COMMANDS_TAGS_PLAYERS)) {
            Player player = context.getPlayer(1);
            if (player == null) {
                return CommandResult.FAILED;
            }
            kingdom = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player).getKingdom();
            if (kingdom == null) {
                context.sendError(KingdomsLang.NO_KINGDOM_TARGET, new Object[0]);
                return CommandResult.FAILED;
            }
            ++silentArgIndex;
        } else {
            kingdom = context.getKingdom(0);
            if (kingdom == null) {
                return CommandResult.FAILED;
            }
        }
        int finalSilentArgIndex = silentArgIndex;
        kingdom.disband(GroupDisband.Reason.ADMIN, () -> {
            context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_DISBAND_SUCCESS, "kingdom", kingdom.getName());
            if (context.assertArgs(3) && context.arg(finalSilentArgIndex).equals("silent") && KingdomsConfig.DISBAND_ANNOUNCE.getBoolean()) {
                for (Player players : Bukkit.getOnlinePlayers()) {
                    KingdomsLang.COMMAND_ADMIN_DISBAND_ANNOUNCE.sendMessage((CommandSender)players, "player", context.getMessageReceiver().getName(), "kingdom", kingdom.getName());
                }
            }
        });
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            @NonNull List<String> list = context.getKingdoms(0);
            list.add(KingdomsLang.COMMANDS_TAGS_PLAYERS.parse(new Object[0]));
            return list;
        }
        if (context.isAtArg(1)) {
            if (context.argEquals(0, KingdomsLang.COMMANDS_TAGS_PLAYERS)) {
                return context.getPlayers(1);
            }
            return CommandAdminDisband.tabComplete("silent");
        }
        if (context.isAtArg(2) && context.argEquals(0, KingdomsLang.COMMANDS_TAGS_PLAYERS)) {
            return CommandAdminDisband.tabComplete("silent");
        }
        return CommandAdminDisband.emptyTab();
    }
}

