/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import org.bukkit.permissions.PermissionDefault;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsCommandHandler;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.TempKingdomsFolder;
import org.kingdoms.utils.string.Strings;

public class CommandAdminCommands
extends KingdomsCommand {
    public CommandAdminCommands(KingdomsParentCommand parent) {
        super("commands", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        boolean defaultsOnly = false;
        if (context.assertArgs(1) && context.arg(0).equalsIgnoreCase("defaults")) {
            defaultsOnly = true;
        }
        Path path = TempKingdomsFolder.getOrCreateFile("command-permissions.txt");
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            for (KingdomsCommand cmd : KingdomsCommandHandler.getCommands(Language.getDefault()).values()) {
                if (defaultsOnly && cmd.getPermission().getDefault() != PermissionDefault.TRUE) continue;
                writer.write(cmd.getName() + " (" + Strings.join(cmd.getAliases().get(Language.getDefault()).toArray(), ", ") + ") " + cmd.getPermission().getName());
                writer.newLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_COMMANDS_DONE, "output", path.toAbsolutePath());
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        return context.isAtArg(0) ? CommandAdminCommands.tabComplete("defaults") : CommandAdminCommands.emptyTab();
    }
}

