/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.List;
import org.bukkit.OfflinePlayer;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.KingdomsChatChannel;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.KingdomsBukkitExtensions;
import org.kingdoms.utils.internal.functional.Fn;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/commands/admin/CommandAdminChat;", "Lorg/kingdoms/commands/KingdomsCommand;", "parent", "Lorg/kingdoms/commands/KingdomsParentCommand;", "<init>", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "tabComplete", "", "", "Lorg/kingdoms/commands/CommandTabContext;", "core"})
@SourceDebugExtension(value={"SMAP\nCommandAdminChat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandAdminChat.kt\norg/kingdoms/commands/admin/CommandAdminChat\n+ 2 KingdomsBukkitExtensions.kt\norg/kingdoms/utils/KingdomsBukkitExtensions\n*L\n1#1,44:1\n33#2:45\n*S KotlinDebug\n*F\n+ 1 CommandAdminChat.kt\norg/kingdoms/commands/admin/CommandAdminChat\n*L\n26#1:45\n*E\n"})
public final class CommandAdminChat
extends KingdomsCommand {
    public CommandAdminChat(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("chat", parent);
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.requireArgs(2)) {
            return CommandResult.FAILED;
        }
        OfflinePlayer offlinePlayer = context.getOfflinePlayer(0);
        if (offlinePlayer == null) {
            return CommandResult.FAILED;
        }
        OfflinePlayer player = offlinePlayer;
        String chatChannelName = context.arg(1);
        context.getMessageContext().withContext(player);
        context.var("channel_name", chatChannelName);
        KingdomsChatChannel kingdomsChatChannel = KingdomsChatChannel.fromId(chatChannelName);
        if (kingdomsChatChannel == null) {
            CommandResult commandResult = context.fail(KingdomsLang.COMMAND_CHAT_UNKNOWN_CHANNEL);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        KingdomsChatChannel chan = kingdomsChatChannel;
        context.var("channel_name", chan.getName());
        context.var("channel_color", chan.getColor());
        KingdomsBukkitExtensions kingdomsBukkitExtensions = KingdomsBukkitExtensions.INSTANCE;
        OfflinePlayer $this$asKingdomPlayer$iv = player;
        boolean $i$f$asKingdomPlayer = false;
        KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer($this$asKingdomPlayer$iv);
        Intrinsics.checkNotNullExpressionValue((Object)kingdomPlayer, (String)"getKingdomPlayer(...)");
        KingdomPlayer kp = kingdomPlayer;
        if (Intrinsics.areEqual((Object)kp.getChatChannel(), (Object)chan)) {
            CommandResult commandResult = context.fail(KingdomsLang.COMMAND_CHAT_ALREADY_IN_CHANNEL);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        Kingdoms.taskScheduler().async().execute(() -> CommandAdminChat.execute$lambda$0(kp, chan, context));
        return CommandResult.SUCCESS;
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandTabContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isAtArg(0)) {
            List<String> list = context.getPlayers(0);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getPlayers(...)");
            return list;
        }
        if (context.isAtArg(1)) {
            List<String> list = context.getChannels(1, Fn.alwaysTrue());
            Intrinsics.checkNotNullExpressionValue(list, (String)"getChannels(...)");
            return list;
        }
        List<String> list = context.emptyTab();
        Intrinsics.checkNotNullExpressionValue(list, (String)"emptyTab(...)");
        return list;
    }

    private static final void execute$lambda$0(KingdomPlayer $kp, KingdomsChatChannel $chan, CommandContext $context) {
        if ($kp.setChatChannel($chan).isCancelled()) {
            return;
        }
        $context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_CHAT_SWITCHED, new Object[0]);
    }
}

