/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.plugin.Plugin;
import org.kingdoms.addons.Addon;
import org.kingdoms.addons.AddonRegistry;
import org.kingdoms.addons.AddonRepository;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.admin.CommandAdminAddonsInstall;
import org.kingdoms.commands.admin.CommandAdminAddonsUninstall;
import org.kingdoms.commands.admin.CommandAdminAddonsUpdate;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.OptionHandler;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Pair;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.enums.EnumEntries;
import org.kingdoms.libs.kotlin.enums.EnumEntriesKt;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.ContextualMessageSender;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.network.UpdateChecker;
import org.kingdoms.versioning.SemVer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000b2\u00020\u0001:\u0003\t\n\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lorg/kingdoms/commands/admin/CommandAdminAddons;", "Lorg/kingdoms/commands/KingdomsParentCommand;", "parent", "<init>", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "AddonStateProperties", "AddonState", "Companion", "core"})
public final class CommandAdminAddons
extends KingdomsParentCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static long lastCheck;
    @NotNull
    private static final Map<String, AddonState> addonStates;

    public CommandAdminAddons(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("addons", parent);
        new CommandAdminAddonsInstall(this);
        new CommandAdminAddonsUninstall(this);
        new CommandAdminAddonsUpdate(this);
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isPlayer()) {
            Player player = context.senderAsPlayer();
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)KingdomsParentCommand.plugin, () -> CommandAdminAddons.execute$lambda$0(context, player));
            return CommandResult.SUCCESS;
        }
        CommandResult commandResult = super.execute(context);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"execute(...)");
        return commandResult;
    }

    private static final void execute$lambda$0(CommandContext $context, Player $player) {
        Intrinsics.checkNotNull((Object)$player);
        Companion.openGUI($context, $player);
    }

    @JvmStatic
    public static final synchronized boolean checkForUpdates() {
        return Companion.checkForUpdates();
    }

    @JvmStatic
    public static final boolean isInstalled(@NotNull AddonRepository repo) {
        return Companion.isInstalled(repo);
    }

    @JvmStatic
    public static final void notifyAboutUpdates(@NotNull CommandSender sender) {
        Companion.notifyAboutUpdates(sender);
    }

    @JvmStatic
    @Nullable
    public static final AddonRepository getAddonParameter(@NotNull CommandContext context) {
        return Companion.getAddonParameter(context);
    }

    @JvmStatic
    @NotNull
    public static final List<String> tabCompleteAddons(@NotNull CommandTabContext context, @NotNull Predicate<AddonRepository> onlyIf) {
        return Companion.tabCompleteAddons(context, onlyIf);
    }

    @JvmStatic
    @NotNull
    public static final AddonStateProperties getAddonState$core(@NotNull AddonRepository addon, @NotNull PlaceholderContextBuilder context) {
        return Companion.getAddonState$core(addon, context);
    }

    @JvmStatic
    public static final void openGUI(@NotNull CommandContext context, @NotNull Player player) {
        Companion.openGUI(context, player);
    }

    @JvmStatic
    public static final boolean installOrUpdate$core(@NotNull AddonStateProperties props, @NotNull ContextualMessageSender ctx, @Nullable Runnable done) {
        return Companion.installOrUpdate$core(props, ctx, done);
    }

    @JvmStatic
    public static final void uninstall(@NotNull Addon addon, @NotNull ContextualMessageSender ctx) {
        Companion.uninstall(addon, ctx);
    }

    static {
        addonStates = new HashMap();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/kingdoms/commands/admin/CommandAdminAddons$AddonState;", "", "<init>", "(Ljava/lang/String;I)V", "PENDING_RESTART", "INSTALLING", "core"})
    public static final class AddonState
    extends Enum<AddonState> {
        public static final /* enum */ AddonState PENDING_RESTART = new AddonState();
        public static final /* enum */ AddonState INSTALLING = new AddonState();
        private static final /* synthetic */ AddonState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AddonState[] values() {
            return (AddonState[])$VALUES.clone();
        }

        public static AddonState valueOf(String value) {
            return Enum.valueOf(AddonState.class, value);
        }

        @NotNull
        public static EnumEntries<AddonState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = addonStateArray = new AddonState[]{AddonState.PENDING_RESTART, AddonState.INSTALLING};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lorg/kingdoms/commands/admin/CommandAdminAddons$AddonStateProperties;", "", "repo", "Lorg/kingdoms/addons/AddonRepository;", "installedAddon", "Lorg/kingdoms/addons/Addon;", "installedVer", "", "outdated", "", "outdatedCoreVersion", "state", "Lorg/kingdoms/commands/admin/CommandAdminAddons$AddonState;", "<init>", "(Lorg/kingdoms/addons/AddonRepository;Lorg/kingdoms/addons/Addon;Ljava/lang/String;ZZLorg/kingdoms/commands/admin/CommandAdminAddons$AddonState;)V", "getRepo", "()Lorg/kingdoms/addons/AddonRepository;", "getInstalledAddon", "()Lorg/kingdoms/addons/Addon;", "getInstalledVer", "()Ljava/lang/String;", "getOutdated", "()Z", "getOutdatedCoreVersion", "getState", "()Lorg/kingdoms/commands/admin/CommandAdminAddons$AddonState;", "core"})
    public static final class AddonStateProperties {
        @NotNull
        private final AddonRepository repo;
        @Nullable
        private final Addon installedAddon;
        @Nullable
        private final String installedVer;
        private final boolean outdated;
        private final boolean outdatedCoreVersion;
        @Nullable
        private final AddonState state;

        public AddonStateProperties(@NotNull AddonRepository repo, @Nullable Addon installedAddon, @Nullable String installedVer, boolean outdated, boolean outdatedCoreVersion, @Nullable AddonState state) {
            Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
            this.repo = repo;
            this.installedAddon = installedAddon;
            this.installedVer = installedVer;
            this.outdated = outdated;
            this.outdatedCoreVersion = outdatedCoreVersion;
            this.state = state;
        }

        @NotNull
        public final AddonRepository getRepo() {
            return this.repo;
        }

        @Nullable
        public final Addon getInstalledAddon() {
            return this.installedAddon;
        }

        @Nullable
        public final String getInstalledVer() {
            return this.installedVer;
        }

        public final boolean getOutdated() {
            return this.outdated;
        }

        public final boolean getOutdatedCoreVersion() {
            return this.outdatedCoreVersion;
        }

        @Nullable
        public final AddonState getState() {
            return this.state;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010\u0014\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001aH\u0007J\u001d\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u001eH\u0001\u00a2\u0006\u0002\b\u001fJ\u0018\u0010 \u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0007J'\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0001\u00a2\u0006\u0002\b)J\u0018\u0010*\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020+2\u0006\u0010%\u001a\u00020&H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/kingdoms/commands/admin/CommandAdminAddons$Companion;", "", "<init>", "()V", "lastCheck", "", "addonStates", "", "", "Lorg/kingdoms/commands/admin/CommandAdminAddons$AddonState;", "checkForUpdates", "", "isInstalled", "repo", "Lorg/kingdoms/addons/AddonRepository;", "notifyAboutUpdates", "", "sender", "Lorg/bukkit/command/CommandSender;", "getAddonParameter", "context", "Lorg/kingdoms/commands/CommandContext;", "tabCompleteAddons", "", "Lorg/kingdoms/commands/CommandTabContext;", "onlyIf", "Ljava/util/function/Predicate;", "getAddonState", "Lorg/kingdoms/commands/admin/CommandAdminAddons$AddonStateProperties;", "addon", "Lorg/kingdoms/locale/placeholders/context/PlaceholderContextBuilder;", "getAddonState$core", "openGUI", "player", "Lorg/bukkit/entity/Player;", "installOrUpdate", "props", "ctx", "Lorg/kingdoms/locale/ContextualMessageSender;", "done", "Ljava/lang/Runnable;", "installOrUpdate$core", "uninstall", "Lorg/kingdoms/addons/Addon;", "core"})
    @SourceDebugExtension(value={"SMAP\nCommandAdminAddons.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandAdminAddons.kt\norg/kingdoms/commands/admin/CommandAdminAddons$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,331:1\n774#2:332\n865#2,2:333\n1557#2:335\n1628#2,3:336\n*S KotlinDebug\n*F\n+ 1 CommandAdminAddons.kt\norg/kingdoms/commands/admin/CommandAdminAddons$Companion\n*L\n196#1:332\n196#1:333,2\n197#1:335\n197#1:336,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final synchronized boolean checkForUpdates() {
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastCheck < Duration.ofMinutes(5L).toMillis()) {
                return true;
            }
            for (AddonRepository addon : AddonRepository.Companion.getRepository().values()) {
                try {
                    addon.updateInfo();
                }
                catch (Throwable ex) {
                    KLogger.error("Failed to check for addon updates: " + addon.getName() + " -> " + ex.getMessage() + " (Internet connection problems?)");
                    if (KingdomsConfig.DEBUG.getBoolean()) {
                        ex.printStackTrace();
                    }
                    return false;
                }
            }
            lastCheck = currentTime;
            return true;
        }

        @JvmStatic
        public final boolean isInstalled(@NotNull AddonRepository repo) {
            Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
            return AddonRegistry.getAddon(repo.getPath()) != null;
        }

        @JvmStatic
        public final void notifyAboutUpdates(@NotNull CommandSender sender) {
            Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
            if (!this.checkForUpdates()) {
                KingdomsLang.COMMAND_ADMIN_ADDONS_INDEXING_FAILED.sendConsoleMessage(new Object[0]);
                return;
            }
            List outdated = new ArrayList();
            for (AddonRepository addon : AddonRepository.Companion.getRepository().values()) {
                String installedVer;
                Addon installedAddon;
                if (AddonRegistry.getAddon(addon.getPath()) == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)installedAddon.getDescription().getVersion(), (String)"getVersion(...)");
                if (!UpdateChecker.isHigher(installedVer, addon.getVersion())) continue;
                outdated.add(new Pair((Object)addon, (Object)installedAddon));
            }
            if (outdated.isEmpty()) {
                return;
            }
            boolean isPlayer = sender instanceof Player;
            String firstIndicator = isPlayer ? "\u25cf" : "|";
            String secondIndicator = isPlayer ? "\u279c" : "->";
            String list = CollectionsKt.joinToString$default((Iterable)outdated, (CharSequence)"\n", null, null, (int)0, null, arg_0 -> Companion.notifyAboutUpdates$lambda$0(firstIndicator, secondIndicator, arg_0), (int)30, null);
            MessagePlaceholderProvider messagePlaceholderProvider = new MessagePlaceholderProvider().parse("update", list);
            Intrinsics.checkNotNullExpressionValue((Object)messagePlaceholderProvider, (String)"parse(...)");
            KingdomsLang.COMMAND_ADMIN_ADDONS_NOTIFICATION.sendMessage(sender, messagePlaceholderProvider);
        }

        @JvmStatic
        @Nullable
        public final AddonRepository getAddonParameter(@NotNull CommandContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (!Companion.checkForUpdates()) {
                context.sendError(KingdomsLang.COMMAND_ADMIN_ADDONS_INDEXING_FAILED, new Object[0]);
                return null;
            }
            String addonName = context.nextString();
            context.var("addon_name", addonName);
            AddonRepository addon = AddonRepository.Companion.getRepository().get(addonName);
            if (addon == null) {
                context.fail(KingdomsLang.COMMAND_ADMIN_ADDONS_UNKNOWN_ADDON);
                return null;
            }
            context.var("addon_name", addon.getName());
            return addon;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<String> tabCompleteAddons(@NotNull CommandTabContext context, @NotNull Predicate<AddonRepository> onlyIf) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            AddonRepository x;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(onlyIf, (String)"onlyIf");
            Iterable iterable = AddonRepository.Companion.getRepository().values();
            boolean $i$f$filter = false;
            void var6_5 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                x = (AddonRepository)element$iv$iv;
                boolean bl = false;
                if (!onlyIf.test(x)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                x = (AddonRepository)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(x.getPath());
            }
            List suggest = (List)destination$iv$iv;
            List<String> list = context.complete(context.tabComplete(suggest)).build();
            Intrinsics.checkNotNullExpressionValue(list, (String)"build(...)");
            return list;
        }

        /*
         * Unable to fully structure code
         */
        @JvmStatic
        @NotNull
        public final AddonStateProperties getAddonState$core(@NotNull AddonRepository addon, @NotNull PlaceholderContextBuilder context) {
            Intrinsics.checkNotNullParameter((Object)addon, (String)"addon");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            installedAddon = AddonRegistry.getAddon(addon.getPath());
            v0 = installedAddon;
            installedVer = v0 != null && (v0 = v0.getDescription()) != null ? v0.getVersion() : null;
            v1 = Kingdoms.get().getDescription().getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getVersion(...)");
            currentCoreVersion = v1;
            v2 = installedVer != null && SemVer.Companion.of(installedVer).compareTo(SemVer.Companion.of(addon.getVersion())) < 0;
            if (addon.getSupportedCoreVersion() == null) ** GOTO lbl-1000
            v3 = addon.getSupportedCoreVersion();
            Intrinsics.checkNotNull((Object)v3);
            if (SemVer.Companion.of(v3).compareTo(SemVer.Companion.of(currentCoreVersion)) > 0) {
                v4 = true;
            } else lbl-1000:
            // 2 sources

            {
                v4 = false;
            }
            $this$getAddonState_u24lambda_u243 = var6_6 = new AddonStateProperties(addon, installedAddon, installedVer, v2, v4, (AddonState)CommandAdminAddons.access$getAddonStates$cp().get(addon.getName()));
            $i$a$-apply-CommandAdminAddons$Companion$getAddonState$1 = false;
            var9_9 = new Object[]{"addon-name", addon.getName(), "latest-version", addon.getVersion(), "supported-core-version", addon.getSupportedCoreVersion(), "installed", installedAddon != null, "installed-version", installedVer, "outdated", $this$getAddonState_u24lambda_u243.getOutdated(), "outdated_core_version", $this$getAddonState_u24lambda_u243.getOutdatedCoreVersion(), "waiting_to_restart", $this$getAddonState_u24lambda_u243.getState() == AddonState.PENDING_RESTART, "installing", $this$getAddonState_u24lambda_u243.getState() == AddonState.INSTALLING};
            context.raws(var9_9);
            context.parse("description", addon.getDescription());
            return var6_6;
        }

        @JvmStatic
        public final void openGUI(@NotNull CommandContext context, @NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_ADDONS_INDEXING, new Object[0]);
            InteractiveGUI gui = GUIAccessor.prepare(player, KingdomsGUI.ADDONS);
            if (!this.checkForUpdates()) {
                context.sendError(KingdomsLang.COMMAND_ADMIN_ADDONS_INDEXING_FAILED, new Object[0]);
                return;
            }
            ReusableOptionHandler reusableOptionHandler = gui.getReusableOption("addons");
            if (reusableOptionHandler == null) {
                throw new IllegalStateException("Addons option null for gui");
            }
            ReusableOptionHandler addons = reusableOptionHandler;
            String string = Kingdoms.get().getDescription().getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersion(...)");
            String currentCoreVersion = string;
            gui.getMessageContext().raw("current-core-version", currentCoreVersion);
            for (AddonRepository addon : AddonRepository.Companion.getRepository().values()) {
                MessagePlaceholderProvider messagePlaceholderProvider = addons.getMessageContext();
                Intrinsics.checkNotNullExpressionValue((Object)messagePlaceholderProvider, (String)"<get-messageContext>(...)");
                AddonStateProperties props = this.getAddonState$core(addon, messagePlaceholderProvider);
                ReusableOptionHandler opt = addons;
                if (props.getOutdated() && Files.exists(addon.getDownloadPath(), new LinkOption[0])) {
                    opt.getMessageContext().raw("addon-file", addon.getDownloadPath());
                    opt.sendError(KingdomsLang.COMMAND_ADMIN_ADDONS_MISMATCH, new Object[0]);
                    continue;
                }
                if (!Files.exists(addon.getDownloadPath(), new LinkOption[0]) && (props.getOutdated() || props.getInstalledAddon() == null)) {
                    opt.on(ClickType.LEFT, arg_0 -> Companion.openGUI$lambda$5(player, props, context, arg_0));
                }
                if (props.getInstalledAddon() != null) {
                    opt.on(ClickType.RIGHT, arg_0 -> Companion.openGUI$lambda$6(player, props, arg_0));
                }
                opt.done();
            }
            InteractiveGUI.open$default(gui, false, false, 3, null);
        }

        @JvmStatic
        public final boolean installOrUpdate$core(@NotNull AddonStateProperties props, @NotNull ContextualMessageSender ctx, @Nullable Runnable done) {
            Intrinsics.checkNotNullParameter((Object)props, (String)"props");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            if (props.getOutdatedCoreVersion() && Kingdoms.isStrict()) {
                ctx.sendError(KingdomsLang.COMMAND_ADMIN_ADDONS_OUTDATED_CORE_VERSION, new Object[0]);
                return true;
            }
            if (props.getState() == AddonState.PENDING_RESTART) {
                ctx.sendError(KingdomsLang.COMMAND_ADMIN_ADDONS_PENDING_RESTART, new Object[0]);
                return true;
            }
            if (props.getState() == AddonState.INSTALLING) {
                ctx.sendError(KingdomsLang.COMMAND_ADMIN_ADDONS_ALREADY_INSTALLING, new Object[0]);
                return true;
            }
            addonStates.put(props.getRepo().getName(), AddonState.INSTALLING);
            Runnable runnable = done;
            if (runnable != null) {
                runnable.run();
            }
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.get(), () -> Companion.installOrUpdate$lambda$8(ctx, props, done));
            return false;
        }

        @JvmStatic
        public final void uninstall(@NotNull Addon addon, @NotNull ContextualMessageSender ctx) {
            Intrinsics.checkNotNullParameter((Object)addon, (String)"addon");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            KLogger.info("Uninstalling addon " + addon.getName() + " v" + addon.getDescription().getVersion());
            ctx.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_ADDONS_UNINSTALLING, new Object[0]);
            AddonRegistry.uninstall(addon, false);
            ctx.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_ADDONS_UNINSTALLING_DONE, new Object[0]);
        }

        private static final CharSequence notifyAboutUpdates$lambda$0(String $firstIndicator, String $secondIndicator, Pair pair) {
            Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
            AddonRepository repo = (AddonRepository)pair.component1();
            Addon addon = (Addon)pair.component2();
            String string = Kingdoms.get().getDescription().getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersion(...)");
            String currentCoreVersion = string;
            boolean outdatedCoreVersion = repo.getSupportedCoreVersion() != null && UpdateChecker.isHigher(currentCoreVersion, repo.getSupportedCoreVersion());
            String coreVersionNotice = outdatedCoreVersion ? " {$sep}({$e}Required Kingdoms Version{$sep}: {$es}" + repo.getSupportedCoreVersion() + "{$sep})" : "";
            return "  {$sep}" + $firstIndicator + " {$p}" + addon.getName() + " {$s}v" + addon.getDescription().getVersion() + " {$sep}" + $secondIndicator + " {$s}v" + repo.getVersion() + coreVersionNotice;
        }

        private static final void openGUI$lambda$5$lambda$4(CommandContext $context, Player $player) {
            Companion.openGUI($context, $player);
        }

        private static final void openGUI$lambda$5(Player $player, AddonStateProperties $props, CommandContext $context, OptionHandler ctx) {
            $player.closeInventory();
            Intrinsics.checkNotNull((Object)ctx);
            if (Companion.installOrUpdate$core($props, ctx, () -> Companion.openGUI$lambda$5$lambda$4($context, $player))) {
                return;
            }
        }

        private static final void openGUI$lambda$6(Player $player, AddonStateProperties $props, OptionHandler ctx) {
            $player.closeInventory();
            Addon addon = $props.getInstalledAddon();
            Intrinsics.checkNotNull((Object)ctx);
            Companion.uninstall(addon, ctx);
        }

        private static final void installOrUpdate$lambda$8$lambda$7(AddonStateProperties $props, ContextualMessageSender $ctx, Runnable $done) {
            block2: {
                if ($props.getOutdated()) {
                    AddonRegistry.uninstall($props.getInstalledAddon(), true);
                    $ctx.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_ADDONS_FINISH_UPDATING, new Object[0]);
                } else {
                    $ctx.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_ADDONS_INSTALLED, new Object[0]);
                }
                addonStates.put($props.getRepo().getName(), AddonState.PENDING_RESTART);
                Runnable runnable = $done;
                if (runnable == null) break block2;
                runnable.run();
            }
        }

        private static final void installOrUpdate$lambda$8(ContextualMessageSender $ctx, AddonStateProperties $props, Runnable $done) {
            try {
                $ctx.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_ADDONS_DOWNLOADING, new Object[0]);
                $props.getRepo().download();
            }
            catch (Exception ex) {
                $ctx.getMessageContext().raw("message", ex.getMessage());
                $ctx.sendError(KingdomsLang.COMMAND_ADMIN_ADDONS_DOWNLOAD_FAILED, new Object[0]);
                addonStates.remove($props.getRepo().getName());
                ex.printStackTrace();
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> Companion.installOrUpdate$lambda$8$lambda$7($props, $ctx, $done));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

