/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandLoggingLevel;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandUserError;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.commands.admin.CommandAdmin;
import org.kingdoms.commands.general.admin.CommandAbout;
import org.kingdoms.commands.general.admin.CommandReload;
import org.kingdoms.commands.general.admin.CommandSession;
import org.kingdoms.commands.general.admin.CommandUpdates;
import org.kingdoms.commands.general.bank.CommandBank;
import org.kingdoms.commands.general.book.CommandBook;
import org.kingdoms.commands.general.building.CommandBuilding;
import org.kingdoms.commands.general.chat.CommandBroadcast;
import org.kingdoms.commands.general.chat.CommandChat;
import org.kingdoms.commands.general.chat.CommandMute;
import org.kingdoms.commands.general.chat.CommandUnmute;
import org.kingdoms.commands.general.claims.claiming.CommandClaim;
import org.kingdoms.commands.general.claims.history.CommandRedo;
import org.kingdoms.commands.general.claims.history.CommandUndo;
import org.kingdoms.commands.general.claims.unclaiming.CommandUnclaim;
import org.kingdoms.commands.general.election.CommandElection;
import org.kingdoms.commands.general.home.CommandHome;
import org.kingdoms.commands.general.home.CommandSetHome;
import org.kingdoms.commands.general.home.CommandUnsetHome;
import org.kingdoms.commands.general.invasions.CommandChallenge;
import org.kingdoms.commands.general.invasions.CommandInvade;
import org.kingdoms.commands.general.invasions.CommandPvP;
import org.kingdoms.commands.general.invasions.CommandRansack;
import org.kingdoms.commands.general.invasions.CommandShield;
import org.kingdoms.commands.general.invasions.CommandSurrender;
import org.kingdoms.commands.general.invitations.CommandAccept;
import org.kingdoms.commands.general.invitations.CommandDecline;
import org.kingdoms.commands.general.invitations.CommandInvite;
import org.kingdoms.commands.general.invitations.CommandInviteCodes;
import org.kingdoms.commands.general.invitations.CommandInvites;
import org.kingdoms.commands.general.invitations.CommandJoin;
import org.kingdoms.commands.general.invitations.CommandJoinRequests;
import org.kingdoms.commands.general.invitations.CommandRequestJoin;
import org.kingdoms.commands.general.mails.CommandMail;
import org.kingdoms.commands.general.map.CommandMap;
import org.kingdoms.commands.general.nexus.CommandNexus;
import org.kingdoms.commands.general.others.CommandColor;
import org.kingdoms.commands.general.others.CommandCreate;
import org.kingdoms.commands.general.others.CommandDisband;
import org.kingdoms.commands.general.others.CommandDonate;
import org.kingdoms.commands.general.others.CommandExtractor;
import org.kingdoms.commands.general.others.CommandFly;
import org.kingdoms.commands.general.others.CommandGUI;
import org.kingdoms.commands.general.others.CommandHelp;
import org.kingdoms.commands.general.others.CommandInventory;
import org.kingdoms.commands.general.others.CommandKick;
import org.kingdoms.commands.general.others.CommandLanguage;
import org.kingdoms.commands.general.others.CommandLeave;
import org.kingdoms.commands.general.others.CommandMerge;
import org.kingdoms.commands.general.others.CommandSell;
import org.kingdoms.commands.general.others.CommandShow;
import org.kingdoms.commands.general.others.CommandSneak;
import org.kingdoms.commands.general.others.CommandStatistics;
import org.kingdoms.commands.general.others.CommandTop;
import org.kingdoms.commands.general.others.CommandTradable;
import org.kingdoms.commands.general.others.CommandVault;
import org.kingdoms.commands.general.ranking.CommandDemote;
import org.kingdoms.commands.general.ranking.CommandKing;
import org.kingdoms.commands.general.ranking.CommandPromote;
import org.kingdoms.commands.general.relation.CommandAlly;
import org.kingdoms.commands.general.relation.CommandEnemy;
import org.kingdoms.commands.general.relation.CommandRejectRelation;
import org.kingdoms.commands.general.relation.CommandRelations;
import org.kingdoms.commands.general.relation.CommandRevoke;
import org.kingdoms.commands.general.relation.CommandTruce;
import org.kingdoms.commands.general.resourcepoints.CommandResourcePoints;
import org.kingdoms.commands.general.teleports.CommandTeleport;
import org.kingdoms.commands.general.teleports.CommandTpa;
import org.kingdoms.commands.general.teleports.CommandTpaAccept;
import org.kingdoms.commands.general.teleports.CommandTpaReject;
import org.kingdoms.commands.general.text.CommandLore;
import org.kingdoms.commands.general.text.CommandRename;
import org.kingdoms.commands.general.text.CommandTag;
import org.kingdoms.commands.general.visualizer.CommandVisualize;
import org.kingdoms.commands.nation.CommandNation;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.command.KingdomsPostCommandEvent;
import org.kingdoms.events.command.KingdomsPreCommandEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Unmodifiable;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.permissions.BukkitPermission;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.server.core.Server;
import org.kingdoms.utils.cooldown.Cooldown;
import org.kingdoms.utils.internal.ProxyBytecodeManipulator;
import org.kingdoms.utils.internal.enumeration.QuickEnumMap;
import org.kingdoms.utils.internal.functional.Fn;
import org.kingdoms.utils.time.TimeFormatter;

public final class KingdomsCommandHandler
implements CommandExecutor {
    protected static Map<Language, Map<String, KingdomsCommand>> COMMANDS;
    private static final Cooldown<UUID> COOLDOWN;
    private static CommandHelp HELP_COMMAND;
    private final Kingdoms plugin;

    public KingdomsCommandHandler(Kingdoms plugin) {
        this.plugin = plugin;
        PluginCommand command = ProxyBytecodeManipulator.registerCommand((Plugin)plugin, KingdomsConfig.COMMAND_NAME.getManager().getString(), KingdomsConfig.COMMAND_ALIASES.getManager().getStringList());
        command.setExecutor((CommandExecutor)this);
        command.setTabCompleter((TabCompleter)new TabCompleteManager(plugin));
        KingdomsCommandHandler.registerCommands();
    }

    private static void unregisterPermissions(Collection<KingdomsCommand> commands) {
        for (KingdomsCommand cmd : commands) {
            cmd.unregisterPermissions();
            if (!(cmd instanceof KingdomsParentCommand)) continue;
            KingdomsCommandHandler.unregisterPermissions(((KingdomsParentCommand)cmd).getChildren(Language.getDefault()));
        }
    }

    private static void initializeCommandsMap() {
        COMMANDS = (Map)Fn.cast(new QuickEnumMap((Enum[])SupportedLanguage.VALUES));
    }

    public static void reload() {
        KingdomsCommandHandler.unregisterPermissions(KingdomsCommandHandler.getCommands(Language.getDefault()).values());
        KingdomsCommandHandler.initializeCommandsMap();
        KingdomsCommandHandler.registerCommands();
    }

    public static void registerCommands() {
        HELP_COMMAND = new CommandHelp();
        new CommandAbout();
        new CommandUpdates();
        new CommandReload();
        new CommandSession();
        new CommandCreate();
        new CommandRename();
        new CommandTag();
        new CommandLore();
        new CommandDisband();
        new CommandExtractor();
        new CommandGUI();
        new CommandColor();
        new CommandBuilding();
        new CommandTpa();
        new CommandTpaAccept();
        new CommandTpaReject();
        new CommandShow();
        new CommandMap();
        new CommandStatistics();
        new CommandInvade();
        new CommandRansack();
        new CommandChallenge();
        new CommandTeleport();
        new CommandSurrender();
        new CommandLeave();
        new CommandKick();
        new CommandVault();
        new CommandPromote();
        new CommandDemote();
        new CommandKing();
        new CommandChat();
        new CommandMute();
        new CommandUnmute();
        new CommandBroadcast();
        new CommandMail();
        new CommandHome();
        new CommandSetHome();
        new CommandUnsetHome();
        new CommandNexus();
        new CommandDonate();
        new CommandPvP();
        new CommandLanguage();
        new CommandRelations();
        new CommandRevoke();
        new CommandAlly();
        new CommandEnemy();
        new CommandTruce();
        new CommandRejectRelation();
        new CommandResourcePoints();
        new CommandBank();
        new CommandTradable();
        new CommandSell();
        new CommandClaim();
        new CommandUnclaim();
        new CommandRedo();
        new CommandUndo();
        new CommandVisualize();
        new CommandInvite();
        new CommandInvites();
        new CommandInviteCodes();
        new CommandAccept();
        new CommandDecline();
        new CommandJoin();
        new CommandRequestJoin();
        new CommandJoinRequests();
        new CommandFly();
        new CommandSneak();
        new CommandTop();
        new CommandBook();
        new CommandShield();
        new CommandInventory();
        new CommandElection();
        new CommandMerge();
        new CommandNation();
        CommandAdmin.setInstance(new CommandAdmin());
        KingdomsCommandHandler.gatherPermissions();
    }

    private static void gatherPermissions() {
        ArrayList<Permission> permissions = new ArrayList<Permission>(50);
        for (KingdomsCommand value : KingdomsCommandHandler.getCommands(Language.getDefault()).values()) {
            permissions.add(value.getPermission());
        }
        for (KingdomsDefaultPluginPermission value : KingdomsDefaultPluginPermission.values()) {
            permissions.add(value.getSystematicObject(BukkitPermission.class).getSystematicObject());
        }
        ProxyBytecodeManipulator.injectPermissions(Kingdoms.get(), permissions);
    }

    public static @Unmodifiable @NotNull Map<Language, Map<String, KingdomsCommand>> getCommands() {
        return Collections.unmodifiableMap(COMMANDS);
    }

    public static Map<String, KingdomsCommand> getCommands(Language locale) {
        Map<String, KingdomsCommand> commands = COMMANDS.get(locale);
        if (commands == null) {
            commands = Objects.requireNonNull(COMMANDS.get(SupportedLanguage.EN), () -> "No commands exist for language: " + locale);
        }
        return commands;
    }

    public static CommandInformation getCommand(Language lang, String[] args) {
        KingdomsParentCommand last = null;
        int index = 0;
        for (String arg : args) {
            KingdomsCommand current;
            String lowerArg = arg.toLowerCase(lang.getLocale());
            if (last == null) {
                Map<String, KingdomsCommand> mainCmds = KingdomsCommandHandler.getCommands(lang);
                if (mainCmds == null) {
                    throw new IllegalStateException("Main command set is null for language: " + lang);
                }
                current = mainCmds.get(lowerArg);
            } else {
                Map<String, KingdomsCommand> subLangCmds = last.children.get(lang);
                KingdomsCommand kingdomsCommand = current = subLangCmds == null ? null : subLangCmds.get(lowerArg);
            }
            if (current == null) {
                return new CommandInformation(last, last == null ? index - 1 : index);
            }
            ++index;
            if (!(current instanceof KingdomsParentCommand)) {
                return new CommandInformation(current, index);
            }
            last = (KingdomsParentCommand)current;
        }
        return new CommandInformation(last, index);
    }

    @NotNull
    public static CommandContext parse(CommandSender sender, String[] args) {
        Kingdoms plugin = Kingdoms.get();
        if (args.length == 0) {
            return new CommandContext(plugin, HELP_COMMAND, sender, args);
        }
        String spaceText = KingdomsConfig.COMMAND_SPACE_TEXT.getString();
        args = (String[])Arrays.stream(args).map(x -> x.replace(spaceText, " ")).toArray(String[]::new);
        SupportedLanguage lang = (SupportedLanguage)LanguageManager.localeOf(sender);
        CommandInformation info = KingdomsCommandHandler.getCommand(lang, args);
        KingdomsCommand command = info.command;
        if (command == null) {
            return new CommandContext(plugin, null, sender, args);
        }
        String[] newArgs = info.getCommandArguments(args);
        return new CommandContext(plugin, command, sender, newArgs);
    }

    public static boolean handle(@NotNull CommandContext ctx) {
        CommandResult res;
        CommandSender sender = ctx.getMessageReceiver();
        KingdomsCommand command = ctx.getCommand();
        if (command == null) {
            KingdomsLang.COMMANDS_UNKNOWN_COMMAND.sendError(sender, "cmd", String.join((CharSequence)" ", ctx.args));
            return false;
        }
        if (sender instanceof Player) {
            long cooldown;
            Player player = (Player)sender;
            if (!ctx.hasPermission()) {
                KingdomsLang.COMMANDS_INSUFFICIENT_PERMISSION.sendError(sender, new Object[0]);
                return false;
            }
            if (command.getDisabledWorlds() != null && command.getDisabledWorlds().matches(player.getWorld().getName()) && !command.canBypassDisabledWorlds((CommandSender)player)) {
                KingdomsLang.COMMANDS_DISABLED_WORLD.sendError(sender, "cmd", command.getDisplayName(), "world", player.getWorld().getName());
                return false;
            }
            if (command.getCooldown() > 0L && (cooldown = COOLDOWN.getTimeLeft(player.getUniqueId())) > 0L && !command.canBypassCooldown((CommandSender)player)) {
                KingdomsLang.COMMANDS_COOLDOWN.sendError(sender, "cmd", command.getDisplayName(), "cooldown", TimeFormatter.of(cooldown));
                return false;
            }
        }
        KingdomsPreCommandEvent preEvent = new KingdomsPreCommandEvent(ctx);
        Server.get().getEventHandler().callEvent(preEvent);
        if (!preEvent.isCancelled()) {
            try {
                res = command.execute(ctx);
            }
            catch (CommandUserError ex) {
                if (ex.getError() == null) {
                    res = CommandResult.FAILED;
                } else {
                    try {
                        if (ctx.getLoggingLevel().atLeast(CommandLoggingLevel.ERRORS)) {
                            ctx.sendError(ex.getError(), new Object[0]);
                        }
                        res = CommandResult.FAILED;
                    }
                    catch (Throwable exFatal) {
                        exFatal.addSuppressed(ex);
                        exFatal.printStackTrace();
                        res = CommandResult.ERROR;
                    }
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                res = CommandResult.ERROR;
            }
            KingdomsPostCommandEvent postEvent = new KingdomsPostCommandEvent(ctx);
            Server.get().getEventHandler().callEvent(postEvent);
        } else {
            res = CommandResult.FAILED;
        }
        if (res == CommandResult.SUCCESS && sender instanceof Player) {
            COOLDOWN.add(((Player)sender).getUniqueId(), command.getCooldown());
        }
        if (res == CommandResult.ERROR && ctx.isPlayer()) {
            ctx.sendError(KingdomsLang.COMMANDS_ERROR, new Object[0]);
        }
        return res == CommandResult.SUCCESS;
    }

    public boolean onCommand(@NonNull CommandSender sender, @NonNull Command cmd, @NonNull String label, @NonNull String[] args) {
        return KingdomsCommandHandler.handle(KingdomsCommandHandler.parse(sender, args));
    }

    static {
        COOLDOWN = new Cooldown();
        KingdomsCommandHandler.initializeCommandsMap();
    }

    public static final class CommandInformation {
        public final KingdomsCommand command;
        protected final int cmdIndex;

        public CommandInformation(KingdomsCommand command, int cmdIndex) {
            this.command = command;
            this.cmdIndex = cmdIndex;
        }

        public String[] getCommandArguments(String[] args) {
            String[] cmdArgs = new String[args.length - this.cmdIndex];
            System.arraycopy(args, this.cmdIndex, cmdArgs, 0, cmdArgs.length);
            return cmdArgs;
        }

        public boolean hasPermission(CommandSender sender) {
            return !(sender instanceof Player) || this.command.hasPermission(sender) || KingdomPlayer.getKingdomPlayer((OfflinePlayer)((Player)sender)).isAdmin();
        }
    }
}

