/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommandHandler;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Unmodifiable;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.pieces.MessagePiece;
import org.kingdoms.locale.messenger.DefaultedMessenger;
import org.kingdoms.locale.messenger.LanguageEntryMessenger;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.permissions.BukkitPermission;
import org.kingdoms.server.permission.PermissionDefaultValue;
import org.kingdoms.utils.config.ConfigPath;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.internal.arrays.ArrayUtils;
import org.kingdoms.utils.internal.enumeration.QuickEnumMap;
import org.kingdoms.utils.internal.functional.Fn;
import org.kingdoms.utils.internal.nonnull.NonNullMap;
import org.kingdoms.utils.internal.string.StringMatcher;
import org.kingdoms.utils.time.TimeUtils;

public abstract class KingdomsCommand {
    protected static final Kingdoms plugin = Kingdoms.get();
    public static final boolean COLORIZE_TAB_COMPLETES = XReflection.supports((int)13) && KingdomsConfig.COMMAND_ENABLE_TAB_COLORIZATION.getBoolean();
    protected final @NonNull Permission permission;
    protected final @NonNull Permission bypassCooldownPermission;
    protected final @NonNull Permission bypassDisabledWorldsPermission;
    protected final @NonNull String name;
    protected final String[] path;
    protected final @Nullable KingdomsParentCommand parent;
    protected final @Nullable Messenger description;
    protected final @Nullable StringMatcher disabledWorlds;
    protected final @NonNull Map<Language, List<String>> aliases;
    protected final long cooldown;
    private static final String PATTERN = "[a-zA-Z0-9]+";
    private static final Pattern COMMAND_NODE_PATTERN = Pattern.compile("[a-zA-Z0-9]+");

    public KingdomsCommand(@org.kingdoms.libs.intellij.lang.annotations.Pattern(value="[a-zA-Z0-9]+") @NonNull String name, @Nullable KingdomsParentCommand parent, PermissionDefault permissionDefault) {
        boolean disabled;
        Objects.requireNonNull(name, "Command name cannot be null");
        if (!COMMAND_NODE_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Command name doesn't match patern: " + COMMAND_NODE_PATTERN.pattern());
        }
        this.name = name.toLowerCase(Locale.ENGLISH);
        this.parent = parent;
        String identifier = KingdomsCommand.calculatePermission(parent, this.name);
        this.path = ArrayUtils.merge(new String[]{"command"}, org.kingdoms.utils.string.Strings.splitArray(identifier, '.'));
        this.description = this.lang("description");
        ConfigSection section = KingdomsConfig.COMMANDS.getSection().getSection().getSection(KingdomsCommand.calculateConfigEntry(identifier));
        boolean bl = disabled = parent != null && parent.isDisabled();
        if (section != null) {
            String permDef;
            if (!disabled) {
                disabled = section.getBoolean("disabled");
            }
            if (!disabled && !Strings.isNullOrEmpty((String)(permDef = section.getString("permission-default")))) {
                permissionDefault = (PermissionDefault)BukkitPermission.DEFAULT_VALUE_MAPPING.get((Object)PermissionDefaultValue.valueOf(permDef));
            }
        }
        this.permission = new Permission("kingdoms.command." + identifier, this.description.parse(new Object[0]), permissionDefault == null ? (parent == null ? PermissionDefault.OP : parent.getPermission().getDefault()) : permissionDefault);
        this.bypassDisabledWorldsPermission = new Permission("kingdoms.command." + identifier + ".bypass.disabled-worlds", "Permission to use this command even when it's disabled in a certain world.");
        this.bypassCooldownPermission = new Permission("kingdoms.command." + identifier + ".bypass.cooldown", "Permission to bypass the command cooldown.");
        if (section != null || disabled) {
            if (disabled) {
                this.cooldown = 0L;
                this.disabledWorlds = null;
                this.aliases = null;
                return;
            }
            this.aliases = (Map)Fn.cast(NonNullMap.of(new QuickEnumMap((Enum[])SupportedLanguage.VALUES)));
            String cd = section.getString("cooldown");
            this.cooldown = Strings.isNullOrEmpty((String)cd) ? 0L : Optional.ofNullable(TimeUtils.parseTime(cd)).orElseThrow(() -> new IllegalArgumentException("Invalid time format for command cooldown " + this.name + ": " + cd));
            this.disabledWorlds = StringMatcher.parseAndGroup(section.getStringList("disabled-worlds"));
        } else {
            this.cooldown = 0L;
            this.aliases = (Map)Fn.cast(NonNullMap.of(new QuickEnumMap((Enum[])SupportedLanguage.VALUES)));
            this.disabledWorlds = null;
        }
        if (this instanceof Listener) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)Kingdoms.get());
        }
        if (permissionDefault == null && parent != null) {
            this.permission.setDefault(parent.getPermission().getDefault());
        }
        Bukkit.getPluginManager().addPermission(this.permission);
        Bukkit.getPluginManager().addPermission(this.bypassCooldownPermission);
        Bukkit.getPluginManager().addPermission(this.bypassDisabledWorldsPermission);
        Map<Language, Map<String, KingdomsCommand>> map = parent == null ? KingdomsCommandHandler.COMMANDS : parent.children;
        for (Language language : SupportedLanguage.getInstalled()) {
            Map cmdMap = map.computeIfAbsent(language, k -> new HashMap(1));
            try {
                MessageObject aliasesObj = this.lang("aliases").getMessageObject(language);
                MessageObject messageObjectBuilder = this.getDisplayName().getMessageObject(language);
                String mainName = messageObjectBuilder.buildPlain(MessagePlaceholderProvider.DEFAULT);
                cmdMap.put(mainName.toLowerCase(language.getLocale()), this);
                if (language == Language.getDefault()) {
                    cmdMap.put(name.toLowerCase(Language.getDefault().getLocale()), this);
                }
                if (aliasesObj != null) {
                    String[] aliases = org.kingdoms.utils.string.Strings.splitArray(aliasesObj.buildPlain(MessagePlaceholderProvider.DEFAULT), ' ');
                    this.aliases.put(language, Arrays.asList(aliases));
                    for (String alias : aliases) {
                        KingdomsCommand previous = cmdMap.put(alias.toLowerCase(language.getLocale()), this);
                        if (previous == null) continue;
                        KLogger.warn("The alias '" + alias + "' for command '" + identifier + "' has overridden command '" + previous.name + '\'');
                    }
                    continue;
                }
                this.aliases.put(language, Collections.emptyList());
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    public @Unmodifiable @NotNull Map<Language, List<String>> getAliases() {
        return Collections.unmodifiableMap(this.aliases);
    }

    public void setPermissionDefault(PermissionDefault permissionDefault) {
        this.permission.setDefault(permissionDefault);
    }

    public KingdomsCommand(@NonNull String name) {
        this(name, false);
    }

    public KingdomsCommand(@NonNull String name, boolean playersCmd) {
        this(name, null, (PermissionDefault)(playersCmd ? PermissionDefault.TRUE : null));
    }

    public KingdomsCommand(@org.kingdoms.libs.intellij.lang.annotations.Pattern(value="[a-zA-Z0-9]+") @NonNull String name, KingdomsParentCommand parent) {
        this(name, parent, null);
    }

    public void unregisterPermissions() {
        for (Permission perm : Arrays.asList(this.permission, this.bypassCooldownPermission, this.bypassDisabledWorldsPermission)) {
            Bukkit.getPluginManager().removePermission(perm);
        }
    }

    private static String[] calculateConfigEntry(String nameEntry) {
        return ConfigPath.buildRaw(org.kingdoms.utils.string.Strings.replace(nameEntry, '.', ".commands.").toString());
    }

    public boolean canBypassDisabledWorlds(CommandSender sender) {
        return sender.hasPermission(this.bypassDisabledWorldsPermission);
    }

    public boolean canBypassCooldown(CommandSender sender) {
        return sender.hasPermission(this.bypassCooldownPermission);
    }

    @Deprecated
    public static List<String> tabComplete(String completion) {
        return Collections.singletonList(CommandTabContext.processTabMessage(completion));
    }

    @Deprecated
    public static List<String> tabComplete(String ... completions) {
        for (int i = 0; i < completions.length; ++i) {
            completions[i] = CommandTabContext.processTabMessage(completions[i]);
        }
        return Arrays.asList(completions);
    }

    @Deprecated
    public static List<String> tabComplete(Collection<String> completions) {
        ArrayList<String> tabs = new ArrayList<String>(completions.size());
        for (String str : completions) {
            tabs.add(CommandTabContext.processTabMessage(str));
        }
        return tabs;
    }

    @Deprecated
    protected static List<String> emptyTab() {
        return Collections.emptyList();
    }

    public Messenger getUsage() {
        return this.lang("usage");
    }

    public @Nullable StringMatcher getDisabledWorlds() {
        return this.disabledWorlds;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    private static String calculatePermission(KingdomsParentCommand parent, String name) {
        KingdomsParentCommand lastGroup = parent;
        StringBuilder perms = new StringBuilder(50);
        while (lastGroup != null) {
            perms.insert(0, lastGroup.name + '.');
            lastGroup = lastGroup.parent;
        }
        return perms.append(name).toString();
    }

    protected boolean isDisabled() {
        return this.aliases == null;
    }

    public @NonNull Permission getPermission() {
        return this.permission;
    }

    public boolean hasPermission(@NonNull CommandSender sender) {
        return sender.hasPermission(this.permission);
    }

    public boolean hasPermission(CommandSender sender, String perm) {
        if (sender.hasPermission(perm)) {
            return true;
        }
        return sender instanceof Player && KingdomPlayer.getKingdomPlayer((OfflinePlayer)((Player)sender)).isAdmin();
    }

    public String toString() {
        KingdomsParentCommand lastGroupChk = this.parent;
        StringBuilder command = new StringBuilder(this.name);
        while (lastGroupChk != null) {
            command.insert(0, lastGroupChk.name + ' ');
            lastGroupChk = lastGroupChk.parent;
        }
        return command.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KingdomsCommand)) {
            return false;
        }
        KingdomsCommand cmd = (KingdomsCommand)obj;
        return this.name.equals(cmd.name) && Objects.equals(this.parent, cmd.parent);
    }

    public int hashCode() {
        int prime = 31;
        int result = 15;
        result = prime * result + this.name.hashCode();
        result = prime * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    @NotNull
    public Messenger lang(String ... path) {
        return new LanguageEntryMessenger(ArrayUtils.merge(this.path, path));
    }

    @ApiStatus.Experimental
    public void configure(@NonNull CommandContext context) {
    }

    @NotNull
    public abstract CommandResult execute(@NonNull CommandContext var1);

    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        return new ArrayList<String>();
    }

    public final @NonNull Messenger getDisplayName() {
        return new DefaultedMessenger(this.lang("name"), () -> new StaticMessenger(MessageObject.from(false, new MessagePiece.Plain(this.name))));
    }

    public final @NonNull String getName() {
        return this.name;
    }

    public final @Nullable KingdomsParentCommand getParent() {
        return this.parent;
    }

    public @Nullable Messenger getDescription() {
        return this.description;
    }
}

