/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands;

import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.ArraysKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.internals.KingdomsTimings;
import org.kingdoms.managers.land.holograms.TemporaryBuildingVisuals;
import org.kingdoms.utils.internal.numbers.Numbers;
import org.kingdoms.versioning.JavaVersion;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/kingdoms/commands/CommandAdminTimings;", "Lorg/kingdoms/commands/KingdomsCommand;", "parent", "Lorg/kingdoms/commands/KingdomsParentCommand;", "<init>", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "core"})
@SourceDebugExtension(value={"SMAP\nCommandAdminTimings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandAdminTimings.kt\norg/kingdoms/commands/CommandAdminTimings\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1#2:96\n774#3:97\n865#3,2:98\n774#3:100\n865#3,2:101\n774#3:103\n865#3,2:104\n*S KotlinDebug\n*F\n+ 1 CommandAdminTimings.kt\norg/kingdoms/commands/CommandAdminTimings\n*L\n69#1:97\n69#1:98,2\n70#1:100\n70#1:101,2\n71#1:103\n71#1:104,2\n*E\n"})
public final class CommandAdminTimings
extends KingdomsCommand {
    public CommandAdminTimings(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("timings", parent);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        int n;
        int n2;
        Object land22;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Kingdoms.isStrict() && !JavaVersion.supports(10)) {
            context.sendMessage((Messenger)new StaticMessenger("&cKingdoms timings is only supported on Java 10+ and higher."), new Object[0]);
            return CommandResult.FAILED;
        }
        if (!KingdomsTimings.isEnabled()) {
            KingdomsTimings.enable();
            context.sendMessage((Messenger)new StaticMessenger("&2Timings has been enabled. The only way to turn it off is to restart the server."), new Object[0]);
            return CommandResult.PARTIAL;
        }
        Collection lands = Kingdoms.get().getDataCenter().getLandManager().getLoadedData();
        int structures = 0;
        int turrets = 0;
        int totalHolograms = 0;
        for (Object land22 : lands) {
            int n3;
            int n4;
            Collection y;
            int n5;
            int n6;
            Iterable iterable;
            Turret x;
            boolean bl;
            structures += ((Land)land22).getStructures().size();
            turrets += ((Land)land22).getTurrets().size();
            Iterable iterable2 = ((Land)land22).getStructures().values();
            n2 = totalHolograms;
            int n7 = 0;
            for (Object e : iterable2) {
                Structure structure = (Structure)e;
                n = n7;
                bl = false;
                iterable = x.getVisualsManager().getHolograms().getEntities().values();
                n6 = 0;
                for (Object object : iterable) {
                    Collection collection = (Collection)object;
                    n5 = n6;
                    boolean bl2 = false;
                    n4 = y.size();
                    n6 = n5 + n4;
                }
                n3 = n6;
                n7 = n + n3;
            }
            n = n7;
            totalHolograms = n2 + n;
            iterable2 = ((Land)land22).getTurrets().values();
            n2 = totalHolograms;
            n7 = 0;
            for (Object e : iterable2) {
                x = (Turret)e;
                n = n7;
                bl = false;
                iterable = x.getVisualsManager().getHolograms().getEntities().values();
                n6 = 0;
                for (Object object : iterable) {
                    y = (Collection)object;
                    n5 = n6;
                    boolean bl3 = false;
                    n4 = y.size();
                    n6 = n5 + n4;
                }
                n3 = n6;
                n7 = n + n3;
            }
            n = n7;
            totalHolograms = n2 + n;
        }
        land22 = TemporaryBuildingVisuals.TEMPORARY_HOLOGRAMS.values();
        int n8 = 0;
        Iterator iterator = land22.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            Map map = (Map)t;
            n2 = n8;
            boolean bl = false;
            n = map.size();
            n8 = n2 + n;
        }
        int tempHolograms = n8;
        context.getMessageContext().ensurePlaceholdersCapacity(10).raw("started", System.currentTimeMillis() - KingdomsTimings.getStarted()).raw("lands", lands.size()).raw("structures", structures).raw("turrets", turrets).raw("totalHolograms", totalHolograms).raw("tempHolograms", tempHolograms);
        context.sendMessage((Messenger)new StaticMessenger("{$sep}| {$p}Started{$sep}: {$s}%time_started%\n{$sep}| {$p}Lands{$sep}: {$s}%lands%\n{$sep}| {$p}Structures{$sep}: {$s}%structures%\n{$sep}| {$p}Turrets{$sep}: {$s}%turrets%\n{$sep}| {$p}Holograms{$sep}: {$s}%totalHolograms%\n{$sep}| {$p}Temporary Holograms{$sep}: {$s}%tempHolograms%\n"), new Object[0]);
        long time = System.currentTimeMillis();
        StaticMessenger format = new StaticMessenger("&2%src%\n   &7-> &6%fiveMins% &8| &6%tenMins% &8| &6%fifteenMins% &8| &6%total% &8| &6%avg%");
        context.getMessageContext().raw("src", "Source").raw("fiveMins", "5mins").raw("tenMins", "10mins").raw("fifteenMins", "15mins").raw("total", "total").raw("avg", "Avg times per min");
        context.sendMessage((Messenger)format, new Object[0]);
        context.sendMessage((Messenger)new StaticMessenger("&8----------------------------------------------"), new Object[0]);
        Map<Object, LinkedList<Long>> map = KingdomsTimings.TIMINGS;
        Intrinsics.checkNotNullExpressionValue(map, (String)"TIMINGS");
        for (Map.Entry entry : map.entrySet()) {
            MessagePlaceholderProvider messagePlaceholderProvider;
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            void $this$filterTo$iv$iv3;
            Object object;
            Object meth = entry.getKey();
            LinkedList timings = (LinkedList)entry.getValue();
            Intrinsics.checkNotNull((Object)timings);
            Iterable $this$filter$iv = timings;
            boolean $i$f$filter = false;
            object = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                Long x = (Long)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)x);
                if (!(Duration.ofMillis(time - x).toMinutes() <= 5L)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List fiveMins = (List)destination$iv$iv;
            Iterable $this$filter$iv2 = timings;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Long x = (Long)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)x);
                if (!(Duration.ofMillis(time - x).toMinutes() <= 10L)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List tenMins = (List)destination$iv$iv2;
            Iterable $this$filter$iv3 = timings;
            boolean $i$f$filter3 = false;
            destination$iv$iv2 = $this$filter$iv3;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Long x = (Long)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)x);
                if (!(Duration.ofMillis(time - x).toMinutes() <= 15L)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List fifteenMins = (List)destination$iv$iv3;
            if (meth instanceof Method) {
                MessagePlaceholderProvider messagePlaceholderProvider2 = context.getMessageContext();
                StringBuilder stringBuilder = new StringBuilder().append(((Method)meth).getDeclaringClass().getSimpleName()).append('.').append(((Method)meth).getName()).append('(');
                Class<?>[] classArray = ((Method)meth).getParameterTypes();
                Intrinsics.checkNotNullExpressionValue(classArray, (String)"getParameterTypes(...)");
                messagePlaceholderProvider = messagePlaceholderProvider2.raw("src", stringBuilder.append(ArraysKt.joinToString$default((Object[])classArray, (CharSequence)", ", null, null, (int)0, null, CommandAdminTimings::execute$lambda$8, (int)30, null)).append(')').toString());
            } else {
                messagePlaceholderProvider = context.getMessageContext().raw("src", meth);
            }
            context.getMessageContext().raw("fiveMins", fiveMins.size()).raw("tenMins", tenMins.size()).raw("fifteenMins", fifteenMins.size()).raw("total", timings.size()).raw("avg", Numbers.toFancyNumber(KingdomsTimings.getAverageTimesPerMinute(timings)));
            context.sendMessage((Messenger)format, new Object[0]);
        }
        return CommandResult.SUCCESS;
    }

    private static final CharSequence execute$lambda$8(Class x) {
        String string = x.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return string;
    }
}

