/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands;

import java.time.Duration;
import org.bukkit.Bukkit;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.data.centers.KingdomsDataCenter;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.managers.base.DataManager;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.TempKingdomsFolder;
import org.kingdoms.managers.backup.FolderZipper;
import org.kingdoms.managers.backup.KingdomsBackup;
import org.kingdoms.scheduler.TaskScheduler;
import org.kingdoms.utils.fs.FSUtil;
import org.kingdoms.utils.internal.functional.Fn;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lorg/kingdoms/commands/CommandAdminMigrateDatabase;", "Lorg/kingdoms/commands/KingdomsCommand;", "parentCommand", "Lorg/kingdoms/commands/KingdomsParentCommand;", "<init>", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "loadAllData", "", "saveAll", "dataCenter", "Lorg/kingdoms/data/centers/KingdomsDataCenter;", "msg", "", "createNewDataCenterAndSaveAll", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "newDBType", "getNewDBType", "()Ljava/lang/String;", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nCommandAdminMigrate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandAdminMigrate.kt\norg/kingdoms/commands/CommandAdminMigrateDatabase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1863#2,2:142\n1863#2:148\n1864#2:150\n12567#3,2:144\n12567#3,2:146\n1#4:149\n*S KotlinDebug\n*F\n+ 1 CommandAdminMigrate.kt\norg/kingdoms/commands/CommandAdminMigrateDatabase\n*L\n67#1:142,2\n76#1:148\n76#1:150\n71#1:144,2\n72#1:146,2\n*E\n"})
public final class CommandAdminMigrateDatabase
extends KingdomsCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static long executionCooldown;
    private static long migrationCooldown;
    private static final String oldDbType;
    private static boolean wait;

    public CommandAdminMigrateDatabase(@NotNull KingdomsParentCommand parentCommand) {
        Intrinsics.checkNotNullParameter((Object)parentCommand, (String)"parentCommand");
        super("database", parentCommand);
    }

    private final void loadAllData() {
        KingdomsDataCenter dataCenter = Kingdoms.get().getDataCenter();
        this.msg("&2Loading all data... This might take several minutes.");
        for (DataManager<?> dataManager : dataCenter.getAllDataManagers()) {
            this.msg("  &8| &2Loading " + dataManager + " data...");
            dataManager.loadAllData(true);
            this.msg("  &8| &2Loaded " + dataManager + " data.");
        }
    }

    private final void saveAll(KingdomsDataCenter dataCenter) {
        this.msg("&2Saving all data... This might take several minutes.");
        for (DataManager<?> dataManager : dataCenter.getAllDataManagers()) {
            this.msg("  &8| &2Saving " + dataManager + " data...");
            dataManager.saveAll(false);
            this.msg("  &8| &2Saved " + dataManager + " data.");
        }
    }

    private final void msg(String msg) {
        MessageHandler.sendConsolePluginMessage(msg);
    }

    /*
     * Unable to fully structure code
     */
    private final void createNewDataCenterAndSaveAll() {
        block8: {
            block7: {
                oldDataCenter = Kingdoms.get().getDataCenter();
                this.msg("&2Taking a backup before migrating...");
                from = TempKingdomsFolder.getOrCreateFolder("backup");
                zipTo = FSUtil.findSlotForCounterFile(KingdomsBackup.BACKUPS_FOLDER, "data-migration-" + CommandAdminMigrateDatabase.oldDbType + '-' + this.getNewDBType(), "zip");
                KingdomsBackup.backupData(from);
                this.msg("&2Zipping backup files from &6" + from + " &8-> &6" + zipTo);
                Intrinsics.checkNotNull((Object)from);
                Intrinsics.checkNotNull((Object)zipTo);
                FolderZipper.Companion.zip$default(FolderZipper.Companion, null, from, zipTo, false, 8, null);
                this.msg("&2Creating new data center...");
                v0 = oldDataCenter.getAllDataManagers();
                Intrinsics.checkNotNullExpressionValue(v0, (String)"getAllDataManagers(...)");
                $this$forEach$iv = v0;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    x = (DataManager)element$iv;
                    $i$a$-forEach-CommandAdminMigrateDatabase$createNewDataCenterAndSaveAll$1 = false;
                    x.setSavingState(false);
                }
                newDataCenter = KingdomsDataCenter.createDefault();
                var6_7 = new DatabaseType[]{DatabaseType.JSON, DatabaseType.YAML};
                $this$any$iv = conflictingDBTypes = var6_7;
                $i$f$any = false;
                var10_14 = $this$any$iv.length;
                for (var9_12 = 0; var9_12 < var10_14; ++var9_12) {
                    it = element$iv = $this$any$iv[var9_12];
                    $i$a$-any-CommandAdminMigrateDatabase$createNewDataCenterAndSaveAll$requiresDeleting$1 = false;
                    if (!StringsKt.equals((String)it.name(), (String)CommandAdminMigrateDatabase.oldDbType, (boolean)true)) continue;
                    v1 = true;
                    break block7;
                }
                v1 = false;
            }
            if (!v1) ** GOTO lbl-1000
            $this$any$iv = conflictingDBTypes;
            $i$f$any = false;
            var10_14 = $this$any$iv.length;
            for (var9_12 = 0; var9_12 < var10_14; ++var9_12) {
                it = element$iv = $this$any$iv[var9_12];
                $i$a$-any-CommandAdminMigrateDatabase$createNewDataCenterAndSaveAll$requiresDeleting$2 = false;
                if (!StringsKt.equals((String)it.name(), (String)this.getNewDBType(), (boolean)true)) continue;
                v2 = true;
                break block8;
            }
            v2 = false;
        }
        if (v2) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        requiresDeleting = v3;
        this.msg("&2Transferring data between data centers: " + oldDataCenter.getDatabaseType().name() + " -> " + newDataCenter.getDatabaseType().name());
        this.msg("&eConflicting database types detected&8: &c" + CommandAdminMigrateDatabase.oldDbType + " &8-> &c" + this.getNewDBType() + " &ethe old database will be deleted.");
        v4 = oldDataCenter.getAllDataManagers();
        Intrinsics.checkNotNullExpressionValue(v4, (String)"getAllDataManagers(...)");
        $this$forEach$iv = v4;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            block9: {
                oldDataManager = (DataManager)element$iv;
                $i$a$-forEach-CommandAdminMigrateDatabase$createNewDataCenterAndSaveAll$2 = false;
                v5 = newDataCenter.getAllDataManagers();
                Intrinsics.checkNotNullExpressionValue(v5, (String)"getAllDataManagers(...)");
                var13_20 = v5;
                for (T var15_22 : var13_20) {
                    y = (DataManager)var15_22;
                    $i$a$-find-CommandAdminMigrateDatabase$createNewDataCenterAndSaveAll$2$newDataManager$1 = false;
                    if (!(oldDataManager.getClass() == y.getClass())) continue;
                    v6 = var15_22;
                    break block9;
                }
                v6 = null;
            }
            Intrinsics.checkNotNull(v6);
            newDataManager = v6;
            this.msg("-------------------------------------");
            this.msg("  &8| &9Transferring " + oldDataManager + " -> " + newDataManager);
            oldDataManager.copyAllDataTo((DataManager)Fn.cast(newDataManager));
            this.msg("  &8| &9Transferred: " + oldDataManager + " -> " + newDataManager);
            if (!requiresDeleting) continue;
            this.msg("  &8| &9Deleting " + oldDataManager + "...");
            oldDataManager.deleteAllData();
            this.msg("  &8| &9Deleted " + oldDataManager);
        }
        Kingdoms.get().setDataCenter(newDataCenter);
        Intrinsics.checkNotNull((Object)newDataCenter);
        this.saveAll(newDataCenter);
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isPlayer()) {
            CommandResult commandResult = context.fail(KingdomsLang.COMMAND_ADMIN_MIGRATE_DATABASE_CONSOLE_ONLY);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        if (wait) {
            CommandResult commandResult = context.fail(KingdomsLang.COMMAND_ADMIN_MIGRATE_DATABASE_PLEASE_WAIT);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        long now = System.currentTimeMillis();
        if (migrationCooldown != 0L && now - migrationCooldown <= Duration.ofMinutes(5L).toMillis()) {
            KingdomsConfig.MAIN.reload();
            if (StringsKt.equals((String)oldDbType, (String)this.getNewDBType(), (boolean)true)) {
                context.var("method", this.getNewDBType());
                CommandResult commandResult = context.fail(KingdomsLang.COMMAND_ADMIN_MIGRATE_DATABASE_SAME_DATABASE_TYPE);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
                return commandResult;
            }
            wait = true;
            Kingdoms.taskScheduler().async().execute(() -> CommandAdminMigrateDatabase.execute$lambda$6(this, context));
            return CommandResult.SUCCESS;
        }
        if (now - executionCooldown >= Duration.ofSeconds(5L).toMillis()) {
            executionCooldown = now;
            context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_MIGRATE_DATABASE_COOLDOWN, new Object[0]);
            return CommandResult.PARTIAL;
        }
        wait = true;
        Kingdoms.taskScheduler().async().execute(() -> CommandAdminMigrateDatabase.execute$lambda$7(this, now, context));
        return CommandResult.SUCCESS;
    }

    private final String getNewDBType() {
        return KingdomsConfig.DATABASE_METHOD.getString();
    }

    private static final void execute$lambda$6$lambda$5() {
        Bukkit.shutdown();
    }

    private static final void execute$lambda$6(CommandAdminMigrateDatabase this$0, CommandContext $context) {
        try {
            this$0.createNewDataCenterAndSaveAll();
            $context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_MIGRATE_DATABASE_DONE, new Object[0]);
            TaskScheduler taskScheduler = Kingdoms.taskScheduler().sync();
            Duration duration = Duration.ofSeconds(10L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
            taskScheduler.delayed(duration, CommandAdminMigrateDatabase::execute$lambda$6$lambda$5);
        }
        catch (Throwable ex) {
            $context.sendError(KingdomsLang.COMMAND_ADMIN_MIGRATE_DATABASE_ERROR_LOADING_NEW_DATABASE, new Object[0]);
            ex.printStackTrace();
        }
    }

    private static final void execute$lambda$7(CommandAdminMigrateDatabase this$0, long $now, CommandContext $context) {
        KingdomsDataCenter kingdomsDataCenter = Kingdoms.get().getDataCenter();
        Intrinsics.checkNotNullExpressionValue((Object)kingdomsDataCenter, (String)"getDataCenter(...)");
        this$0.saveAll(kingdomsDataCenter);
        this$0.loadAllData();
        migrationCooldown = $now;
        $context.sendMessage((Messenger)KingdomsLang.COMMAND_ADMIN_MIGRATE_DATABASE_START, new Object[0]);
        wait = false;
    }

    static {
        oldDbType = KingdomsConfig.DATABASE_METHOD.getString();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/kingdoms/commands/CommandAdminMigrateDatabase$Companion;", "", "<init>", "()V", "executionCooldown", "", "migrationCooldown", "oldDbType", "", "org.kingdoms.libs.kotlin.jvm.PlatformType", "Ljava/lang/String;", "wait", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

